/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Arrays;
import java.util.Iterator;
import org.exist.dom.AbstractNodeSet;
import org.exist.dom.ByDocumentIterator;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.VirtualNodeSet;
import org.exist.numbering.NodeId;
import org.exist.util.FastQSort;
import org.exist.util.hashtable.ObjectHashSet;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;
import org.w3c.dom.Node;

public class NewArrayNodeSet
extends AbstractNodeSet
implements ExtNodeSet {
    private static final int INITIAL_DOC_SIZE = 64;
    private int[] documentIds = new int[16];
    private int[] documentOffsets = new int[16];
    private int[] documentLengths = new int[16];
    private int documentCount = 0;
    private NodeProxy[] nodes = new NodeProxy[64];
    protected int size = 0;
    private boolean isSorted = false;
    private boolean hasOne = false;
    protected NodeProxy lastAdded = null;
    private int state = 0;
    private DocumentSet cachedDocuments = null;
    private int itemType = 12;

    public NewArrayNodeSet() {
    }

    public NewArrayNodeSet(int initialDocsCount, int initialArraySize) {
    }

    public NewArrayNodeSet(int initialArraySize) {
    }

    public void reset() {
        Arrays.fill(this.nodes, null);
        this.documentCount = 0;
        this.size = 0;
        this.isSorted = false;
        this.state = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean hasOne() {
        return this.hasOne;
    }

    private void ensureCapacity() {
        if (this.size == this.nodes.length) {
            int nsize = this.size << 1;
            NodeProxy[] temp = new NodeProxy[nsize];
            System.arraycopy(this.nodes, 0, temp, 0, this.size);
            this.nodes = temp;
        }
    }

    public void add(NodeProxy proxy) {
        if (this.size > 0) {
            if (this.hasOne) {
                this.hasOne = this.isSorted ? this.get(proxy) != null : this.lastAdded == null || this.lastAdded.compareTo(proxy) == 0;
            }
        } else {
            this.hasOne = true;
        }
        this.ensureCapacity();
        this.nodes[this.size++] = proxy;
        this.isSorted = false;
        this.setHasChanged();
        this.checkItemType(proxy.getType());
        this.lastAdded = proxy;
    }

    public void add(NodeProxy proxy, int sizeHint) {
        this.add(proxy);
    }

    public void addAll(NodeSet other) {
        if (other.isEmpty()) {
            return;
        }
        if (other.hasOne()) {
            this.add((NodeProxy)other.itemAt(0));
        } else {
            NodeSetIterator i = other.iterator();
            while (i.hasNext()) {
                this.add((NodeProxy)i.next());
            }
        }
    }

    private void checkItemType(int type) {
        if (this.itemType == -1 || this.itemType == type) {
            return;
        }
        this.itemType = this.itemType == 12 ? type : -1;
    }

    public int getItemType() {
        return this.itemType;
    }

    private void setHasChanged() {
        this.state = this.state == Integer.MAX_VALUE ? (this.state = 0) : this.state + 1;
        this.cachedDocuments = null;
    }

    private int findDoc(DocumentImpl doc) {
        return this.findDoc(doc.getDocId());
    }

    private int findDoc(int docId) {
        int low = 0;
        int high = this.documentCount - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = this.documentIds[mid];
            if (midVal < docId) {
                low = mid + 1;
                continue;
            }
            if (midVal > docId) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int getSizeHint(DocumentImpl doc) {
        int idx;
        if (!this.isSorted()) {
            this.sort();
        }
        return (idx = this.findDoc(doc)) < 0 ? -1 : this.documentLengths[idx];
    }

    public NodeSetIterator iterator() {
        if (!this.isSorted()) {
            this.sort();
        }
        return new NewArrayIterator();
    }

    public SequenceIterator iterate() throws XPathException {
        this.sortInDocumentOrder();
        return new NewArrayIterator();
    }

    public SequenceIterator unorderedIterator() {
        if (!this.isSorted()) {
            this.sort();
        }
        return new NewArrayIterator();
    }

    public ByDocumentIterator iterateByDocument() {
        if (!this.isSorted()) {
            this.sort();
        }
        return new NewDocIterator();
    }

    private NodeProxy get(int docIdx, NodeId nodeId) {
        if (!this.isSorted()) {
            this.sort();
        }
        int low = this.documentOffsets[docIdx];
        int high = low + (this.documentLengths[docIdx] - 1);
        while (low <= high) {
            int mid = (low + high) / 2;
            NodeProxy p = this.nodes[mid];
            int cmp = p.getNodeId().compareTo(nodeId);
            if (cmp == 0) {
                return p;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return null;
    }

    public int getLength() {
        if (!this.isSorted()) {
            this.sort();
        }
        return this.size;
    }

    public int getItemCount() {
        if (!this.isSorted()) {
            this.sort();
        }
        return this.size;
    }

    public Node item(int pos) {
        this.sortInDocumentOrder();
        NodeProxy p = this.get(pos);
        return p == null ? null : p.getNode();
    }

    public NodeProxy get(int pos) {
        if (pos < 0 || pos >= this.size) {
            return null;
        }
        return this.nodes[pos];
    }

    public boolean contains(NodeProxy proxy) {
        this.sort();
        int idx = this.findDoc(proxy.getDocument());
        if (idx < 0) {
            return false;
        }
        return this.get(idx, proxy.getNodeId()) != null;
    }

    public NodeProxy get(NodeProxy proxy) {
        this.sort();
        int idx = this.findDoc(proxy.getDocument());
        if (idx < 0) {
            return null;
        }
        return this.get(idx, proxy.getNodeId());
    }

    public NodeProxy get(DocumentImpl doc, NodeId nodeId) {
        this.sort();
        int idx = this.findDoc(doc);
        if (idx < 0) {
            return null;
        }
        return this.get(idx, nodeId);
    }

    public Item itemAt(int pos) {
        this.sortInDocumentOrder();
        return this.get(pos);
    }

    public NodeSet getDescendantsInSet(NodeSet al, boolean childOnly, boolean includeSelf, int mode, int contextId) {
        this.sort();
        NewArrayNodeSet result = new NewArrayNodeSet();
        NodeSetIterator i = al.iterator();
        while (i.hasNext()) {
            NodeProxy node = (NodeProxy)i.next();
            int docIdx = this.findDoc(node.getDocument());
            if (docIdx <= -1) continue;
            this.getDescendantsInSet(docIdx, result, node, childOnly, includeSelf, mode, contextId);
        }
        return result;
    }

    private NodeSet getDescendantsInSet(int docIdx, NodeSet result, NodeProxy parent, boolean childOnly, boolean includeSelf, int mode, int contextId) {
        NodeId parentId = parent.getNodeId();
        if (parentId == NodeId.DOCUMENT_NODE) {
            int end = this.documentOffsets[docIdx] + this.documentLengths[docIdx];
            block8: for (int i = this.documentOffsets[docIdx]; i < end; ++i) {
                boolean add;
                if (childOnly) {
                    add = this.nodes[i].getNodeId().getTreeLevel() == 1;
                } else if (includeSelf) {
                    add = true;
                } else {
                    boolean bl = add = this.nodes[i].getNodeId() != NodeId.DOCUMENT_NODE;
                }
                if (!add) continue;
                switch (mode) {
                    case 1: {
                        if (-1 != contextId) {
                            this.nodes[i].deepCopyContext(parent, contextId);
                        } else {
                            this.nodes[i].copyContext(parent);
                        }
                        this.nodes[i].addMatches(parent);
                        result.add(this.nodes[i]);
                        continue block8;
                    }
                    case 0: {
                        if (-1 != contextId) {
                            parent.deepCopyContext(this.nodes[i], contextId);
                        } else {
                            parent.copyContext(this.nodes[i]);
                        }
                        parent.addMatches(this.nodes[i]);
                        result.add(parent, 1);
                    }
                }
            }
        } else {
            int cmp;
            NodeProxy p;
            int low = this.documentOffsets[docIdx];
            int high = low + (this.documentLengths[docIdx] - 1);
            int end = low + this.documentLengths[docIdx];
            int mid = low;
            while (low <= high && !(p = this.nodes[mid = (low + high) / 2]).getNodeId().isDescendantOrSelfOf(parentId)) {
                cmp = p.getNodeId().compareTo(parentId);
                if (cmp > 0) {
                    high = mid - 1;
                    continue;
                }
                low = mid + 1;
            }
            if (low > high) {
                return result;
            }
            while (mid > this.documentOffsets[docIdx] && this.nodes[mid - 1].getNodeId().compareTo(parentId) > -1) {
                --mid;
            }
            block11: for (int i = mid; i < end && (cmp = this.nodes[i].getNodeId().computeRelation(parentId)) > -1; ++i) {
                boolean add = true;
                if (childOnly) {
                    add = cmp == 1;
                } else if (cmp == 3) {
                    add = includeSelf;
                }
                if (!add) continue;
                switch (mode) {
                    case 1: {
                        if (-1 != contextId) {
                            this.nodes[i].deepCopyContext(parent, contextId);
                        } else {
                            this.nodes[i].copyContext(parent);
                        }
                        this.nodes[i].addMatches(parent);
                        result.add(this.nodes[i]);
                        continue block11;
                    }
                    case 0: {
                        if (-1 != contextId) {
                            parent.deepCopyContext(this.nodes[i], contextId);
                        } else {
                            parent.copyContext(this.nodes[i]);
                        }
                        parent.addMatches(this.nodes[i]);
                        result.add(parent, 1);
                    }
                }
            }
        }
        return result;
    }

    public NodeProxy hasDescendantsInSet(DocumentImpl doc, NodeId ancestorId, boolean includeSelf, int contextId) {
        this.sort();
        int docIdx = this.findDoc(doc);
        if (docIdx < 0) {
            return null;
        }
        return this.hasDescendantsInSet(docIdx, ancestorId, contextId, includeSelf);
    }

    private NodeProxy hasDescendantsInSet(int docIdx, NodeId ancestorId, int contextId, boolean includeSelf) {
        int cmp;
        NodeId id;
        int low = this.documentOffsets[docIdx];
        int high = low + (this.documentLengths[docIdx] - 1);
        int end = low + this.documentLengths[docIdx];
        int mid = 0;
        while (low <= high && !(id = this.nodes[mid = (low + high) / 2].getNodeId()).isDescendantOrSelfOf(ancestorId)) {
            cmp = id.compareTo(ancestorId);
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        if (low > high) {
            return null;
        }
        while (mid > this.documentOffsets[docIdx] && this.nodes[mid - 1].getNodeId().compareTo(ancestorId) >= 0) {
            --mid;
        }
        NodeProxy ancestor = new NodeProxy(this.nodes[this.documentOffsets[docIdx]].getDocument(), ancestorId, 1);
        boolean foundOne = false;
        for (int i = mid; i < end && (cmp = this.nodes[i].getNodeId().computeRelation(ancestorId)) > -1; ++i) {
            boolean add = true;
            if (cmp == 3) {
                add = includeSelf;
            }
            if (!add) continue;
            if (-1 != contextId) {
                ancestor.deepCopyContext(this.nodes[i], contextId);
            } else {
                ancestor.copyContext(this.nodes[i]);
            }
            ancestor.addMatches(this.nodes[i]);
            foundOne = true;
        }
        return foundOne ? ancestor : null;
    }

    public NodeSet selectParentChild(NodeSet al, int mode, int contextId) {
        this.sort();
        if (al instanceof VirtualNodeSet) {
            return super.selectParentChild(al, mode, contextId);
        }
        return this.getDescendantsInSet(al, true, false, mode, contextId);
    }

    public NodeSet filterDocuments(NewArrayNodeSet other) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        for (int i = 0; i < other.size; ++i) {
            int idx = this.findDoc(other.nodes[i].getDocument().getDocId());
            if (idx <= -1) continue;
            result.add(other.nodes[i]);
        }
        return result;
    }

    private boolean isSorted() {
        return this.isSorted;
    }

    public void setSorted(DocumentImpl document, boolean sorted) {
    }

    public void mergeDuplicates() {
        this.sort(true);
    }

    public void sort() {
        this.sort(false);
    }

    public void sort(boolean mergeContexts) {
        if (this.isSorted) {
            return;
        }
        if (this.hasOne) {
            this.isSorted = true;
            this.removeDuplicates(mergeContexts);
            this.updateDocs();
            return;
        }
        if (this.size > 0) {
            FastQSort.sort(this.nodes, 0, this.size - 1);
            this.removeDuplicates(mergeContexts);
        }
        this.updateDocs();
        this.isSorted = true;
    }

    private void updateDocs() {
        if (this.size == 1) {
            this.documentIds[0] = this.nodes[0].getDocument().getDocId();
            this.documentOffsets[0] = 0;
            this.documentLengths[0] = 1;
            this.documentCount = 1;
        } else {
            this.documentCount = 0;
            for (int i = 0; i < this.size; ++i) {
                if (i == 0) {
                    this.documentIds[0] = this.nodes[0].getDocument().getDocId();
                    this.documentOffsets[0] = 0;
                    this.documentLengths[0] = 1;
                    ++this.documentCount;
                    continue;
                }
                if (this.documentIds[this.documentCount - 1] == this.nodes[i].getDocument().getDocId()) {
                    int n = this.documentCount - 1;
                    this.documentLengths[n] = this.documentLengths[n] + 1;
                    continue;
                }
                this.ensureDocCapacity();
                this.documentIds[this.documentCount] = this.nodes[i].getDocument().getDocId();
                this.documentOffsets[this.documentCount] = i;
                this.documentLengths[this.documentCount++] = 1;
            }
        }
    }

    private void ensureDocCapacity() {
        if (this.documentCount == this.documentIds.length) {
            int nlen = this.documentCount << 1;
            int[] temp = new int[nlen];
            System.arraycopy(this.documentIds, 0, temp, 0, this.documentCount);
            this.documentIds = temp;
            temp = new int[nlen];
            System.arraycopy(this.documentOffsets, 0, temp, 0, this.documentCount);
            this.documentOffsets = temp;
            temp = new int[nlen];
            System.arraycopy(this.documentLengths, 0, temp, 0, this.documentCount);
            this.documentLengths = temp;
        }
    }

    public final void sortInDocumentOrder() {
        this.sort(false);
    }

    int removeDuplicates(boolean mergeContext) {
        int j = 0;
        for (int i = 1; i < this.size; ++i) {
            if (this.nodes[i].compareTo(this.nodes[j]) != 0) {
                if (i == ++j) continue;
                this.nodes[j] = this.nodes[i];
                continue;
            }
            if (mergeContext) {
                this.nodes[j].addContext(this.nodes[i]);
            }
            this.nodes[j].addMatches(this.nodes[i]);
        }
        this.size = ++j;
        return this.size;
    }

    public void setSelfAsContext(int contextId) {
        for (int i = 0; i < this.size; ++i) {
            this.nodes[i].addContextNode(contextId, this.nodes[i]);
        }
    }

    public NodeSet selectAncestorDescendant(NodeSet al, int mode, boolean includeSelf, int contextId) {
        this.sort();
        if (al instanceof VirtualNodeSet) {
            return super.selectAncestorDescendant(al, mode, includeSelf, contextId);
        }
        return this.getDescendantsInSet(al, false, includeSelf, mode, contextId);
    }

    public NodeSet selectPrecedingSiblings(NodeSet siblings, int contextId) {
        this.sort();
        return super.selectPrecedingSiblings(siblings, contextId);
    }

    public NodeSet selectFollowingSiblings(NodeSet siblings, int contextId) {
        this.sort();
        return super.selectFollowingSiblings(siblings, contextId);
    }

    public NodeSet selectAncestors(NodeSet al, boolean includeSelf, int contextId) {
        this.sort();
        return super.selectAncestors(al, includeSelf, contextId);
    }

    public NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean directParent, boolean includeSelf) {
        this.sort();
        int docIdx = this.findDoc(doc);
        if (docIdx < 0) {
            return null;
        }
        return this.parentWithChild(docIdx, nodeId, directParent, includeSelf);
    }

    private NodeProxy parentWithChild(int docIdx, NodeId nodeId, boolean directParent, boolean includeSelf) {
        NodeProxy temp;
        if (includeSelf && (temp = this.get(docIdx, nodeId)) != null) {
            return temp;
        }
        for (nodeId = nodeId.getParentId(); nodeId != null; nodeId = nodeId.getParentId()) {
            temp = this.get(docIdx, nodeId);
            if (temp != null) {
                return temp;
            }
            if (!directParent) continue;
            return null;
        }
        return null;
    }

    public String debugParts() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.documentCount; ++i) {
            buf.append(this.documentIds[i]);
            buf.append(' ');
        }
        return buf.toString();
    }

    public int getIndexType() {
        if (this.indexType == 12) {
            this.hasTextIndex = true;
            this.hasMixedContent = true;
            for (int i = 0; i < this.size; ++i) {
                NodeProxy node = this.nodes[i];
                if (node.getDocument().getCollection().isTempCollection()) {
                    this.indexType = 11;
                    this.hasTextIndex = false;
                    this.hasMixedContent = false;
                    break;
                }
                int nodeIndexType = node.getIndexType();
                if (this.indexType == 12) {
                    this.indexType = nodeIndexType;
                } else if (this.indexType != nodeIndexType) {
                    this.indexType = 11;
                }
                if (!node.hasTextIndex()) {
                    this.hasTextIndex = false;
                }
                if (node.hasMixedContent()) continue;
                this.hasMixedContent = false;
            }
        }
        return this.indexType;
    }

    public DocumentSet getDocumentSet() {
        if (this.cachedDocuments != null) {
            return this.cachedDocuments;
        }
        this.sort();
        this.cachedDocuments = new DocumentSet(this.documentCount);
        for (int i = 0; i < this.documentCount; ++i) {
            this.cachedDocuments.add(this.nodes[this.documentOffsets[i]].getDocument(), false);
        }
        this.isSorted = true;
        return this.cachedDocuments;
    }

    public void setDocumentSet(DocumentSet docs) {
        this.cachedDocuments = docs;
    }

    public Iterator getCollectionIterator() {
        this.sort();
        return new CollectionIterator();
    }

    public boolean hasChanged(int previousState) {
        return this.state != previousState;
    }

    public int getState() {
        return this.state;
    }

    public boolean isCacheable() {
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("ExtArrayTree#").append(super.toString());
        return result.toString();
    }

    private class NewDocIterator
    implements ByDocumentIterator {
        int docIdx = 0;
        int pos = 0;
        NodeProxy next = null;

        public NewDocIterator() {
            if (NewArrayNodeSet.this.documentCount > 0) {
                this.next = NewArrayNodeSet.this.nodes[0];
            }
        }

        public void nextDocument(DocumentImpl document) {
            this.docIdx = NewArrayNodeSet.this.findDoc(document);
            this.next = null;
            if (this.docIdx > -1) {
                this.pos = 0;
                this.next = NewArrayNodeSet.this.nodes[NewArrayNodeSet.this.documentOffsets[this.docIdx]];
            }
        }

        public boolean hasNextNode() {
            return this.next != null;
        }

        public NodeProxy nextNode() {
            if (this.next == null) {
                return null;
            }
            NodeProxy n = this.next;
            this.next = null;
            if (++this.pos < NewArrayNodeSet.this.documentLengths[this.docIdx]) {
                this.next = NewArrayNodeSet.this.nodes[NewArrayNodeSet.this.documentOffsets[this.docIdx] + this.pos];
            }
            return n;
        }

        public NodeProxy peekNode() {
            return this.next;
        }

        public void setPosition(NodeProxy node) {
            this.next = null;
            this.docIdx = NewArrayNodeSet.this.findDoc(node.getDocument());
            if (this.docIdx > -1) {
                int low = NewArrayNodeSet.this.documentOffsets[this.docIdx];
                int high = low + (NewArrayNodeSet.this.documentLengths[this.docIdx] - 1);
                while (low <= high) {
                    int mid = (low + high) / 2;
                    NodeProxy p = NewArrayNodeSet.this.nodes[mid];
                    int cmp = p.getNodeId().compareTo(node.getNodeId());
                    if (cmp == 0) {
                        this.pos = mid - NewArrayNodeSet.this.documentOffsets[this.docIdx];
                        return;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    low = mid + 1;
                }
            }
        }
    }

    private class NewArrayIterator
    implements NodeSetIterator,
    SequenceIterator {
        int pos = 0;

        NewArrayIterator() {
        }

        public void setPosition(NodeProxy proxy) {
            int docIdx = NewArrayNodeSet.this.findDoc(proxy.getDocument());
            if (docIdx > -1) {
                int low = NewArrayNodeSet.this.documentOffsets[docIdx];
                int high = low + (NewArrayNodeSet.this.documentLengths[docIdx] - 1);
                while (low <= high) {
                    int mid = (low + high) / 2;
                    NodeProxy p = NewArrayNodeSet.this.nodes[mid];
                    int cmp = p.getNodeId().compareTo(proxy.getNodeId());
                    if (cmp == 0) {
                        this.pos = mid;
                        return;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    low = mid + 1;
                }
            }
            this.pos = -1;
        }

        public boolean hasNext() {
            return this.pos < NewArrayNodeSet.this.size && this.pos > -1;
        }

        public Object next() {
            if (this.pos == NewArrayNodeSet.this.size || this.pos < 0) {
                this.pos = -1;
                return null;
            }
            return NewArrayNodeSet.this.nodes[this.pos++];
        }

        public NodeProxy peekNode() {
            if (this.pos == NewArrayNodeSet.this.size || this.pos < 0) {
                this.pos = -1;
                return null;
            }
            return NewArrayNodeSet.this.nodes[this.pos];
        }

        public Item nextItem() {
            return (Item)this.next();
        }

        public void remove() {
        }
    }

    private class CollectionIterator
    implements Iterator {
        Iterator iterator = null;

        CollectionIterator() {
            if (NewArrayNodeSet.this.documentCount > 0) {
                ObjectHashSet collections = new ObjectHashSet();
                for (int i = 0; i < NewArrayNodeSet.this.documentCount; ++i) {
                    collections.add(NewArrayNodeSet.this.nodes[NewArrayNodeSet.this.documentOffsets[i]].getDocument().getCollection());
                }
                this.iterator = collections.iterator();
            }
        }

        public boolean hasNext() {
            return this.iterator != null && this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }
}

