/*
 * Decompiled with CFR 0.152.
 */
package org.exist.dom;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.AVLTreeNodeSet;
import org.exist.dom.ContextItem;
import org.exist.dom.DocumentImpl;
import org.exist.dom.DocumentSet;
import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NewArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSet;
import org.exist.dom.NodeSetHelper;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.StoredNode;
import org.exist.numbering.NodeId;
import org.exist.storage.DBBroker;
import org.exist.xquery.NodeTest;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.AbstractSequence;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;
import org.w3c.dom.Node;

public abstract class AbstractNodeSet
extends AbstractSequence
implements NodeSet {
    protected static final Logger LOG = Logger.getLogger((Class)AbstractNodeSet.class);
    protected int indexType = 12;
    protected boolean hasTextIndex = false;
    protected boolean hasMixedContent = false;
    private boolean isCached = false;
    private boolean processInReverseOrder = false;

    protected AbstractNodeSet() {
        this.isEmpty = true;
    }

    public abstract NodeSetIterator iterator();

    public abstract SequenceIterator iterate() throws XPathException;

    public abstract SequenceIterator unorderedIterator();

    public int getItemType() {
        return -1;
    }

    public abstract boolean contains(NodeProxy var1);

    public abstract void add(NodeProxy var1);

    public void add(NodeProxy proxy, int sizeHint) {
        this.add(proxy);
    }

    public void add(Item item) throws XPathException {
        if (!Type.subTypeOf(item.getType(), -1)) {
            throw new XPathException("item has wrong type");
        }
        this.add((NodeProxy)item);
    }

    public void addAll(Sequence other) throws XPathException {
        if (!other.isEmpty() && !Type.subTypeOf(other.getItemType(), -1)) {
            throw new XPathException("sequence argument is not a node sequence");
        }
        SequenceIterator i = other.iterate();
        while (i.hasNext()) {
            this.add(i.nextItem());
        }
    }

    public abstract void addAll(NodeSet var1);

    public abstract int getLength();

    public void setIsCached(boolean cached) {
        this.isCached = cached;
    }

    public boolean isCached() {
        return this.isCached;
    }

    public void removeDuplicates() {
    }

    public abstract Node item(int var1);

    public abstract NodeProxy get(int var1);

    public abstract NodeProxy get(NodeProxy var1);

    public DocumentSet getDocumentSet() {
        DocumentSet ds = new DocumentSet();
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.next();
            ds.add(p.getDocument());
        }
        return ds;
    }

    public Iterator getCollectionIterator() {
        return new CollectionIterator();
    }

    public NodeSet selectParentChild(NodeSet al, int mode) {
        return this.selectParentChild(al, mode, -1);
    }

    public NodeSet selectParentChild(NodeSet al, int mode, int contextId) {
        return NodeSetHelper.selectParentChild(this, al, mode, contextId);
    }

    public NodeSet selectAncestorDescendant(NodeSet al, int mode, boolean includeSelf, int contextId) {
        return NodeSetHelper.selectAncestorDescendant(this, al, mode, includeSelf, contextId);
    }

    public NodeSet selectAncestors(NodeSet descendants, boolean includeSelf, int contextId) {
        return NodeSetHelper.selectAncestors(this, descendants, includeSelf, contextId);
    }

    public NodeSet selectFollowing(NodeSet fl) throws XPathException {
        return NodeSetHelper.selectFollowing(fl, this);
    }

    public NodeSet selectPreceding(NodeSet pl) throws XPathException {
        return NodeSetHelper.selectPreceding(pl, this);
    }

    public NodeSet selectPrecedingSiblings(NodeSet siblings, int contextId) {
        return NodeSetHelper.selectPrecedingSiblings(this, siblings, contextId);
    }

    public NodeSet selectFollowingSiblings(NodeSet siblings, int contextId) {
        return NodeSetHelper.selectFollowingSiblings(this, siblings, contextId);
    }

    public NodeSet directSelectAttribute(DBBroker broker, NodeTest qname, int contextId) {
        return NodeSetHelper.directSelectAttributes(broker, this, qname, contextId);
    }

    public NodeProxy parentWithChild(DocumentImpl doc, NodeId nodeId, boolean directParent, boolean includeSelf) {
        NodeProxy temp = this.get(doc, nodeId);
        if (includeSelf && temp != null) {
            return temp;
        }
        for (nodeId = nodeId.getParentId(); nodeId != null; nodeId = nodeId.getParentId()) {
            temp = this.get(doc, nodeId);
            if (temp != null) {
                return temp;
            }
            if (!directParent) continue;
            return null;
        }
        return null;
    }

    public NodeProxy parentWithChild(NodeProxy proxy, boolean directParent, boolean includeSelf, int level) {
        return this.parentWithChild(proxy.getDocument(), proxy.getNodeId(), directParent, includeSelf);
    }

    public NodeSet getParents(int contextId) {
        NewArrayNodeSet parents = new NewArrayNodeSet();
        NodeProxy parent = null;
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy current = (NodeProxy)i.next();
            NodeId parentID = current.getNodeId().getParentId();
            if (parentID == null || parentID.getTreeLevel() == 1 && current.getDocument().getCollection().isTempCollection()) continue;
            if (parent == null || parent.getDocument().getDocId() != current.getDocument().getDocId() || !parent.getNodeId().equals(parentID)) {
                parent = parentID != NodeId.DOCUMENT_NODE ? new NodeProxy(current.getDocument(), parentID, 1, -1L) : new NodeProxy(current.getDocument(), parentID, 9, -1L);
            }
            if (-1 != contextId) {
                parent.addContextNode(contextId, current);
            } else {
                parent.copyContext(current);
            }
            parent.addMatches(current);
            parents.add(parent);
        }
        return parents;
    }

    public NodeSet getAncestors(int contextId, boolean includeSelf) {
        ExtArrayNodeSet ancestors = new ExtArrayNodeSet();
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy current = (NodeProxy)i.next();
            if (includeSelf) {
                if (-1 != contextId) {
                    current.addContextNode(contextId, current);
                }
                ancestors.add(current);
            }
            for (NodeId parentID = current.getNodeId().getParentId(); parentID != null; parentID = parentID.getParentId()) {
                if (parentID == NodeId.DOCUMENT_NODE || parentID.getTreeLevel() == 1 && current.getDocument().getCollection().isTempCollection()) continue;
                NodeProxy parent = new NodeProxy(current.getDocument(), parentID, 1);
                if (-1 != contextId) {
                    parent.addContextNode(contextId, current);
                } else {
                    parent.copyContext(current);
                }
                ancestors.add(parent);
            }
        }
        ancestors.mergeDuplicates();
        return ancestors;
    }

    public int getSizeHint(DocumentImpl doc) {
        return -1;
    }

    public NodeSet intersection(NodeSet other) {
        AVLTreeNodeSet r = new AVLTreeNodeSet();
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy l = (NodeProxy)i.next();
            NodeProxy p = other.get(l);
            if (p == null) continue;
            l.addMatches(p);
            r.add(l);
        }
        return r;
    }

    public NodeSet deepIntersection(NodeSet other) {
        NodeProxy p;
        NodeProxy l;
        AVLTreeNodeSet r = new AVLTreeNodeSet();
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            l = (NodeProxy)i.next();
            p = other.parentWithChild(l, false, true, -1);
            if (p == null) continue;
            if (p.getNodeId().equals(l.getNodeId())) {
                p.addMatches(l);
            }
            r.add(p);
        }
        i = other.iterator();
        while (i.hasNext()) {
            l = (NodeProxy)i.next();
            NodeProxy q = this.parentWithChild(l, false, true, -1);
            if (q == null) continue;
            p = r.get(q);
            if (p != null) {
                p.addMatches(l);
                continue;
            }
            r.add(l);
        }
        return r;
    }

    public NodeSet except(NodeSet other) {
        AVLTreeNodeSet r = new AVLTreeNodeSet();
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy l = (NodeProxy)i.next();
            if (other.contains(l)) continue;
            r.add(l);
        }
        return r;
    }

    public NodeSet filterDocuments(NodeSet otherSet) {
        DocumentSet docs = otherSet.getDocumentSet();
        NewArrayNodeSet newSet = new NewArrayNodeSet();
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.next();
            if (!docs.contains(p.getDocument().getDocId())) continue;
            newSet.add(p);
        }
        return newSet;
    }

    public void setProcessInReverseOrder(boolean inReverseOrder) {
        this.processInReverseOrder = inReverseOrder;
    }

    public boolean getProcessInReverseOrder() {
        return this.processInReverseOrder;
    }

    public NodeSet union(NodeSet other) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        result.addAll(other);
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.next();
            if (other.contains(p)) {
                NodeProxy c = other.get(p);
                if (c == null) continue;
                c.addMatches(p);
                continue;
            }
            result.add(p);
        }
        return result;
    }

    public NodeSet getContextNodes(int contextId) {
        NewArrayNodeSet result = new NewArrayNodeSet();
        DocumentImpl lastDoc = null;
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy current = (NodeProxy)i.next();
            for (ContextItem contextNode = current.getContext(); contextNode != null; contextNode = contextNode.getNextDirect()) {
                if (contextNode.getContextId() != contextId) continue;
                NodeProxy context = contextNode.getNode();
                context.addMatches(current);
                if (-1 != contextId) {
                    context.addContextNode(contextId, context);
                }
                if (lastDoc != null && lastDoc.getDocId() != context.getDocument().getDocId()) {
                    lastDoc = context.getDocument();
                    result.add(context, this.getSizeHint(lastDoc));
                    continue;
                }
                result.add(context);
            }
        }
        return result;
    }

    public NodeSet toNodeSet() throws XPathException {
        return this;
    }

    public int getState() {
        return 1;
    }

    public boolean hasChanged(int previousState) {
        return false;
    }

    public int getIndexType() {
        if (this.indexType == 12) {
            this.hasTextIndex = true;
            this.hasMixedContent = true;
            NodeSetIterator i = this.iterator();
            while (i.hasNext()) {
                NodeProxy node = (NodeProxy)i.next();
                if (node.getDocument().getCollection().isTempCollection()) {
                    this.indexType = 11;
                    this.hasTextIndex = false;
                    this.hasMixedContent = false;
                    break;
                }
                int nodeIndexType = node.getIndexType();
                if (this.indexType == 12) {
                    this.indexType = nodeIndexType;
                } else if (this.indexType != nodeIndexType) {
                    this.indexType = 11;
                }
                if (!node.hasTextIndex()) {
                    this.hasTextIndex = false;
                }
                if (node.hasMixedContent()) continue;
                this.hasMixedContent = false;
            }
        }
        return this.indexType;
    }

    public boolean hasTextIndex() {
        if (this.indexType == 12) {
            this.getIndexType();
        }
        return this.hasTextIndex;
    }

    public boolean hasMixedContent() {
        if (this.indexType == 12) {
            this.getIndexType();
        }
        return this.hasMixedContent;
    }

    public void clearContext(int contextId) {
        NodeSetIterator i = this.iterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.next();
            p.clearContext(contextId);
        }
    }

    public void nodeMoved(NodeId oldNodeId, StoredNode newNode) {
        NodeProxy p = this.get((DocumentImpl)newNode.getOwnerDocument(), oldNodeId);
        if (p != null) {
            p.nodeMoved(oldNodeId, newNode);
        }
    }

    public boolean isPersistentSet() {
        return true;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("NodeSet(");
        for (int i = 0; i < this.getLength(); ++i) {
            if (i > 0) {
                result.append(", ");
            }
            NodeProxy p = this.get(i);
            result.append("[").append(p.getDocument().getDocId()).append(":").append(p.getNodeId()).append("]");
        }
        result.append(")");
        return result.toString();
    }

    private class CollectionIterator
    implements Iterator {
        Collection nextCollection = null;
        NodeSetIterator nodeIterator = AbstractNodeSet.this.iterator();

        CollectionIterator() {
            if (this.nodeIterator.hasNext()) {
                NodeProxy p = (NodeProxy)this.nodeIterator.next();
                this.nextCollection = p.getDocument().getCollection();
            }
        }

        public boolean hasNext() {
            return this.nextCollection != null;
        }

        public Object next() {
            Collection oldCollection = this.nextCollection;
            this.nextCollection = null;
            while (this.nodeIterator.hasNext()) {
                NodeProxy p = (NodeProxy)this.nodeIterator.next();
                if (p.getDocument().getCollection().equals(oldCollection)) continue;
                this.nextCollection = p.getDocument().getCollection();
                break;
            }
            return oldCollection;
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }
}

