/*
 * Decompiled with CFR 0.152.
 */
package org.exist.collections.triggers;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Map;
import org.exist.collections.Collection;
import org.exist.collections.CollectionConfigurationException;
import org.exist.collections.triggers.DocumentTrigger;
import org.exist.collections.triggers.FilteringTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.DateTimeValue;

public class HistoryTrigger
extends FilteringTrigger
implements DocumentTrigger {
    protected XmldbURI rootPath = XmldbURI.ROOT_COLLECTION_URI.append("history");

    public void configure(DBBroker broker, Collection parent, Map parameters) throws CollectionConfigurationException {
        super.configure(broker, parent, parameters);
        if (parameters.containsKey("root")) {
            try {
                this.rootPath = XmldbURI.xmldbUriFor(parameters.get("root").toString());
            }
            catch (URISyntaxException e) {
                throw new CollectionConfigurationException(e);
            }
        }
    }

    public void prepare(int event, DBBroker broker, Txn transaction, XmldbURI documentName, DocumentImpl doc) throws TriggerException {
        if (doc == null) {
            return;
        }
        XmldbURI path = this.rootPath.append(doc.getURI());
        try {
            String dtValue = new DateTimeValue(new Date(doc.getMetadata().getLastModified())).getStringValue();
            dtValue = dtValue.replaceAll(":", "-");
            dtValue = dtValue.replaceAll("\\.", "-");
            XmldbURI name = XmldbURI.create(dtValue);
            Collection destination = broker.getOrCreateCollection(transaction, path);
            broker.saveCollection(transaction, destination);
            broker.copyXMLResource(transaction, doc, destination, name);
        }
        catch (XPathException xpe) {
            throw new TriggerException(xpe);
        }
        catch (IOException exception) {
            throw new TriggerException(exception);
        }
        catch (PermissionDeniedException exception) {
            throw new TriggerException(exception);
        }
        catch (LockException exception) {
            throw new TriggerException(exception);
        }
    }

    public void finish(int event, DBBroker broker, Txn transaction, XmldbURI documentPath, DocumentImpl document) {
        super.finish(event, broker, transaction, documentPath, document);
    }
}

