/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.Target;
import com.sun.xacml.attr.AttributeDesignator;
import com.sun.xacml.attr.AttributeValue;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.exist.client.xacml.Abbreviator;
import org.exist.client.xacml.AbstractNodeEditor;
import org.exist.client.xacml.ActionAttributeHandler;
import org.exist.client.xacml.DatabaseInterface;
import org.exist.client.xacml.MatchEditor;
import org.exist.client.xacml.ModuleAttributeHandler;
import org.exist.client.xacml.ResizingTable;
import org.exist.client.xacml.ResourceCategoryAttributeHandler;
import org.exist.client.xacml.TargetNode;
import org.exist.client.xacml.TargetTableModel;
import org.exist.client.xacml.UserAttributeHandler;
import org.exist.client.xacml.XACMLTreeNode;

public class TargetEditor
extends AbstractNodeEditor
implements ChangeListener,
ListSelectionListener {
    private Abbreviator abbrev;
    private JTabbedPane tabbed;
    private JTable subjectTargetTable;
    private JTable actionTargetTable;
    private JTable resourceTargetTable;
    private MatchEditor matchEditor;
    private JPanel comp;
    private TargetNode node;

    private TargetEditor() {
    }

    public TargetEditor(DatabaseInterface dbInterface) {
        this.abbrev = new Abbreviator();
        this.setup(dbInterface);
    }

    private void setup(DatabaseInterface dbInterface) {
        this.comp = new JPanel(new BorderLayout());
        this.comp.setOpaque(true);
        this.comp.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.matchEditor = new MatchEditor(this.abbrev);
        this.matchEditor.addChangeListener(this);
        this.comp.add((Component)this.matchEditor, "North");
        this.setupHandlers(this.matchEditor, dbInterface);
        this.tabbed = new JTabbedPane(1, 1);
        this.comp.add((Component)this.tabbed, "Center");
        this.subjectTargetTable = this.createTargetPanel(0, this.tabbed);
        this.resourceTargetTable = this.createTargetPanel(1, this.tabbed);
        this.actionTargetTable = this.createTargetPanel(2, this.tabbed);
        this.comp.add(this.tabbed);
    }

    public JComponent getComponent() {
        return this.comp;
    }

    private void setupHandlers(MatchEditor matchEditor, DatabaseInterface dbInterface) {
        matchEditor.addAttributeHandler(new UserAttributeHandler(dbInterface));
        matchEditor.addAttributeHandler(new ActionAttributeHandler());
        matchEditor.addAttributeHandler(new ResourceCategoryAttributeHandler());
        matchEditor.addAttributeHandler(new ModuleAttributeHandler());
    }

    private JTable createTargetPanel(int type, JTabbedPane tabbed) {
        TargetTableModel tm = new TargetTableModel(type, this.abbrev);
        ResizingTable table = new ResizingTable(tm);
        table.getSelectionModel().addListSelectionListener(this);
        table.getColumnModel().getSelectionModel().addListSelectionListener(this);
        table.setMinimumSize(new Dimension(300, 150));
        table.setMaximumSize(new Dimension(600, 500));
        table.setCellSelectionEnabled(true);
        table.setSelectionMode(0);
        JScrollPane scroll = new JScrollPane(table);
        tabbed.add(TargetEditor.getLabel(type), scroll);
        return table;
    }

    private void addSelectionListeners(JTable table) {
        table.getSelectionModel().addListSelectionListener(this);
        table.getColumnModel().getSelectionModel().addListSelectionListener(this);
    }

    private void removeSelectionListeners(JTable table) {
        table.getSelectionModel().removeListSelectionListener(this);
        table.getColumnModel().getSelectionModel().removeListSelectionListener(this);
    }

    private static String getLabel(int type) {
        switch (type) {
            case 2: {
                return "Action";
            }
            case 1: {
                return "Resource";
            }
            case 0: {
                return "Subject";
            }
        }
        throw new IllegalArgumentException("Invalid target type");
    }

    public void setNode(XACMLTreeNode treeNode) {
        if (!(treeNode instanceof TargetNode)) {
            throw new IllegalArgumentException("TargetEditor can only edit TargetNodes");
        }
        this.node = (TargetNode)treeNode;
        Target target = this.node.getTarget();
        ((TargetTableModel)this.subjectTargetTable.getModel()).setTarget(target == null ? null : target.getSubjects());
        ((TargetTableModel)this.actionTargetTable.getModel()).setTarget(target == null ? null : target.getActions());
        ((TargetTableModel)this.resourceTargetTable.getModel()).setTarget(target == null ? null : target.getResources());
    }

    public void pushChanges() {
        if (!this.node.isModified(false)) {
            return;
        }
        List subjects = ((TargetTableModel)this.subjectTargetTable.getModel()).createTarget();
        List resources = ((TargetTableModel)this.resourceTargetTable.getModel()).createTarget();
        List actions = ((TargetTableModel)this.actionTargetTable.getModel()).createTarget();
        Target target = new Target(subjects, resources, actions);
        this.node.setTarget(target);
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        JTable table = this.getCurrentTargetTable();
        if (table == null) {
            this.matchEditor.setMatch(null, null, null);
            return;
        }
        int selectedRow = table.getSelectedRow();
        int selectedColumn = table.getSelectedColumn();
        if (selectedRow < 0 || selectedColumn < 0) {
            this.matchEditor.setMatch(null, null, null);
            return;
        }
        TargetTableModel model = (TargetTableModel)table.getModel();
        AttributeDesignator attribute = model.getAttribute(selectedColumn);
        URI functionId = model.getFunctionId(selectedRow, selectedColumn);
        AttributeValue value = model.getValue(selectedRow, selectedColumn);
        this.matchEditor.setMatch(attribute, functionId, value);
    }

    private JTable getCurrentTargetTable() {
        int currentTab = this.tabbed.getSelectedIndex();
        switch (currentTab) {
            case 0: {
                return this.subjectTargetTable;
            }
            case 1: {
                return this.resourceTargetTable;
            }
            case 2: {
                return this.actionTargetTable;
            }
        }
        return null;
    }

    public void stateChanged(ChangeEvent event) {
        JTable table = this.getCurrentTargetTable();
        if (table == null) {
            this.matchEditor.setMatch(null, null, null);
            return;
        }
        int selectedRow = table.getSelectedRow();
        int selectedColumn = table.getSelectedColumn();
        if (selectedRow < 0 || selectedColumn < 0) {
            this.matchEditor.setMatch(null, null, null);
            return;
        }
        URI functionId = this.matchEditor.getFunctionId();
        AttributeValue value = this.matchEditor.getValue();
        this.removeSelectionListeners(table);
        ((TargetTableModel)table.getModel()).setValue(functionId, value, selectedRow, selectedColumn);
        table.setRowSelectionInterval(selectedRow, selectedRow);
        table.setColumnSelectionInterval(selectedColumn, selectedColumn);
        this.addSelectionListeners(table);
        this.node.setModified(true);
    }
}

