/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import com.sun.xacml.PolicyTreeElement;
import java.net.URI;
import org.exist.client.xacml.AbstractNodeContainer;
import org.exist.client.xacml.NodeContainer;
import org.exist.client.xacml.TargetNode;
import org.exist.security.xacml.XACMLUtil;

public abstract class PolicyElementNode
extends AbstractNodeContainer
implements NodeContainer {
    private URI originalId;
    private URI id;
    private String originalDescription;
    private String description;
    private TargetNode target;

    protected PolicyElementNode(NodeContainer parent, PolicyTreeElement policyElement) {
        super(parent);
        if (policyElement == null) {
            throw new NullPointerException("Policy element cannot be null");
        }
        this.id = policyElement.getId();
        if (this.id == null) {
            throw new NullPointerException("Policy element ID cannot be null");
        }
        this.description = policyElement.getDescription();
        this.target = new TargetNode(this, policyElement.getTarget());
        this.originalId = this.id;
        this.originalDescription = this.description;
    }

    abstract PolicyTreeElement create();

    abstract PolicyTreeElement create(URI var1);

    public URI getId() {
        return this.id;
    }

    public String toString() {
        return this.id.toString();
    }

    void setId(URI id) {
        if (id == null) {
            throw new NullPointerException("Policy element ID cannot be null");
        }
        this.id = id;
        this.fireChanged();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.fireChanged();
    }

    public boolean isIdModified() {
        return !this.id.equals(this.originalId);
    }

    public boolean isDescriptionModified() {
        if (this.description == null) {
            return this.originalDescription != null;
        }
        return !this.description.equals(this.originalDescription);
    }

    public boolean isModified(boolean deep) {
        if (super.isModified(deep) || this.isIdModified() || this.isDescriptionModified()) {
            return true;
        }
        return deep && this.target.isModified(deep);
    }

    public void revert(boolean deep) {
        this.description = this.originalDescription;
        this.id = this.originalId;
        if (deep) {
            this.target.revert(deep);
        }
        super.revert(deep);
    }

    public void commit(boolean deep) {
        this.originalDescription = this.description;
        this.originalId = this.id;
        if (deep) {
            this.target.commit(deep);
        }
        super.commit(deep);
    }

    public TargetNode getTarget() {
        return this.target;
    }

    public String serialize(boolean indent) {
        return XACMLUtil.serialize(this.create(), indent);
    }
}

