/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client.xacml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.tree.TreePath;
import org.exist.client.xacml.XACMLTreeModel;
import org.exist.client.xacml.XACMLTreeNode;

public class NodeExpander
implements ActionListener {
    private static final int EXPAND_DELAY = 1000;
    private Timer expandTimer;
    private JTree tree;
    private XACMLTreeNode contextNode;

    public NodeExpander(JTree tree) {
        this.tree = tree;
        this.expandTimer = new Timer(1000, this);
        this.expandTimer.setRepeats(false);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.contextNode == null) {
            return;
        }
        TreePath path = XACMLTreeModel.getPathToNode(this.contextNode);
        this.tree.expandPath(path);
        this.contextNode = null;
    }

    public void hover(XACMLTreeNode contextNode) {
        this.contextNode = contextNode;
        this.expandTimer.restart();
    }

    public void stop() {
        this.expandTimer.stop();
        this.contextNode = null;
    }
}

