/*
 * Decompiled with CFR 0.152.
 */
package org.exist.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.exist.client.InteractiveClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;

public class CollectionXConf {
    public static final String TYPE_QNAME = "qname";
    public static final String TYPE_PATH = "path";
    public static final String ACTION_INCLUDE = "include";
    public static final String ACTION_EXCLUDE = "exclude";
    private InteractiveClient client = null;
    private String path = null;
    Collection collection = null;
    Resource resConfig = null;
    private LinkedHashMap customNamespaces = null;
    private FullTextIndex fulltextIndex = null;
    private RangeIndex[] rangeIndexes = null;
    private Trigger[] triggers = null;
    private boolean hasChanged = false;

    CollectionXConf(String CollectionName2, InteractiveClient client) throws XMLDBException {
        this.client = client;
        this.path = "/db/system/config" + CollectionName2;
        this.collection = client.getCollection(this.path);
        if (this.collection == null) {
            return;
        }
        String[] resources = this.collection.listResources();
        for (int i = 0; i < resources.length; ++i) {
            if (!resources[i].endsWith(".xconf")) continue;
            this.resConfig = this.collection.getResource(resources[i]);
            break;
        }
        if (this.resConfig == null) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document docConfig = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            docConfig = builder.parse(new ByteArrayInputStream(this.resConfig.getContent().toString().getBytes()));
        }
        catch (ParserConfigurationException pce) {
        }
        catch (SAXException se) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Element xconf = docConfig.getDocumentElement();
        this.customNamespaces = this.getCustomNamespaces(xconf);
        this.fulltextIndex = this.getFullTextIndex(xconf);
        this.rangeIndexes = this.getRangeIndexes(xconf);
        this.triggers = this.getTriggers(xconf);
    }

    public boolean getFullTextIndexDefaultAll() {
        return this.fulltextIndex != null ? this.fulltextIndex.getDefaultAll() : false;
    }

    public void setFullTextIndexDefaultAll(boolean defaultAll) {
        this.hasChanged = true;
        if (this.fulltextIndex == null) {
            this.fulltextIndex = new FullTextIndex(true, false, false, null);
        } else {
            this.fulltextIndex.setDefaultAll(defaultAll);
        }
    }

    public boolean getFullTextIndexAttributes() {
        return this.fulltextIndex != null ? this.fulltextIndex.getAttributes() : false;
    }

    public void setFullTextIndexAttributes(boolean attributes) {
        this.hasChanged = true;
        if (this.fulltextIndex == null) {
            this.fulltextIndex = new FullTextIndex(false, true, false, null);
        } else {
            this.fulltextIndex.setAttributes(attributes);
        }
    }

    public boolean getFullTextIndexAlphanum() {
        return this.fulltextIndex != null ? this.fulltextIndex.getAlphanum() : false;
    }

    public void setFullTextIndexAlphanum(boolean alphanum) {
        this.hasChanged = true;
        if (this.fulltextIndex == null) {
            this.fulltextIndex = new FullTextIndex(false, false, true, null);
        } else {
            this.fulltextIndex.setAlphanum(alphanum);
        }
    }

    public String getFullTextIndexPath(int index) {
        return this.fulltextIndex.getPath(index);
    }

    public String getFullTextIndexType(int index) {
        return this.fulltextIndex.getType(index);
    }

    public String getFullTextIndexPathAction(int index) {
        return this.fulltextIndex.getAction(index);
    }

    public int getFullTextPathCount() {
        if (this.fulltextIndex != null) {
            return this.fulltextIndex.getLength();
        }
        return 0;
    }

    public void addFullTextIndex(String type, String XPath, String action) {
        this.hasChanged = true;
        if (this.fulltextIndex == null) {
            this.fulltextIndex = new FullTextIndex(false, false, false, null);
        }
        this.fulltextIndex.addIndex(type, XPath, action);
    }

    public void updateFullTextIndex(int index, String type, String XPath, String action) {
        this.hasChanged = true;
        if (type != null) {
            this.fulltextIndex.setType(index, type);
        }
        if (XPath != null) {
            this.fulltextIndex.setPath(index, XPath);
        }
        if (action != null) {
            this.fulltextIndex.setAction(index, action);
        }
    }

    public void deleteFullTextIndex(int index) {
        this.hasChanged = true;
        this.fulltextIndex.deleteIndex(index);
    }

    public RangeIndex[] getRangeIndexes() {
        return this.rangeIndexes;
    }

    public RangeIndex getRangeIndex(int index) {
        return this.rangeIndexes[index];
    }

    public int getRangeIndexCount() {
        if (this.rangeIndexes != null) {
            return this.rangeIndexes.length;
        }
        return 0;
    }

    public void deleteRangeIndex(int index) {
        if (index < this.rangeIndexes.length) {
            this.hasChanged = true;
            if (this.rangeIndexes.length == 1) {
                this.rangeIndexes = null;
            } else {
                RangeIndex[] newRangeIndexes = new RangeIndex[this.rangeIndexes.length - 1];
                int x = 0;
                for (int i = 0; i < this.rangeIndexes.length; ++i) {
                    if (i == index) continue;
                    newRangeIndexes[x] = this.rangeIndexes[i];
                    ++x;
                }
                this.rangeIndexes = newRangeIndexes;
            }
        }
    }

    public void updateRangeIndex(int index, String type, String XPath, String xsType) {
        this.hasChanged = true;
        if (type != null) {
            this.rangeIndexes[index].setType(type);
        }
        if (XPath != null) {
            this.rangeIndexes[index].setXPath(XPath);
        }
        if (xsType != null) {
            this.rangeIndexes[index].setxsType(xsType);
        }
    }

    public void addRangeIndex(String type, String XPath, String xsType) {
        this.hasChanged = true;
        if (this.rangeIndexes == null) {
            this.rangeIndexes = new RangeIndex[1];
            this.rangeIndexes[0] = new RangeIndex(type, XPath, xsType);
        } else {
            RangeIndex[] newRangeIndexes = new RangeIndex[this.rangeIndexes.length + 1];
            System.arraycopy(this.rangeIndexes, 0, newRangeIndexes, 0, this.rangeIndexes.length);
            newRangeIndexes[this.rangeIndexes.length] = new RangeIndex(type, XPath, xsType);
            this.rangeIndexes = newRangeIndexes;
        }
    }

    public Trigger[] getTriggers() {
        return this.triggers;
    }

    public Trigger getTrigger(int index) {
        return this.triggers[index];
    }

    public int getTriggerCount() {
        if (this.triggers != null) {
            return this.triggers.length;
        }
        return 0;
    }

    public void deleteTrigger(int index) {
        if (index < this.triggers.length) {
            this.hasChanged = true;
            if (this.triggers.length == 1) {
                this.triggers = null;
            } else {
                Trigger[] newTriggers = new Trigger[this.triggers.length - 1];
                int x = 0;
                for (int i = 0; i < this.triggers.length; ++i) {
                    if (i == index) continue;
                    newTriggers[x] = this.triggers[i];
                    ++x;
                }
                this.triggers = newTriggers;
            }
        }
    }

    public void updateTrigger(int index, String triggerClass, boolean STORE_DOCUMENT_EVENT, boolean UPDATE_DOCUMENT_EVENT, boolean REMOVE_DOCUMENT_EVENT, boolean CREATE_COLLECTION_EVENT, boolean RENAME_COLLECTION_EVENT, boolean DELETE_COLLECTION_EVENT, Properties parameters) {
        this.hasChanged = true;
        if (triggerClass != null) {
            this.triggers[index].setTriggerClass(triggerClass);
        }
        this.triggers[index].setStoreDocumentEvent(STORE_DOCUMENT_EVENT);
        this.triggers[index].setUpdateDocumentEvent(UPDATE_DOCUMENT_EVENT);
        this.triggers[index].setRemoveDocumentEvent(REMOVE_DOCUMENT_EVENT);
        this.triggers[index].setCreateCollectionEvent(CREATE_COLLECTION_EVENT);
        this.triggers[index].setRenameCollectionEvent(RENAME_COLLECTION_EVENT);
        this.triggers[index].setDeleteCollectionEvent(DELETE_COLLECTION_EVENT);
    }

    public void addTrigger(String triggerClass, boolean STORE_DOCUMENT_EVENT, boolean UPDATE_DOCUMENT_EVENT, boolean REMOVE_DOCUMENT_EVENT, boolean CREATE_COLLECTION_EVENT, boolean RENAME_COLLECTION_EVENT, boolean DELETE_COLLECTION_EVENT, Properties parameters) {
        this.hasChanged = true;
        if (this.triggers == null) {
            this.triggers = new Trigger[1];
            this.triggers[0] = new Trigger(triggerClass, STORE_DOCUMENT_EVENT, UPDATE_DOCUMENT_EVENT, REMOVE_DOCUMENT_EVENT, CREATE_COLLECTION_EVENT, RENAME_COLLECTION_EVENT, DELETE_COLLECTION_EVENT, parameters);
        } else {
            Trigger[] newTriggers = new Trigger[this.triggers.length + 1];
            System.arraycopy(this.triggers, 0, newTriggers, 0, this.triggers.length);
            newTriggers[this.triggers.length] = new Trigger(triggerClass, STORE_DOCUMENT_EVENT, UPDATE_DOCUMENT_EVENT, REMOVE_DOCUMENT_EVENT, CREATE_COLLECTION_EVENT, RENAME_COLLECTION_EVENT, DELETE_COLLECTION_EVENT, parameters);
            this.triggers = newTriggers;
        }
    }

    private LinkedHashMap getCustomNamespaces(Element xconf) {
        NamedNodeMap attrs = xconf.getAttributes();
        if (attrs.getLength() > 1) {
            LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node a = attrs.item(i);
                if (!a.getNodeName().startsWith("xmlns:")) continue;
                String namespaceLocalName = a.getNodeName().substring(a.getNodeName().indexOf(":") + 1);
                namespaces.put(namespaceLocalName, a.getNodeValue());
            }
            return namespaces;
        }
        return null;
    }

    private FullTextIndex getFullTextIndex(Element xconf) {
        NodeList nlFullTextIndex = xconf.getElementsByTagName("fulltext");
        if (nlFullTextIndex.getLength() > 0) {
            boolean defaultAll = true;
            boolean attributes = false;
            boolean alphanum = false;
            FullTextIndexPath[] paths = null;
            Element elemFullTextIndex = (Element)nlFullTextIndex.item(0);
            defaultAll = elemFullTextIndex.getAttribute("default").equals("all");
            attributes = elemFullTextIndex.getAttribute("attributes").equals("true");
            alphanum = elemFullTextIndex.getAttribute("alphanum").equals("true");
            NodeList nlInclude = elemFullTextIndex.getElementsByTagName(ACTION_INCLUDE);
            NodeList nlExclude = elemFullTextIndex.getElementsByTagName(ACTION_EXCLUDE);
            NodeList nlQName = elemFullTextIndex.getElementsByTagName("create");
            int iPaths = nlInclude.getLength() + nlExclude.getLength() + nlQName.getLength();
            int pos = 0;
            if (iPaths > 0) {
                int i;
                paths = new FullTextIndexPath[iPaths];
                if (nlInclude.getLength() > 0) {
                    for (i = 0; i < nlInclude.getLength(); ++i) {
                        paths[pos++] = new FullTextIndexPath(TYPE_PATH, ((Element)nlInclude.item(i)).getAttribute(TYPE_PATH), ACTION_INCLUDE);
                    }
                }
                if (nlExclude.getLength() > 0) {
                    for (i = 0; i < nlExclude.getLength(); ++i) {
                        paths[pos++] = new FullTextIndexPath(TYPE_PATH, ((Element)nlExclude.item(i)).getAttribute(TYPE_PATH), ACTION_EXCLUDE);
                    }
                }
                if (nlQName.getLength() > 0) {
                    for (i = 0; i < nlQName.getLength(); ++i) {
                        paths[pos++] = new FullTextIndexPath(TYPE_QNAME, ((Element)nlQName.item(i)).getAttribute(TYPE_QNAME), ACTION_EXCLUDE);
                    }
                }
            }
            return new FullTextIndex(defaultAll, attributes, alphanum, paths);
        }
        return null;
    }

    private RangeIndex[] getRangeIndexes(Element xconf) {
        NodeList nlRangeIndexes = xconf.getElementsByTagName("create");
        if (nlRangeIndexes.getLength() > 0) {
            ArrayList<RangeIndex> rl = new ArrayList<RangeIndex>();
            for (int i = 0; i < nlRangeIndexes.getLength(); ++i) {
                Element rangeIndex = (Element)nlRangeIndexes.item(i);
                if (!rangeIndex.hasAttribute("type")) continue;
                if (rangeIndex.hasAttribute(TYPE_QNAME)) {
                    rl.add(new RangeIndex(TYPE_QNAME, rangeIndex.getAttribute(TYPE_QNAME), rangeIndex.getAttribute("type")));
                    continue;
                }
                rl.add(new RangeIndex(TYPE_PATH, rangeIndex.getAttribute(TYPE_PATH), rangeIndex.getAttribute("type")));
            }
            RangeIndex[] rangeIndexes = new RangeIndex[rl.size()];
            rangeIndexes = rl.toArray(rangeIndexes);
            return rangeIndexes;
        }
        return null;
    }

    private Trigger[] getTriggers(Element xconf) {
        NodeList nlTriggers = xconf.getElementsByTagName("trigger");
        if (nlTriggers.getLength() > 0) {
            Trigger[] triggers = new Trigger[nlTriggers.getLength()];
            for (int i = 0; i < nlTriggers.getLength(); ++i) {
                Element trigger = (Element)nlTriggers.item(i);
                Properties parameters = new Properties();
                NodeList nlTriggerParameters = trigger.getElementsByTagName("parameter");
                if (nlTriggerParameters.getLength() > 0) {
                    for (int x = 0; x < nlTriggerParameters.getLength(); ++x) {
                        Element parameter = (Element)nlTriggerParameters.item(x);
                        parameters.setProperty(parameter.getAttribute("name"), parameter.getAttribute("value"));
                    }
                }
                triggers[i] = new Trigger(trigger.getAttribute("class"), trigger.getAttribute("event"), parameters);
            }
            return triggers;
        }
        return null;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    private String toXMLString() {
        StringBuffer xconf = new StringBuffer();
        xconf.append("<collection xmlns=\"http://exist-db.org/collection-config/1.0\"");
        if (this.customNamespaces != null) {
            Set namespaceKeys = this.customNamespaces.keySet();
            Iterator itKeys = namespaceKeys.iterator();
            while (itKeys.hasNext()) {
                xconf.append(" ");
                String namespaceLocalName = (String)itKeys.next();
                String namespaceURL = (String)this.customNamespaces.get(namespaceLocalName);
                xconf.append("xmlns:" + namespaceLocalName + "=\"" + namespaceURL + "\"");
            }
        }
        xconf.append(">");
        xconf.append(System.getProperty("line.separator"));
        if (this.fulltextIndex != null || this.rangeIndexes != null) {
            xconf.append('\t');
            xconf.append("<index>");
            xconf.append(System.getProperty("line.separator"));
            if (this.fulltextIndex != null) {
                xconf.append("\t\t");
                xconf.append(this.fulltextIndex.toXMLString());
                xconf.append(System.getProperty("line.separator"));
            }
            if (this.rangeIndexes != null) {
                for (int r = 0; r < this.rangeIndexes.length; ++r) {
                    xconf.append("\t\t\t");
                    xconf.append(this.rangeIndexes[r].toXMLString());
                    xconf.append(System.getProperty("line.separator"));
                }
            }
            xconf.append('\t');
            xconf.append("</index>");
            xconf.append(System.getProperty("line.separator"));
        }
        if (this.triggers != null) {
            xconf.append('\t');
            xconf.append("<triggers>");
            for (int t = 0; t < this.triggers.length; ++t) {
                xconf.append("\t\t\t");
                xconf.append(this.triggers[t].toXMLString());
                xconf.append(System.getProperty("line.separator"));
            }
            xconf.append('\t');
            xconf.append("</triggers>");
            xconf.append(System.getProperty("line.separator"));
        }
        xconf.append("</collection>");
        return xconf.toString();
    }

    public boolean Save() {
        try {
            if (this.resConfig == null) {
                if (this.collection == null) {
                    this.client.process("mkcol " + this.path);
                    this.collection = this.client.getCollection(this.path);
                }
                this.resConfig = this.collection.createResource("collection.xconf", "XMLResource");
            }
            this.resConfig.setContent((Object)this.toXMLString());
            this.collection.storeResource(this.resConfig);
        }
        catch (XMLDBException xmldbe) {
            return false;
        }
        return true;
    }

    protected class Trigger {
        private String triggerClass = null;
        private boolean STORE_DOCUMENT_EVENT = false;
        private boolean UPDATE_DOCUMENT_EVENT = false;
        private boolean REMOVE_DOCUMENT_EVENT = false;
        private boolean CREATE_COLLECTION_EVENT = false;
        private boolean RENAME_COLLECTION_EVENT = false;
        private boolean DELETE_COLLECTION_EVENT = false;
        private Properties parameters = null;

        Trigger(String triggerClass, boolean STORE_DOCUMENT_EVENT, boolean UPDATE_DOCUMENT_EVENT, boolean REMOVE_DOCUMENT_EVENT, boolean CREATE_COLLECTION_EVENT, boolean RENAME_COLLECTION_EVENT, boolean DELETE_COLLECTION_EVENT, Properties parameters) {
            this.triggerClass = triggerClass;
            this.STORE_DOCUMENT_EVENT = STORE_DOCUMENT_EVENT;
            this.UPDATE_DOCUMENT_EVENT = UPDATE_DOCUMENT_EVENT;
            this.REMOVE_DOCUMENT_EVENT = REMOVE_DOCUMENT_EVENT;
            this.CREATE_COLLECTION_EVENT = CREATE_COLLECTION_EVENT;
            this.RENAME_COLLECTION_EVENT = RENAME_COLLECTION_EVENT;
            this.DELETE_COLLECTION_EVENT = DELETE_COLLECTION_EVENT;
            this.parameters = parameters;
        }

        Trigger(String triggerClass, String triggerEvents, Properties parameters) {
            this.triggerClass = triggerClass;
            if (triggerEvents.indexOf("store") > -1) {
                this.STORE_DOCUMENT_EVENT = true;
            }
            if (triggerEvents.indexOf("update") > -1) {
                this.UPDATE_DOCUMENT_EVENT = true;
            }
            if (triggerEvents.indexOf("remove") > -1) {
                this.REMOVE_DOCUMENT_EVENT = true;
            }
            if (triggerEvents.indexOf("create") > -1) {
                this.CREATE_COLLECTION_EVENT = true;
            }
            if (triggerEvents.indexOf("rename") > -1) {
                this.RENAME_COLLECTION_EVENT = true;
            }
            if (triggerEvents.indexOf("delete") > -1) {
                this.DELETE_COLLECTION_EVENT = true;
            }
            this.parameters = parameters;
        }

        public String getTriggerClass() {
            return this.triggerClass;
        }

        public void setTriggerClass(String triggerClass) {
            this.triggerClass = triggerClass;
        }

        public boolean getStoreDocumentEvent() {
            return this.STORE_DOCUMENT_EVENT;
        }

        public void setStoreDocumentEvent(boolean store) {
            this.STORE_DOCUMENT_EVENT = store;
        }

        public boolean getUpdateDocumentEvent() {
            return this.UPDATE_DOCUMENT_EVENT;
        }

        public void setUpdateDocumentEvent(boolean update) {
            this.UPDATE_DOCUMENT_EVENT = update;
        }

        public boolean getRemoveDocumentEvent() {
            return this.REMOVE_DOCUMENT_EVENT;
        }

        public void setRemoveDocumentEvent(boolean remove) {
            this.REMOVE_DOCUMENT_EVENT = remove;
        }

        public boolean getCreateCollectionEvent() {
            return this.CREATE_COLLECTION_EVENT;
        }

        public void setCreateCollectionEvent(boolean create) {
            this.CREATE_COLLECTION_EVENT = create;
        }

        public boolean getRenameCollectionEvent() {
            return this.RENAME_COLLECTION_EVENT;
        }

        public void setRenameCollectionEvent(boolean rename) {
            this.RENAME_COLLECTION_EVENT = rename;
        }

        public boolean getDeleteCollectionEvent() {
            return this.DELETE_COLLECTION_EVENT;
        }

        public void setDeleteCollectionEvent(boolean delete) {
            this.DELETE_COLLECTION_EVENT = delete;
        }

        protected String toXMLString() {
            StringBuffer trigger = new StringBuffer();
            if (!this.triggerClass.equals("")) {
                trigger.append("<trigger class=\"");
                trigger.append(this.triggerClass);
                trigger.append("\" event=\"");
                if (this.STORE_DOCUMENT_EVENT) {
                    trigger.append("store,");
                }
                if (this.UPDATE_DOCUMENT_EVENT) {
                    trigger.append("update,");
                }
                if (this.REMOVE_DOCUMENT_EVENT) {
                    trigger.append("remove,");
                }
                if (this.CREATE_COLLECTION_EVENT) {
                    trigger.append("create,");
                }
                if (this.RENAME_COLLECTION_EVENT) {
                    trigger.append("rename,");
                }
                if (this.DELETE_COLLECTION_EVENT) {
                    trigger.append("delete,");
                }
                if (trigger.charAt(trigger.length() - 1) == ',') {
                    trigger.deleteCharAt(trigger.length() - 1);
                }
                trigger.append("\">");
                if (this.parameters != null && this.parameters.size() > 0) {
                    Enumeration<Object> pKeys = this.parameters.keys();
                    while (pKeys.hasMoreElements()) {
                        String name = (String)pKeys.nextElement();
                        String value = this.parameters.getProperty(name);
                        trigger.append("<parameter name=\"");
                        trigger.append(name);
                        trigger.append("\" value=\"");
                        trigger.append(value);
                        trigger.append("\"/>");
                    }
                }
                trigger.append("</trigger>");
            }
            return trigger.toString();
        }
    }

    protected class RangeIndex {
        private String type = "qname";
        private String XPath = null;
        private String xsType = null;

        RangeIndex(String type, String XPath, String xsType) {
            this.type = type;
            this.XPath = XPath;
            this.xsType = xsType;
        }

        public String getXPath() {
            return this.XPath;
        }

        public String getxsType() {
            return this.xsType;
        }

        public String getType() {
            return this.type;
        }

        public void setXPath(String XPath) {
            this.XPath = XPath;
        }

        public void setxsType(String xsType) {
            this.xsType = xsType;
        }

        public void setType(String type) {
            this.type = type;
        }

        protected String toXMLString() {
            StringBuffer range = new StringBuffer();
            if (CollectionXConf.TYPE_PATH.equals(this.type)) {
                range.append("<create path=\"");
            } else {
                range.append("<create qname=\"");
            }
            range.append(this.XPath);
            range.append("\" type=\"");
            range.append(this.xsType);
            range.append("\"/>");
            return range.toString();
        }
    }

    protected class FullTextIndex {
        boolean defaultAll = true;
        boolean attributes = false;
        boolean alphanum = false;
        FullTextIndexPath[] xpaths = null;

        FullTextIndex(boolean defaultAll, boolean attributes, boolean alphanum, FullTextIndexPath[] xpaths) {
            this.defaultAll = defaultAll;
            this.attributes = attributes;
            this.alphanum = alphanum;
            this.xpaths = xpaths;
        }

        public boolean getDefaultAll() {
            return this.defaultAll;
        }

        public void setDefaultAll(boolean defaultAll) {
            this.defaultAll = defaultAll;
        }

        public boolean getAttributes() {
            return this.attributes;
        }

        public void setAttributes(boolean attributes) {
            this.attributes = attributes;
        }

        public boolean getAlphanum() {
            return this.alphanum;
        }

        public void setAlphanum(boolean alphanum) {
            this.alphanum = alphanum;
        }

        public String getPath(int index) {
            return this.xpaths[index].getXPath();
        }

        public String getAction(int index) {
            return this.xpaths[index].getAction();
        }

        public int getLength() {
            return this.xpaths != null ? this.xpaths.length : 0;
        }

        public void setType(int index, String type) {
            this.xpaths[index].setType(type);
        }

        public String getType(int index) {
            return this.xpaths[index].getType();
        }

        public void setPath(int index, String XPath) {
            this.xpaths[index].setPath(XPath);
        }

        public void setAction(int index, String action) {
            this.xpaths[index].setAction(action);
        }

        public void addIndex(String type, String XPath, String action) {
            if (this.xpaths == null) {
                this.xpaths = new FullTextIndexPath[1];
                this.xpaths[0] = new FullTextIndexPath(type, XPath, action);
            } else {
                FullTextIndexPath[] newxpaths = new FullTextIndexPath[this.xpaths.length + 1];
                System.arraycopy(this.xpaths, 0, newxpaths, 0, this.xpaths.length);
                newxpaths[this.xpaths.length] = new FullTextIndexPath(type, XPath, action);
                this.xpaths = newxpaths;
            }
        }

        public void deleteIndex(int index) {
            if (index < this.xpaths.length) {
                if (this.xpaths.length == 1) {
                    this.xpaths = null;
                } else {
                    FullTextIndexPath[] newxpaths = new FullTextIndexPath[this.xpaths.length - 1];
                    int x = 0;
                    for (int i = 0; i < this.xpaths.length; ++i) {
                        if (i == index) continue;
                        newxpaths[x] = this.xpaths[i];
                        ++x;
                    }
                    this.xpaths = newxpaths;
                }
            }
        }

        protected String toXMLString() {
            StringBuffer fulltext = new StringBuffer();
            fulltext.append("<fulltext default=\"");
            fulltext.append(this.defaultAll ? "all" : "none");
            fulltext.append("\" attributes=\"");
            fulltext.append(this.attributes);
            fulltext.append("\" alphanum=\"");
            fulltext.append(this.alphanum);
            fulltext.append("\">");
            fulltext.append(System.getProperty("line.separator"));
            if (this.xpaths != null) {
                for (int i = 0; i < this.xpaths.length; ++i) {
                    fulltext.append('\t');
                    fulltext.append("<");
                    if (CollectionXConf.TYPE_PATH.equals(this.xpaths[i].getType())) {
                        fulltext.append(this.xpaths[i].getAction());
                        fulltext.append(" path=\"");
                        fulltext.append(this.xpaths[i].getXPath());
                    } else {
                        fulltext.append("create qname=\"");
                        fulltext.append(this.xpaths[i].getXPath());
                    }
                    fulltext.append("\"/>");
                    fulltext.append(System.getProperty("line.separator"));
                }
            }
            fulltext.append("</fulltext>");
            return fulltext.toString();
        }
    }

    protected class FullTextIndexPath {
        private String type = "qname";
        private String path = null;
        private String action = "include";

        FullTextIndexPath(String type, String path, String action) {
            this.type = type;
            this.path = path;
            this.action = action;
        }

        public String getXPath() {
            return this.path;
        }

        public String getAction() {
            return this.action;
        }

        public String getType() {
            return this.type;
        }

        public void setPath(String xpath) {
            this.path = xpath;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setAction(String action) {
            this.action = action;
        }
    }
}

