/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Observable;
import java.util.Properties;
import java.util.Stack;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.exist.backup.AbstractBackupDescriptor;
import org.exist.backup.BackupDescriptor;
import org.exist.backup.FileSystemBackupDescriptor;
import org.exist.backup.RestoreDialog;
import org.exist.backup.ZipArchiveBackupDescriptor;
import org.exist.dom.DocumentTypeImpl;
import org.exist.security.User;
import org.exist.util.EXistInputSource;
import org.exist.xmldb.CollectionImpl;
import org.exist.xmldb.CollectionManagementServiceImpl;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.UserManagementService;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.XPathException;
import org.exist.xquery.util.URIUtils;
import org.exist.xquery.value.DateTimeValue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.Resource;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.CollectionManagementService;

public class Restore
extends DefaultHandler {
    private BackupDescriptor contents;
    private String uri;
    private String username;
    private String pass;
    private XMLReader reader;
    private CollectionImpl current;
    private Stack stack = new Stack();
    private RestoreDialog dialog = null;
    private int version = 0;
    private RestoreListener listener;
    private static final int strictUriVersion = 1;

    public Restore(String user, String pass, String newAdminPass, File contents, String uri) throws ParserConfigurationException, SAXException, XMLDBException, URISyntaxException {
        this.username = user;
        this.pass = pass;
        this.uri = uri;
        this.listener = new DefaultListener();
        if (newAdminPass != null) {
            this.setAdminCredentials(newAdminPass);
        }
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        saxFactory.setNamespaceAware(true);
        saxFactory.setValidating(false);
        SAXParser sax = saxFactory.newSAXParser();
        this.reader = sax.getXMLReader();
        this.reader.setContentHandler(this);
        do {
            String previous;
            AbstractBackupDescriptor bd = null;
            Properties properties = null;
            try {
                bd = contents.isDirectory() ? new FileSystemBackupDescriptor(new File(contents, "__contents__.xml")) : (contents.getName().endsWith(".zip") || contents.getName().endsWith(".ZIP") ? new ZipArchiveBackupDescriptor(contents) : new FileSystemBackupDescriptor(contents));
                properties = bd.getProperties();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SAXException("Unable to create backup descriptor object from " + contents, e);
            }
            this.stack.push(bd);
            BackupDescriptor sysbd = bd.getChildBackupDescriptor("system");
            if (sysbd != null) {
                this.stack.push(sysbd);
            }
            contents = null;
            if (properties == null || !properties.getProperty("incremental", "no").equals("yes") || (previous = properties.getProperty("previous", "")).length() <= 0 || (contents = new File(bd.getParentDir(), previous)).canRead()) continue;
            throw new SAXException("Required part of incremental backup not found: " + contents.getAbsolutePath());
        } while (contents != null);
    }

    public void setListener(RestoreListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(boolean showGUI, JFrame parent) throws XMLDBException, FileNotFoundException, IOException, SAXException {
        block8: {
            block7: {
                if (!showGUI) break block7;
                this.dialog = new RestoreDialog(parent, "Restoring data ...", false);
                this.dialog.setVisible(true);
                Thread restoreThread = new Thread(){

                    public void run() {
                        while (!Restore.this.stack.isEmpty()) {
                            try {
                                Restore.this.contents = (BackupDescriptor)Restore.this.stack.pop();
                                Restore.this.dialog.setBackup(Restore.this.contents.getSymbolicPath());
                                Restore.this.reader.parse(Restore.this.contents.getInputSource());
                            }
                            catch (FileNotFoundException e) {
                                Restore.this.dialog.displayMessage(e.getMessage());
                            }
                            catch (IOException e) {
                                Restore.this.dialog.displayMessage(e.getMessage());
                            }
                            catch (SAXException e) {
                                Restore.this.dialog.displayMessage(e.getMessage());
                            }
                        }
                        Restore.this.dialog.setVisible(false);
                    }
                };
                restoreThread.start();
                if (parent != null) break block8;
                while (restoreThread.isAlive()) {
                    Restore restore = this;
                    synchronized (restore) {
                        try {
                            this.wait(20L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                break block8;
            }
            while (!this.stack.isEmpty()) {
                this.contents = (BackupDescriptor)this.stack.pop();
                EXistInputSource is = this.contents.getInputSource();
                is.setEncoding("UTF-8");
                this.reader.parse(is);
            }
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (namespaceURI.equals("http://exist.sourceforge.net/NS/exist")) {
            if (localName.equals("collection")) {
                String name = atts.getValue("name");
                String owner = atts.getValue("owner");
                String group = atts.getValue("group");
                String mode = atts.getValue("mode");
                String created = atts.getValue("created");
                String strVersion = atts.getValue("version");
                if (strVersion != null) {
                    try {
                        this.version = Integer.parseInt(strVersion);
                    }
                    catch (NumberFormatException e) {
                        this.version = 0;
                    }
                }
                if (name == null) {
                    throw new SAXException("collection requires a name attribute");
                }
                try {
                    XmldbURI collUri;
                    this.listener.createCollection(name);
                    if (this.version >= 1) {
                        collUri = XmldbURI.create(name);
                    } else {
                        try {
                            collUri = URIUtils.encodeXmldbUriFor(name);
                        }
                        catch (URISyntaxException e) {
                            this.listener.warn("Could not parse document name into a URI: " + e.getMessage());
                            return;
                        }
                    }
                    Date date_created = null;
                    if (created != null) {
                        try {
                            date_created = new DateTimeValue(created).getDate();
                        }
                        catch (XPathException e2) {
                            // empty catch block
                        }
                    }
                    this.current = this.mkcol(collUri, date_created);
                    if (this.current == null) {
                        throw new SAXException("Collection not found: " + collUri);
                    }
                    UserManagementService service = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                    User u = new User(owner, null, group);
                    service.chown(u, group);
                    service.chmod(Integer.parseInt(mode, 8));
                }
                catch (Exception e) {
                    this.listener.warn("An unrecoverable error occurred while restoring\ncollection '" + name + "'. " + "Aborting restore!");
                    e.printStackTrace();
                    throw new SAXException(e.getMessage(), e);
                }
                if (this.dialog != null) {
                    this.dialog.setCollection(name);
                }
            } else if (localName.equals("subcollection")) {
                BackupDescriptor subbd;
                String name = atts.getValue("filename");
                if (name == null) {
                    name = atts.getValue("name");
                }
                if ((subbd = this.contents.getChildBackupDescriptor(name)) != null) {
                    this.stack.push(subbd);
                } else {
                    this.listener.warn(name + " does not exist or is not readable.");
                }
            } else if (localName.equals("resource")) {
                String skip = atts.getValue("skip");
                if (skip == null || skip.equals("no")) {
                    XmldbURI docUri;
                    String type = atts.getValue("type");
                    if (type == null) {
                        type = "XMLResource";
                    }
                    String name = atts.getValue("name");
                    String owner = atts.getValue("owner");
                    String group = atts.getValue("group");
                    String perms = atts.getValue("mode");
                    String filename = atts.getValue("filename");
                    String mimetype = atts.getValue("mimetype");
                    String created = atts.getValue("created");
                    String modified = atts.getValue("modified");
                    String publicid = atts.getValue("publicid");
                    String systemid = atts.getValue("systemid");
                    String namedoctype = atts.getValue("namedoctype");
                    if (filename == null) {
                        filename = name;
                    }
                    if (name == null) {
                        this.listener.warn("Wrong entry in backup descriptor: resource requires a name attribute.");
                    }
                    if (this.version >= 1) {
                        docUri = XmldbURI.create(name);
                    } else {
                        try {
                            docUri = URIUtils.encodeXmldbUriFor(name);
                        }
                        catch (URISyntaxException e) {
                            this.listener.warn("Could not parse document name into a URI: " + e.getMessage());
                            return;
                        }
                    }
                    EXistInputSource is = this.contents.getInputSource(filename);
                    try {
                        if (this.dialog != null && this.current instanceof Observable) {
                            ((Observable)((Object)this.current)).addObserver(this.dialog.getObserver());
                        }
                        if (this.dialog != null) {
                            this.dialog.setResource(name);
                        }
                        Resource res = this.current.createResource(docUri.toString(), type);
                        if (mimetype != null) {
                            ((EXistResource)res).setMimeType(mimetype);
                        }
                        if (is.getByteStreamLength() > 0L) {
                            res.setContent((Object)is);
                        } else {
                            res.setContent((Object)"");
                        }
                        Date date_created = null;
                        Date date_modified = null;
                        if (created != null) {
                            try {
                                date_created = new DateTimeValue(created).getDate();
                            }
                            catch (XPathException e2) {
                                this.listener.warn("Illegal creation date. Skipping ...");
                            }
                        }
                        if (modified != null) {
                            try {
                                date_modified = new DateTimeValue(modified).getDate();
                            }
                            catch (XPathException e2) {
                                this.listener.warn("Illegal modification date. Skipping ...");
                            }
                        }
                        this.current.storeResource(res, date_created, date_modified);
                        if (publicid != null || systemid != null) {
                            DocumentTypeImpl doctype = new DocumentTypeImpl(namedoctype, publicid, systemid);
                            try {
                                ((EXistResource)res).setDocType(doctype);
                            }
                            catch (XMLDBException e1) {
                                e1.printStackTrace();
                            }
                        }
                        UserManagementService service = (UserManagementService)this.current.getService("UserManagementService", "1.0");
                        User u = new User(owner, null, group);
                        try {
                            service.chown(res, u, group);
                        }
                        catch (XMLDBException e1) {
                            this.listener.warn("Failed to change owner on document '" + name + "'; skipping ...");
                        }
                        service.chmod(res, Integer.parseInt(perms, 8));
                        this.listener.restored(name);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.listener.warn("Failed to restore resource '" + name + "'\nfrom file '" + this.contents.getSymbolicPath(name, false) + "'.\nReason: " + e.getMessage());
                    }
                }
            } else if (localName.equals("deleted")) {
                String name = atts.getValue("name");
                String type = atts.getValue("type");
                if (type.equals("collection")) {
                    try {
                        Collection child = this.current.getChildCollection(name);
                        if (child != null) {
                            CollectionManagementService cmgt = (CollectionManagementService)this.current.getService("CollectionManagementService", "1.0");
                            cmgt.removeCollection(name);
                        }
                    }
                    catch (XMLDBException e) {
                        this.listener.warn("Failed to remove deleted collection: " + name + ": " + e.getMessage());
                    }
                } else if (type.equals("resource")) {
                    try {
                        Resource resource = this.current.getResource(name);
                        if (resource != null) {
                            this.current.removeResource(resource);
                        }
                    }
                    catch (XMLDBException e) {
                        this.listener.warn("Failed to remove deleted resource: " + name + ": " + e.getMessage());
                    }
                }
            }
        }
    }

    private final CollectionImpl mkcol(XmldbURI collPath, Date created) throws XMLDBException, URISyntaxException {
        XmldbURI[] segments = collPath.getPathSegments();
        XmldbURI dbUri = !this.uri.endsWith("/db") ? XmldbURI.xmldbUriFor(this.uri + "/db") : XmldbURI.xmldbUriFor(this.uri);
        Collection current = DatabaseManager.getCollection((String)dbUri.toString(), (String)this.username, (String)this.pass);
        XmldbURI p = XmldbURI.ROOT_COLLECTION_URI;
        for (int i = 1; i < segments.length; ++i) {
            XmldbURI xmldbURI = dbUri.resolveCollectionPath(p = p.append(segments[i]));
            Collection c = DatabaseManager.getCollection((String)xmldbURI.toString(), (String)this.username, (String)this.pass);
            if (c == null) {
                CollectionManagementServiceImpl mgtService = (CollectionManagementServiceImpl)current.getService("CollectionManagementService", "1.0");
                current = mgtService.createCollection(segments[i], created);
                continue;
            }
            current = c;
        }
        return (CollectionImpl)current;
    }

    private void setAdminCredentials(String adminPassword) throws XMLDBException, URISyntaxException {
        XmldbURI dbUri = !this.uri.endsWith("/db") ? XmldbURI.xmldbUriFor(this.uri + "/db") : XmldbURI.xmldbUriFor(this.uri);
        Collection root = DatabaseManager.getCollection((String)dbUri.toString(), (String)this.username, (String)this.pass);
        UserManagementService mgmt = (UserManagementService)root.getService("UserManagementService", "1.0");
        User dba = mgmt.getUser("admin");
        dba.setPassword(adminPassword);
        mgmt.updateUser(dba);
        this.pass = adminPassword;
    }

    public static void showErrorMessage(String message) {
        JTextArea msgArea = new JTextArea(message);
        msgArea.setEditable(false);
        msgArea.setBackground(null);
        JScrollPane scroll = new JScrollPane(msgArea);
        JOptionPane optionPane = new JOptionPane();
        optionPane.setMessage(new Object[]{scroll});
        optionPane.setMessageType(0);
        JDialog dialog = optionPane.createDialog(null, "Error");
        dialog.setResizable(true);
        dialog.pack();
        dialog.setVisible(true);
    }

    private class DefaultListener
    implements RestoreListener {
        private DefaultListener() {
        }

        public void createCollection(String collection) {
            this.info("creating collection " + collection);
        }

        public void restored(String resource) {
            this.info("restored " + resource);
        }

        public void info(String message) {
            if (Restore.this.dialog != null) {
                Restore.this.dialog.displayMessage(message);
            } else {
                System.err.println(message);
            }
        }

        public void warn(String message) {
            if (Restore.this.dialog != null) {
                Restore.this.dialog.displayMessage(message);
            } else {
                System.err.println(message);
            }
        }
    }

    public static interface RestoreListener {
        public void createCollection(String var1);

        public void restored(String var1);

        public void info(String var1);

        public void warn(String var1);
    }
}

