/*
 * Decompiled with CFR 0.152.
 */
package org.exist.backup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import org.exist.backup.BackupWriter;

public class FileSystemWriter
implements BackupWriter {
    private File currentDir;
    private File currentContents;
    private Writer currentContentsOut;
    private OutputStream currentOut;
    private boolean dataWritten = false;

    public FileSystemWriter(String path) {
        this(new File(path));
    }

    public FileSystemWriter(File file) {
        if (file.exists()) {
            file.delete();
        }
        file.mkdirs();
        this.currentDir = file;
    }

    public void newCollection(String name) {
        File file = new File(this.currentDir, name);
        if (file.exists()) {
            file.delete();
        }
        file.mkdirs();
        this.dataWritten = true;
        this.currentDir = file;
    }

    public void closeCollection() {
        this.currentDir = this.currentDir.getParentFile();
    }

    public void close() throws IOException {
    }

    public Writer newContents() throws IOException {
        this.currentContents = new File(this.currentDir, "__contents__.xml");
        this.currentContentsOut = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentContents), "UTF-8"));
        this.dataWritten = true;
        return this.currentContentsOut;
    }

    public void closeContents() throws IOException {
        this.currentContentsOut.close();
    }

    public OutputStream newEntry(String name) throws IOException {
        this.currentOut = new FileOutputStream(new File(this.currentDir, name));
        this.dataWritten = true;
        return this.currentOut;
    }

    public void closeEntry() throws IOException {
        this.currentOut.close();
    }

    public void setProperties(Properties properties) throws IOException {
        if (this.dataWritten) {
            throw new IOException("Backup properties need to be set before any backup data is written");
        }
        File propFile = new File(this.currentDir, "backup.properties");
        FileOutputStream os = new FileOutputStream(propFile);
        properties.store(os, "Backup properties");
        ((OutputStream)os).close();
    }
}

