/*
 * Decompiled with CFR 0.152.
 */
package org.exist.atom.util;

import org.exist.atom.util.NodeHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOM {
    private DOM() {
    }

    public static void forEachChild(Element parent, NodeHandler filter) {
        for (Node current = parent.getFirstChild(); current != null; current = current.getNextSibling()) {
            Node toProcess = current;
            filter.process(parent, toProcess);
        }
    }

    public static void findChildren(Element parent, String namespaceName, String localName, NodeHandler filter) {
        Node current = parent.getFirstChild();
        while (current != null) {
            if (current.getNodeType() != 1) {
                current = current.getNextSibling();
                continue;
            }
            if (namespaceName == null && current.getNamespaceURI() != null || namespaceName != null && !namespaceName.equals(current.getNamespaceURI())) {
                current = current.getNextSibling();
                continue;
            }
            if (current.getLocalName().equals(localName)) {
                Node toProcess = current;
                current = current.getNextSibling();
                filter.process(parent, toProcess);
                continue;
            }
            current = current.getNextSibling();
        }
    }

    public static Element findChild(Element parent, String namespaceName, String localName) {
        Node current = parent.getFirstChild();
        while (current != null) {
            if (current.getNodeType() != 1) {
                current = current.getNextSibling();
                continue;
            }
            if (namespaceName == null && current.getNamespaceURI() != null || namespaceName != null && !namespaceName.equals(current.getNamespaceURI())) {
                current = current.getNextSibling();
                continue;
            }
            if (current.getLocalName().equals(localName)) {
                return (Element)current;
            }
            current = current.getNextSibling();
        }
        return null;
    }

    public static Element replaceTextElement(Element parent, String namespaceName, String localName, String value, boolean firstChild) {
        return DOM.replaceTextElement(parent, namespaceName, localName, value, firstChild, false);
    }

    public static Element replaceTextElement(Element parent, String namespaceName, String localName, String value, boolean firstChild, boolean wrap) {
        Element textE = DOM.findChild(parent, namespaceName, localName);
        if (textE == null) {
            textE = parent.getOwnerDocument().createElementNS(namespaceName, localName);
            if (firstChild) {
                if (wrap) {
                    parent.insertBefore(parent.getOwnerDocument().createTextNode("\n"), parent.getFirstChild());
                }
                parent.insertBefore(textE, parent.getFirstChild());
            } else {
                parent.appendChild(textE);
                if (wrap) {
                    parent.appendChild(parent.getOwnerDocument().createTextNode("\n"));
                }
            }
        }
        DOM.removeChildren(textE);
        textE.appendChild(parent.getOwnerDocument().createTextNode(value));
        return textE;
    }

    public static void replaceText(Element textE, String value) {
        DOM.removeChildren(textE);
        textE.appendChild(textE.getOwnerDocument().createTextNode(value));
    }

    public static void removeChildren(Element parent) {
        for (Node current = parent.getFirstChild(); current != null; current = current.getNextSibling()) {
            Node toRemove = current;
            parent.removeChild(toRemove);
        }
    }

    public static String textContent(Node n) {
        if (n.getNodeType() == 1) {
            StringBuffer builder = new StringBuffer();
            for (Node current = n.getFirstChild(); current != null; current = current.getNextSibling()) {
                short type = current.getNodeType();
                if (type != 4 && type != 3) continue;
                builder.append(current.getNodeValue());
            }
            return builder.toString();
        }
        return n.getNodeValue();
    }
}

