/*
 * Decompiled with CFR 0.152.
 */
package org.exist;

import java.net.BindException;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import org.exist.cluster.ClusterComunication;
import org.exist.cluster.ClusterException;
import org.exist.storage.BrokerPool;
import org.exist.util.Configuration;
import org.exist.util.SingleInstanceConfiguration;
import org.exist.validation.XmlLibraryChecker;
import org.exist.xmldb.DatabaseImpl;
import org.exist.xmldb.ShutdownListener;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpListener;
import org.mortbay.jetty.Server;
import org.mortbay.util.MultiException;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Database;

public class JettyStart {
    public static void main(String[] args) {
        JettyStart start = new JettyStart();
        start.run(args, null);
    }

    public JettyStart() {
        XmlLibraryChecker.check();
    }

    public void run(String[] args, Observer observer) {
        if (args.length == 0) {
            System.out.println("No configuration file specified!");
            return;
        }
        String shutdownHookOption = System.getProperty("exist.register-shutdown-hook", "true");
        boolean registerShutdownHook = shutdownHookOption.equals("true");
        System.out.println("Configuring eXist from " + SingleInstanceConfiguration.getPath());
        try {
            BrokerPool.setRegisterShutdownHook(false);
            SingleInstanceConfiguration config = args.length == 2 ? new SingleInstanceConfiguration(args[1]) : new SingleInstanceConfiguration();
            if (observer != null) {
                BrokerPool.registerStatusObserver(observer);
            }
            BrokerPool.configure(1, 5, config);
            DatabaseImpl xmldb = new DatabaseImpl();
            xmldb.setProperty("create-database", "false");
            DatabaseManager.registerDatabase((Database)xmldb);
            this.configureCluster(config);
        }
        catch (Exception e) {
            System.err.println("configuration error: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        int port = 8080;
        try {
            final Server server = new Server(args[0]);
            BrokerPool.getInstance().registerShutdownListener(new ShutdownListenerImpl(server));
            server.start();
            HttpListener[] listeners = server.getListeners();
            if (listeners.length > 0) {
                port = listeners[0].getPort();
            }
            HttpContext[] contexts = server.getContexts();
            System.out.println("-----------------------------------------------------");
            System.out.println("Server has started on port " + port + ". Configured contexts:");
            for (int i = 0; i < contexts.length; ++i) {
                System.out.println("http://localhost:" + port + contexts[i].getContextPath());
            }
            System.out.println("-----------------------------------------------------");
            if (registerShutdownHook) {
                Thread hook = new Thread(){

                    public void run() {
                        this.setName("Shutdown");
                        BrokerPool.stopAll(true);
                        try {
                            server.stop();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                Runtime.getRuntime().addShutdownHook(hook);
            }
        }
        catch (MultiException e) {
            boolean hasBindException = false;
            for (int i = 0; i < e.size(); ++i) {
                Exception t = e.getException(i);
                if (!(t instanceof BindException)) continue;
                hasBindException = true;
                System.out.println("----------------------------------------------------------");
                System.out.println("ERROR: Could not start jetty, port " + port + " is already in use.   ");
                System.out.println(t.toString());
                System.out.println("----------------------------------------------------------");
            }
            if (!hasBindException) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        BrokerPool.stopAll(false);
    }

    private void configureCluster(Configuration c) throws ClusterException {
        String database = (String)c.getProperty("database");
        if (!database.equalsIgnoreCase("NATIVE_CLUSTER")) {
            return;
        }
        ClusterComunication.configure(c);
    }

    private static class ShutdownListenerImpl
    implements ShutdownListener {
        private Server server;

        public ShutdownListenerImpl(Server server) {
            this.server = server;
        }

        public void shutdown(String dbname, int remainingInstances) {
            System.err.println("Database shutdown: stopping server in 1sec ...");
            if (remainingInstances == 0) {
                Timer timer = new Timer();
                timer.schedule(new TimerTask(){

                    public void run() {
                        try {
                            ShutdownListenerImpl.this.server.stop();
                            ClusterComunication cluster = ClusterComunication.getInstance();
                            if (cluster != null) {
                                cluster.stop();
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        System.exit(0);
                    }
                }, 1000L);
            }
        }
    }
}

