/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.serenitybdd.reports.model.DurationBucket;
import net.serenitybdd.reports.model.DurationDistribution;
import net.serenitybdd.reports.model.TestCaseDuration;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestStep;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.util.EnvironmentVariables;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 ;2\u00020\u0001:\u0001;B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\bJ\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\bJ\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u000fJ\u0018\u0010$\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u0017H\u0002J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0017J\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\bJ\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0,J\u0006\u0010-\u001a\u00020\u0017J\u000e\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u000200J\u000e\u00101\u001a\u00020\u00172\u0006\u0010/\u001a\u000200J\b\u00102\u001a\u000203H\u0002J\u000e\u00104\u001a\u00020\u00172\u0006\u0010/\u001a\u000200J\u0016\u00105\u001a\b\u0012\u0004\u0012\u00020\u001e0\b2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u00106\u001a\u00020'2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0010\u00107\u001a\u00020'2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0010\u00108\u001a\u00020'2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u000e\u00109\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u000fJ\u0016\u0010:\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020\u0017R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006<"}, d2={"Lnet/serenitybdd/reports/model/DurationDistribution;", "", "environmentVariables", "Lnet/thucydides/model/util/EnvironmentVariables;", "testOutcomes", "Lnet/thucydides/model/reports/TestOutcomes;", "(Lnet/thucydides/model/util/EnvironmentVariables;Lnet/thucydides/model/reports/TestOutcomes;)V", "durationBuckets", "", "Lnet/serenitybdd/reports/model/DurationBucket;", "getDurationBuckets", "()Ljava/util/List;", "setDurationBuckets", "(Ljava/util/List;)V", "durationLimits", "Ljava/time/Duration;", "getDurationLimits", "setDurationLimits", "getEnvironmentVariables", "()Lnet/thucydides/model/util/EnvironmentVariables;", "getTestOutcomes", "()Lnet/thucydides/model/reports/TestOutcomes;", "asFormattedList", "", "labels", "distributionLabels", "durationBucketsFrom", "durationLimitsDefinedIn", "findMatchingBucketForTestCase", "testCase", "Lnet/serenitybdd/reports/model/TestCaseDuration;", "findMatchingBucketsForTestOutcome", "testOutcome", "Lnet/thucydides/model/domain/TestOutcome;", "formatted", "duration", "formattedWithUnit", "unit", "getBucketCount", "", "getBucketLabels", "getDurationTags", "Lnet/thucydides/model/domain/TestTag;", "getDurationTagsSet", "", "getNumberOfTestsPerDuration", "hours", "value", "", "minutes", "populateDurationBuckets", "", "seconds", "testCaseDurationsIn", "toHoursPart", "toMinutesPart", "toSecondsPart", "unitOf", "valueOf", "Companion", "serenity-stats"})
@SourceDebugExtension(value={"SMAP\nDurationDistribution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DurationDistribution.kt\nnet/serenitybdd/reports/model/DurationDistribution\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1549#2:191\n1620#2,3:192\n1360#2:195\n1446#2,5:196\n1549#2:201\n1620#2,3:202\n1549#2:205\n1620#2,3:206\n288#2,2:209\n1549#2:211\n1620#2,3:212\n1549#2:215\n1620#2,3:216\n1549#2:219\n1620#2,3:220\n*S KotlinDebug\n*F\n+ 1 DurationDistribution.kt\nnet/serenitybdd/reports/model/DurationDistribution\n*L\n56#1:191\n56#1:192,3\n62#1:195\n62#1:196,5\n72#1:201\n72#1:202,3\n175#1:205\n175#1:206,3\n181#1:209,2\n185#1:211\n185#1:212,3\n187#1:215\n187#1:216,3\n188#1:219\n188#1:220,3\n*E\n"})
public final class DurationDistribution {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EnvironmentVariables environmentVariables;
    @NotNull
    private final TestOutcomes testOutcomes;
    @NotNull
    private List<Duration> durationLimits;
    @NotNull
    private List<DurationBucket> durationBuckets;
    @NotNull
    public static final String DEFAULT_DURATION_RANGES_IN_SECONDS = "1, 10, 30, 60, 120, 300, 600";

    @NotNull
    public final EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @NotNull
    public final TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public DurationDistribution(@NotNull EnvironmentVariables environmentVariables, @NotNull TestOutcomes testOutcomes) {
        Intrinsics.checkNotNullParameter((Object)environmentVariables, (String)"environmentVariables");
        Intrinsics.checkNotNullParameter((Object)testOutcomes, (String)"testOutcomes");
        this.environmentVariables = environmentVariables;
        this.testOutcomes = testOutcomes;
        this.durationLimits = this.durationLimitsDefinedIn(environmentVariables);
        this.durationBuckets = this.durationBucketsFrom(this.durationLimits);
        this.populateDurationBuckets();
    }

    @NotNull
    public final List<Duration> getDurationLimits() {
        return this.durationLimits;
    }

    public final void setDurationLimits(@NotNull List<Duration> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.durationLimits = list;
    }

    @NotNull
    public final List<DurationBucket> getDurationBuckets() {
        return this.durationBuckets;
    }

    public final void setDurationBuckets(@NotNull List<DurationBucket> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.durationBuckets = list;
    }

    private final List<DurationBucket> durationBucketsFrom(List<Duration> durationLimits) {
        List durationBuckets = new ArrayList();
        List<String> bucketLabels = this.distributionLabels();
        Duration lowerLimit = Duration.ofMillis(0L);
        Iterator iterator = CollectionsKt.plus((Collection)durationLimits, (Object)ChronoUnit.FOREVER.getDuration()).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Duration durationLimit = (Duration)iterator.next();
            Duration duration = lowerLimit;
            Intrinsics.checkNotNull((Object)duration);
            Intrinsics.checkNotNull((Object)durationLimit);
            durationBuckets.add(new DurationBucket(bucketLabels.get(index), duration, durationLimit, new ArrayList()));
            lowerLimit = durationLimit;
        }
        return durationBuckets;
    }

    public final int getBucketCount() {
        return this.distributionLabels().size();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getNumberOfTestsPerDuration() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.durationBuckets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void bucket;
            DurationBucket durationBucket = (DurationBucket)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(bucket.getOutcomes().size());
        }
        List durationCounts = (List)destination$iv$iv;
        return this.asFormattedList(durationCounts);
    }

    /*
     * WARNING - void declaration
     */
    private final void populateDurationBuckets() {
        void $this$flatMapTo$iv$iv;
        List list = this.testOutcomes.getTests();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTests(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            TestOutcome testCase = (TestOutcome)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)testCase);
            Iterable list$iv$iv = this.testCaseDurationsIn(testCase);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List testCaseDurations = (List)destination$iv$iv;
        for (TestCaseDuration testCaseDuration : testCaseDurations) {
            this.findMatchingBucketForTestCase(testCaseDuration).addOutcome(testCaseDuration);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TestCaseDuration> testCaseDurationsIn(TestOutcome testOutcome) {
        List list;
        if (testOutcome.isDataDriven()) {
            void $this$mapTo$iv$iv;
            List list2 = testOutcome.getTestSteps();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTestSteps(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void testStep;
                TestStep testStep2 = (TestStep)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = testStep.getDescription();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
                long l = testStep.getDuration();
                TestOutcome testOutcome2 = testOutcome.fromStep((TestStep)testStep);
                Intrinsics.checkNotNullExpressionValue((Object)testOutcome2, (String)"fromStep(...)");
                collection.add(new TestCaseDuration(string, l, testOutcome2));
            }
            list = (List)destination$iv$iv;
        } else {
            String string = testOutcome.getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
            Long l = testOutcome.getDuration();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"getDuration(...)");
            list = CollectionsKt.listOf((Object)new TestCaseDuration(string, ((Number)l).longValue(), testOutcome));
        }
        return list;
    }

    @NotNull
    public final List<String> distributionLabels() {
        List labels = new ArrayList();
        labels.add("Under " + this.formatted((Duration)CollectionsKt.first(this.durationLimits)));
        int i = 0;
        int n = this.durationLimits.size() - 2;
        if (i <= n) {
            while (true) {
                Duration lowerLimit = this.durationLimits.get(i);
                Duration upperLimit = this.durationLimits.get(i + 1);
                String label = Intrinsics.areEqual((Object)this.unitOf(lowerLimit), (Object)this.unitOf(upperLimit)) ? this.valueOf(lowerLimit, this.unitOf(lowerLimit)) + " to " + this.formatted(upperLimit) : (!Intrinsics.areEqual((Object)this.unitOf(lowerLimit), (Object)this.unitOf(upperLimit)) && Intrinsics.areEqual((Object)this.valueOf(upperLimit, this.unitOf(upperLimit)), (Object)"1") ? this.valueOf(lowerLimit, this.unitOf(lowerLimit)) + " to " + this.formattedWithUnit(upperLimit, this.unitOf(lowerLimit)) : this.formatted(lowerLimit) + " to " + this.formatted(upperLimit));
                labels.add(label);
                if (i == n) break;
                ++i;
            }
        }
        labels.add(this.formatted((Duration)CollectionsKt.last(this.durationLimits)) + " or over");
        return labels;
    }

    @NotNull
    public final String getBucketLabels() {
        return this.asFormattedList(this.distributionLabels());
    }

    @NotNull
    public final String asFormattedList(@NotNull List<? extends Object> labels) {
        Intrinsics.checkNotNullParameter(labels, (String)"labels");
        return "[" + CollectionsKt.joinToString$default((Iterable)labels, (CharSequence)",", null, null, (int)0, null, (Function1)asFormattedList.1.INSTANCE, (int)30, null) + "]";
    }

    @NotNull
    public final String unitOf(@NotNull Duration duration) {
        String string;
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        if (this.toHoursPart(duration) > 0) {
            string = "HOURS";
        } else if (this.toMinutesPart(duration) > 0) {
            string = "MINUTES";
        } else {
            if (duration.getSeconds() > 0L) {
                return "SECONDS";
            }
            string = "MILLISECONDS";
        }
        return string;
    }

    private final String formattedWithUnit(Duration duration, String unit) {
        Object object;
        switch (unit) {
            case "SECONDS": {
                object = ((Object)StringsKt.trim((CharSequence)this.seconds(duration.get(ChronoUnit.SECONDS)))).toString();
                break;
            }
            case "MINUTES": {
                object = ((Object)StringsKt.trim((CharSequence)this.minutes(duration.get(ChronoUnit.MINUTES)))).toString();
                break;
            }
            case "HOURS": {
                object = ((Object)StringsKt.trim((CharSequence)this.hours(duration.get(ChronoUnit.HOURS)))).toString();
                break;
            }
            default: {
                object = duration.toMillis() + " ms";
            }
        }
        return object;
    }

    @NotNull
    public final String valueOf(@NotNull Duration duration, @NotNull String unit) {
        String string;
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        switch (unit) {
            case "SECONDS": {
                string = String.valueOf(duration.getSeconds());
                break;
            }
            case "MINUTES": {
                string = String.valueOf(duration.getSeconds() / (long)60);
                break;
            }
            case "HOURS": {
                string = String.valueOf(duration.getSeconds() / (long)3600);
                break;
            }
            default: {
                string = String.valueOf(duration.toMillis());
            }
        }
        return string;
    }

    @NotNull
    public final String formatted(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        long hours = duration.toHours();
        int minutes = this.toMinutesPart(duration);
        int seconds = this.toSecondsPart(duration);
        return ((Object)StringsKt.trim((CharSequence)(this.hours(hours) + " " + this.minutes(minutes) + " " + this.seconds(seconds)))).toString();
    }

    @NotNull
    public final String seconds(long value) {
        if (value == 0L) {
            return "";
        }
        return value == 1L ? value + " second" : value + " seconds";
    }

    @NotNull
    public final String minutes(long value) {
        if (value == 0L) {
            return "";
        }
        return value == 1L ? value + " minute" : value + " minutes";
    }

    @NotNull
    public final String hours(long value) {
        if (value == 0L) {
            return "";
        }
        return value == 1L ? value + " hour" : value + " hours";
    }

    private final int toHoursPart(Duration duration) {
        return (int)(duration.toHours() % (long)24);
    }

    private final int toMinutesPart(Duration duration) {
        return (int)(duration.toMinutes() % (long)60);
    }

    private final int toSecondsPart(Duration duration) {
        return (int)(duration.getSeconds() % (long)60);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Duration> durationLimitsDefinedIn(EnvironmentVariables environmentVariables) {
        void $this$mapTo$iv$iv;
        String durationLimits = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(ThucydidesSystemProperty.SERENITY_REPORT_DURATIONS).orElse(DEFAULT_DURATION_RANGES_IN_SECONDS);
        Intrinsics.checkNotNull((Object)durationLimits);
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)durationLimits, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void value;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Duration.ofSeconds(Integer.parseInt(((Object)StringsKt.trim((CharSequence)((CharSequence)value))).toString())));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final DurationBucket findMatchingBucketForTestCase(@NotNull TestCaseDuration testCase) {
        DurationBucket durationBucket;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
            Iterable $this$firstOrNull$iv = this.durationBuckets;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DurationBucket bucket = (DurationBucket)element$iv;
                boolean bl = false;
                Duration duration = Duration.ofMillis(testCase.getDuration());
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
                if (!bucket.contains(duration)) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((durationBucket = (DurationBucket)v1) == null) {
            durationBucket = (DurationBucket)CollectionsKt.first(this.durationBuckets);
        }
        return durationBucket;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DurationBucket> findMatchingBucketsForTestOutcome(@NotNull TestOutcome testOutcome) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)testOutcome, (String)"testOutcome");
        Iterable $this$map$iv = this.testCaseDurationsIn(testOutcome);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void testCaseDuration;
            TestCaseDuration testCaseDuration2 = (TestCaseDuration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.findMatchingBucketForTestCase((TestCaseDuration)testCaseDuration));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestTag> getDurationTags() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.durationBuckets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void bucket;
            DurationBucket durationBucket = (DurationBucket)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(bucket.getTag());
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<TestTag> getDurationTagsSet() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.durationBuckets;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void bucket;
            DurationBucket durationBucket = (DurationBucket)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(bucket.getTag());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/serenitybdd/reports/model/DurationDistribution$Companion;", "", "()V", "DEFAULT_DURATION_RANGES_IN_SECONDS", "", "serenity-stats"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

