/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\u0014\u0010\u000b\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000e\u001a\u0014\u0010\u000f\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0015\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u000e\u001a\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0016\u0010\u0011\u001a\u00020\f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\r\u001a\u00020\u0004\u001a\u0014\u0010\u0013\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\u0014"}, d2={"averageDurationOf", "Ljava/time/Duration;", "outcomes", "", "Lnet/thucydides/core/model/TestOutcome;", "clockDurationOf", "endTimeOf", "Ljava/time/ZonedDateTime;", "formattedDuration", "", "duration", "maxDurationOf", "", "outcome", "(Lnet/thucydides/core/model/TestOutcome;)Ljava/lang/Long;", "minDurationOf", "startTimeOf", "startToFinishTimeIn", "testCaseDurationsIn", "totalDurationOf", "serenity-stats"})
@SourceDebugExtension(value={"SMAP\nDurations.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Durations.kt\nnet/serenitybdd/reports/model/DurationsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1#2:93\n766#3:94\n857#3,2:95\n766#3:97\n857#3,2:98\n1360#3:100\n1446#3,5:101\n1549#3:106\n1620#3,3:107\n1549#3:110\n1620#3,3:111\n*S KotlinDebug\n*F\n+ 1 Durations.kt\nnet/serenitybdd/reports/model/DurationsKt\n*L\n44#1:94\n44#1:95,2\n48#1:97\n48#1:98,2\n64#1:100\n64#1:101,5\n65#1:106\n65#1:107,3\n72#1:110\n72#1:111,3\n*E\n"})
public final class DurationsKt {
    @NotNull
    public static final Duration maxDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        long l;
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        if (outcomes.isEmpty()) {
            l = 0L;
        } else {
            Iterator iterator = ((Iterable)outcomes).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            TestOutcome outcome = (TestOutcome)iterator.next();
            boolean bl = false;
            Long l2 = DurationsKt.maxDurationOf(outcome);
            Intrinsics.checkNotNull((Object)l2);
            long l3 = l2;
            while (iterator.hasNext()) {
                TestOutcome outcome2 = (TestOutcome)iterator.next();
                $i$a$-maxOf-DurationsKt$maxDurationOf$1 = false;
                Long l4 = DurationsKt.maxDurationOf(outcome2);
                Intrinsics.checkNotNull((Object)l4);
                long l5 = l4;
                if (l3 >= l5) continue;
                l3 = l5;
            }
            l = l3;
        }
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n    if (outcom\u2026DurationOf(outcome)!! }\n)");
        return duration;
    }

    @NotNull
    public static final Duration minDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        long l;
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        if (outcomes.isEmpty()) {
            l = 0L;
        } else {
            Iterator iterator = ((Iterable)outcomes).iterator();
            if (!iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            TestOutcome outcome = (TestOutcome)iterator.next();
            boolean bl = false;
            Long l2 = DurationsKt.minDurationOf(outcome);
            Intrinsics.checkNotNull((Object)l2);
            long l3 = l2;
            while (iterator.hasNext()) {
                TestOutcome outcome2 = (TestOutcome)iterator.next();
                $i$a$-minOf-DurationsKt$minDurationOf$1 = false;
                Long l4 = DurationsKt.minDurationOf(outcome2);
                Intrinsics.checkNotNull((Object)l4);
                long l5 = l4;
                if (l3 <= l5) continue;
                l3 = l5;
            }
            l = l3;
        }
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n    if (outcom\u2026DurationOf(outcome)!! }\n)");
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Duration totalDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        long l;
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        if (outcomes.isEmpty()) {
            l = 0L;
        } else {
            Iterable iterable = outcomes;
            long l2 = 0L;
            for (Object t : iterable) {
                Long l3;
                void outcome;
                TestOutcome testOutcome = (TestOutcome)t;
                long l4 = l2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)outcome.getDuration(), (String)"outcome.duration");
                l2 = l4 + ((Number)l3).longValue();
            }
            l = l2;
        }
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n    if (outcom\u2026e -> outcome.duration }\n)");
        return duration;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final Long maxDurationOf(@NotNull TestOutcome outcome) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        if (outcome.isDataDriven()) {
            List list = outcome.getTestSteps();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"outcome.testSteps");
            if (!((Collection)list).isEmpty()) {
                Comparable comparable;
                List list2 = outcome.getTestSteps();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"outcome.testSteps");
                Iterator iterator = ((Iterable)list2).iterator();
                if (!iterator.hasNext()) {
                    comparable = null;
                } else {
                    TestStep step = (TestStep)iterator.next();
                    boolean bl = false;
                    Comparable comparable2 = Long.valueOf(step.getDuration());
                    while (iterator.hasNext()) {
                        TestStep step2 = (TestStep)iterator.next();
                        $i$a$-maxOfOrNull-DurationsKt$maxDurationOf$2 = false;
                        Comparable comparable3 = Long.valueOf(step2.getDuration());
                        if (comparable2.compareTo(comparable3) >= 0) continue;
                        comparable2 = comparable3;
                    }
                    comparable = comparable2;
                }
                l = (Long)comparable;
                return l;
            }
        }
        l = outcome.getDuration();
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static final Long minDurationOf(@NotNull TestOutcome outcome) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        if (outcome.isDataDriven()) {
            List list = outcome.getTestSteps();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"outcome.testSteps");
            if (!((Collection)list).isEmpty()) {
                Comparable comparable;
                List list2 = outcome.getTestSteps();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"outcome.testSteps");
                Iterator iterator = ((Iterable)list2).iterator();
                if (!iterator.hasNext()) {
                    comparable = null;
                } else {
                    TestStep step = (TestStep)iterator.next();
                    boolean bl = false;
                    Comparable comparable2 = Long.valueOf(step.getDuration());
                    while (iterator.hasNext()) {
                        TestStep step2 = (TestStep)iterator.next();
                        $i$a$-minOfOrNull-DurationsKt$minDurationOf$2 = false;
                        Comparable comparable3 = Long.valueOf(step2.getDuration());
                        if (comparable2.compareTo(comparable3) <= 0) continue;
                        comparable2 = comparable3;
                    }
                    comparable = comparable2;
                }
                l = (Long)comparable;
                return l;
            }
        }
        l = outcome.getDuration();
        return l;
    }

    @NotNull
    public static final Duration clockDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        Duration duration = Duration.ofMillis(outcomes.isEmpty() ? 0L : DurationsKt.startToFinishTimeIn(outcomes));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n    if (outcom\u2026hTimeIn(outcomes)\n    }\n)");
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ZonedDateTime startTimeOf(@NotNull List<? extends TestOutcome> outcomes) {
        Object object;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        Iterable $this$filter$iv = outcomes;
        boolean $i$f$filter = false;
        Object object2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestOutcome outcome = (TestOutcome)element$iv$iv;
            boolean bl = false;
            if (!(outcome.getStartTime() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            TestOutcome outcome = (TestOutcome)iterator.next();
            boolean bl = false;
            object2 = outcome.getStartTime();
            while (iterator.hasNext()) {
                TestOutcome outcome2 = (TestOutcome)iterator.next();
                $i$a$-minOfOrNull-DurationsKt$startTimeOf$2 = false;
                Comparable comparable = outcome2.getStartTime();
                if (object2.compareTo(comparable) <= 0) continue;
                object2 = comparable;
            }
            object = object2;
        }
        return (ZonedDateTime)object;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final ZonedDateTime endTimeOf(@NotNull List<? extends TestOutcome> outcomes) {
        Object object;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        Iterable $this$filter$iv = outcomes;
        boolean $i$f$filter = false;
        Object object2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestOutcome outcome = (TestOutcome)element$iv$iv;
            boolean bl = false;
            if (!(outcome.getStartTime() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            TestOutcome outcome = (TestOutcome)iterator.next();
            boolean bl = false;
            ZonedDateTime zonedDateTime = outcome.getStartTime();
            Long l = outcome.getDuration();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"outcome.duration");
            object2 = zonedDateTime.plus(Duration.ofMillis(((Number)l).longValue()));
            while (iterator.hasNext()) {
                TestOutcome outcome2 = (TestOutcome)iterator.next();
                $i$a$-maxOfOrNull-DurationsKt$endTimeOf$2 = false;
                ZonedDateTime zonedDateTime2 = outcome2.getStartTime();
                Long l2 = outcome2.getDuration();
                Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"outcome.duration");
                Comparable comparable = zonedDateTime2.plus(Duration.ofMillis(((Number)l2).longValue()));
                if (object2.compareTo(comparable) >= 0) continue;
                object2 = comparable;
            }
            object = object2;
        }
        return (ZonedDateTime)object;
    }

    private static final long startToFinishTimeIn(List<? extends TestOutcome> outcomes) {
        ZonedDateTime minStartTime = DurationsKt.startTimeOf(outcomes);
        ZonedDateTime maxEndTime = DurationsKt.endTimeOf(outcomes);
        return minStartTime != null && maxEndTime != null ? ChronoUnit.MILLIS.between(minStartTime, maxEndTime) : 0L;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Duration averageDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        long l;
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        if (outcomes.isEmpty()) {
            l = 0L;
        } else {
            void $this$mapTo$iv$iv;
            Object list$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = outcomes;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                TestOutcome outcome = (TestOutcome)element$iv$iv;
                boolean bl = false;
                list$iv$iv = DurationsKt.testCaseDurationsIn(outcome);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void duration;
                list$iv$iv = (Duration)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(duration.toMillis());
            }
            l = (long)CollectionsKt.averageOfLong((Iterable)((List)destination$iv$iv));
        }
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n    if (outcom\u2026)\n            .toLong()\n)");
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Duration> testCaseDurationsIn(@NotNull TestOutcome outcome) {
        List list;
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        if (outcome.isDataDriven()) {
            void $this$mapTo$iv$iv;
            List list2 = outcome.getTestSteps();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"outcome.testSteps");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void step;
                TestStep testStep = (TestStep)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Duration.ofMillis(step.getDuration()));
            }
            list = (List)destination$iv$iv;
        } else {
            Long l = outcome.getDuration();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"outcome.duration");
            list = CollectionsKt.listOf((Object)Duration.ofMillis(((Number)l).longValue()));
        }
        return list;
    }

    @NotNull
    public static final String formattedDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        long days = duration.toDays();
        long hours = duration.toHours() - days * (long)24;
        long minutes = duration.toMinutes() - days * (long)24 * (long)60 - hours * (long)60;
        long seconds = duration.getSeconds() - days * (long)24 * (long)60 * (long)60 - hours * (long)60 * (long)60 - minutes * (long)60;
        String durationInMilliseconds = "" + duration.toMillis() + "ms";
        String durationForSlowTests = (days > 0L ? "" + days + "d " : "") + (hours > 0L ? "" + ' ' + hours + "h " : "") + (minutes > 0L ? "" + ' ' + minutes + "m " : "") + ((Object)StringsKt.trim((CharSequence)(seconds > 0L ? "" + ' ' + seconds + "s " : "0s "))).toString();
        return duration.toMillis() < 1000L ? durationInMilliseconds : durationForSlowTests;
    }
}

