/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.serenitybdd.reports.model.TestCaseDuration;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0018\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lnet/serenitybdd/reports/model/DurationBucket;", "", "duration", "", "minDuration", "Ljava/time/Duration;", "maxDuration", "outcomes", "", "Lnet/serenitybdd/reports/model/TestCaseDuration;", "(Ljava/lang/String;Ljava/time/Duration;Ljava/time/Duration;Ljava/util/List;)V", "getDuration", "()Ljava/lang/String;", "getMaxDuration", "()Ljava/time/Duration;", "getMinDuration", "getOutcomes", "()Ljava/util/List;", "addOutcome", "", "testCaseDuration", "contains", "", "getTag", "Lnet/thucydides/core/model/TestTag;", "getTestOutcomes", "", "Lnet/thucydides/core/model/TestOutcome;", "withExamplesOfMatchingDuration", "title", "outcome", "serenity-stats"})
public final class DurationBucket {
    @NotNull
    private final String duration;
    @NotNull
    private final Duration minDuration;
    @NotNull
    private final Duration maxDuration;
    @NotNull
    private final List<TestCaseDuration> outcomes;

    public DurationBucket(@NotNull String duration, @NotNull Duration minDuration, @NotNull Duration maxDuration, @NotNull List<TestCaseDuration> outcomes) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)minDuration, (String)"minDuration");
        Intrinsics.checkNotNullParameter((Object)maxDuration, (String)"maxDuration");
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        this.duration = duration;
        this.minDuration = minDuration;
        this.maxDuration = maxDuration;
        this.outcomes = outcomes;
    }

    @NotNull
    public final String getDuration() {
        return this.duration;
    }

    @NotNull
    public final Duration getMinDuration() {
        return this.minDuration;
    }

    @NotNull
    public final Duration getMaxDuration() {
        return this.maxDuration;
    }

    @NotNull
    public final List<TestCaseDuration> getOutcomes() {
        return this.outcomes;
    }

    public final void addOutcome(@NotNull TestCaseDuration testCaseDuration) {
        Intrinsics.checkNotNullParameter((Object)testCaseDuration, (String)"testCaseDuration");
        if (testCaseDuration.getTestOutcome().isDataDriven()) {
            String outcomeTitle = testCaseDuration.getTestOutcome().getTitle() + " (" + this.duration + ')';
            this.outcomes.add(this.withExamplesOfMatchingDuration(outcomeTitle, testCaseDuration.getTestOutcome()));
        } else {
            this.outcomes.add(testCaseDuration);
        }
    }

    private final TestCaseDuration withExamplesOfMatchingDuration(String title, TestOutcome outcome) {
        TestOutcome outcomeWithMatchingExamples = outcome.copy().removeTopLevelStepsNotMatching(arg_0 -> DurationBucket.withExamplesOfMatchingDuration$lambda$0(this, arg_0));
        long outcomeDuration = outcomeWithMatchingExamples.getTestSteps().isEmpty() ? 0L : ((TestStep)outcomeWithMatchingExamples.getTestSteps().get(0)).getDuration();
        Intrinsics.checkNotNullExpressionValue((Object)outcomeWithMatchingExamples, (String)"outcomeWithMatchingExamples");
        return new TestCaseDuration(title, outcomeDuration, outcomeWithMatchingExamples);
    }

    public final boolean contains(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return duration.compareTo(this.minDuration) >= 0 && duration.compareTo(this.maxDuration) <= 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TestOutcome> getTestOutcomes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.outcomes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void outcome;
            TestCaseDuration testCaseDuration = (TestCaseDuration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(outcome.getTestOutcome());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final TestTag getTag() {
        TestTag testTag = TestTag.withName((String)this.duration).andType("Duration");
        Intrinsics.checkNotNullExpressionValue((Object)testTag, (String)"withName(duration).andType(\"Duration\")");
        return testTag;
    }

    private static final boolean withExamplesOfMatchingDuration$lambda$0(DurationBucket this$0, TestStep testStep) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Duration duration = Duration.ofMillis(testStep.getDuration());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(testStep.duration)");
        return this$0.contains(duration);
    }
}

