/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0014\u0010\u0005\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001\u001a\u0014\u0010\t\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0015\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\f\u001a\u0014\u0010\r\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u001a\u0015\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\f\u001a\u0016\u0010\u000e\u001a\u00020\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a8\u0006\u0010"}, d2={"averageDurationOf", "Ljava/time/Duration;", "outcomes", "", "Lnet/thucydides/core/model/TestOutcome;", "clockDurationOf", "formattedDuration", "", "duration", "maxDurationOf", "", "outcome", "(Lnet/thucydides/core/model/TestOutcome;)Ljava/lang/Long;", "minDurationOf", "startToFinishTimeIn", "totalDurationOf", "serenity-stats"})
public final class DurationsKt {
    @NotNull
    public static final Duration maxDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        long l;
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        if (outcomes.isEmpty()) {
            l = 0L;
        } else {
            Iterable iterable = outcomes;
            boolean bl = false;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw (Throwable)new NoSuchElementException();
            }
            TestOutcome outcome = (TestOutcome)iterator.next();
            boolean bl2 = false;
            Long l2 = DurationsKt.maxDurationOf(outcome);
            Intrinsics.checkNotNull((Object)l2);
            long l3 = l2;
            while (iterator.hasNext()) {
                TestOutcome outcome2 = (TestOutcome)iterator.next();
                $i$a$-maxOf-DurationsKt$maxDurationOf$1 = false;
                Long l4 = DurationsKt.maxDurationOf(outcome2);
                Intrinsics.checkNotNull((Object)l4);
                long l5 = l4;
                if (l3 >= l5) continue;
                l3 = l5;
            }
            l = l3;
        }
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n//        if (outcomes.isEmpty()) 0 else outcomes.map { outcome -> maxDurationOf(outcome) }.maxOrNull()!!\n        if (outcomes.isEmpty()) 0 else outcomes.maxOf { outcome -> maxDurationOf(outcome)!! }\n)");
        return duration;
    }

    @NotNull
    public static final Duration minDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        long l;
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        if (outcomes.isEmpty()) {
            l = 0L;
        } else {
            Iterable iterable = outcomes;
            boolean bl = false;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                throw (Throwable)new NoSuchElementException();
            }
            TestOutcome outcome = (TestOutcome)iterator.next();
            boolean bl2 = false;
            Long l2 = DurationsKt.minDurationOf(outcome);
            Intrinsics.checkNotNull((Object)l2);
            long l3 = l2;
            while (iterator.hasNext()) {
                TestOutcome outcome2 = (TestOutcome)iterator.next();
                $i$a$-minOf-DurationsKt$minDurationOf$1 = false;
                Long l4 = DurationsKt.minDurationOf(outcome2);
                Intrinsics.checkNotNull((Object)l4);
                long l5 = l4;
                if (l3 <= l5) continue;
                l3 = l5;
            }
            l = l3;
        }
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n//        if (outcomes.isEmpty()) 0 else outcomes.map { outcome -> minDurationOf(outcome) }.minOrNull()!!\n    if (outcomes.isEmpty()) 0 else outcomes.minOf { outcome -> minDurationOf(outcome)!! }\n)");
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Duration totalDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        long l;
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        if (outcomes.isEmpty()) {
            l = 0L;
        } else {
            Iterable iterable = outcomes;
            boolean bl = false;
            long l2 = 0L;
            for (Object t : iterable) {
                void outcome;
                TestOutcome testOutcome = (TestOutcome)t;
                long l3 = l2;
                boolean bl2 = false;
                Long l4 = outcome.getDuration();
                Intrinsics.checkNotNullExpressionValue((Object)l4, (String)"outcome.duration");
                Long l5 = l4;
                l2 = l3 + ((Number)l5).longValue();
            }
            l = l2;
        }
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n        if (outcomes.isEmpty()) 0 else outcomes.sumOf { outcome -> outcome.duration }\n)");
        return duration;
    }

    @Nullable
    public static final Long maxDurationOf(@NotNull TestOutcome outcome) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        if (outcome.isDataDriven() && !outcome.getTestSteps().isEmpty()) {
            Comparable comparable;
            Iterable iterable = outcome.getTestSteps();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"outcome.testSteps");
            iterable = iterable;
            boolean bl = false;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                TestStep step = (TestStep)iterator.next();
                boolean bl2 = false;
                Comparable comparable2 = Long.valueOf(step.getDuration());
                while (iterator.hasNext()) {
                    TestStep step2 = (TestStep)iterator.next();
                    $i$a$-maxOfOrNull-DurationsKt$maxDurationOf$2 = false;
                    Comparable comparable3 = Long.valueOf(step2.getDuration());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            l = (Long)comparable;
        } else {
            l = outcome.getDuration();
        }
        return l;
    }

    @Nullable
    public static final Long minDurationOf(@NotNull TestOutcome outcome) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)outcome, (String)"outcome");
        if (outcome.isDataDriven() && !outcome.getTestSteps().isEmpty()) {
            Comparable comparable;
            Iterable iterable = outcome.getTestSteps();
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"outcome.testSteps");
            iterable = iterable;
            boolean bl = false;
            Iterator iterator = iterable.iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                TestStep step = (TestStep)iterator.next();
                boolean bl2 = false;
                Comparable comparable2 = Long.valueOf(step.getDuration());
                while (iterator.hasNext()) {
                    TestStep step2 = (TestStep)iterator.next();
                    $i$a$-minOfOrNull-DurationsKt$minDurationOf$2 = false;
                    Comparable comparable3 = Long.valueOf(step2.getDuration());
                    if (comparable2.compareTo(comparable3) <= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            l = (Long)comparable;
        } else {
            l = outcome.getDuration();
        }
        return l;
    }

    @NotNull
    public static final Duration clockDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        Duration duration = Duration.ofMillis(outcomes.isEmpty() ? 0L : DurationsKt.startToFinishTimeIn(outcomes));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n        if (outcomes.isEmpty())\n            0\n        else {\n            startToFinishTimeIn(outcomes)\n        }\n)");
        return duration;
    }

    /*
     * WARNING - void declaration
     */
    private static final long startToFinishTimeIn(List<? extends TestOutcome> outcomes) {
        Comparable comparable;
        void $this$filterTo$iv$iv;
        Object outcome;
        Object object;
        Iterator $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = outcomes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            TestOutcome outcome2 = (TestOutcome)element$iv$iv;
            boolean bl = false;
            if (!(outcome2.getStartTime() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv2 = $this$filter$iv.iterator();
        if (!$this$filterTo$iv$iv2.hasNext()) {
            object = null;
        } else {
            outcome = (TestOutcome)$this$filterTo$iv$iv2.next();
            boolean bl = false;
            outcome = outcome.getStartTime();
            while ($this$filterTo$iv$iv2.hasNext()) {
                Object outcome3 = (TestOutcome)$this$filterTo$iv$iv2.next();
                $i$a$-minOfOrNull-DurationsKt$startToFinishTimeIn$minStartTime$2 = false;
                if (outcome.compareTo(outcome3 = (Comparable)outcome3.getStartTime()) <= 0) continue;
                outcome = outcome3;
            }
            object = outcome;
        }
        ZonedDateTime minStartTime = (ZonedDateTime)object;
        Iterable $this$filter$iv2 = outcomes;
        boolean $i$f$filter2 = false;
        outcome = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestOutcome outcome4 = (TestOutcome)element$iv$iv;
            boolean bl = false;
            if (!(outcome4.getStartTime() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv2;
        boolean bl = false;
        Iterator iterator2 = iterable2.iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            TestOutcome outcome5 = (TestOutcome)iterator2.next();
            boolean bl2 = false;
            Comparable comparable2 = outcome5.getStartTime();
            while (iterator2.hasNext()) {
                TestOutcome outcome6 = (TestOutcome)iterator2.next();
                $i$a$-maxOfOrNull-DurationsKt$startToFinishTimeIn$maxEndTime$2 = false;
                Comparable comparable3 = outcome6.getStartTime();
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        ZonedDateTime maxEndTime = (ZonedDateTime)comparable;
        return minStartTime != null && maxEndTime != null ? ChronoUnit.MILLIS.between(minStartTime, maxEndTime) : 0L;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Duration averageDurationOf(@NotNull List<? extends TestOutcome> outcomes) {
        long l;
        Intrinsics.checkNotNullParameter(outcomes, (String)"outcomes");
        if (outcomes.isEmpty()) {
            l = 0L;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = outcomes;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void outcome;
                TestOutcome testOutcome = (TestOutcome)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Long l2 = outcome.getDuration();
                collection.add(l2);
            }
            l = (long)CollectionsKt.averageOfLong((Iterable)((List)destination$iv$iv));
        }
        Duration duration = Duration.ofMillis(l);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(\n        if (outcomes.isEmpty()) 0 else outcomes.map { outcome -> outcome.duration }.average().toLong()\n)");
        return duration;
    }

    @NotNull
    public static final String formattedDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        long days = duration.toDays();
        long hours = duration.toHours() - days * (long)24;
        long minutes = duration.toMinutes() - days * (long)24 * (long)60 - hours * (long)60;
        long seconds = duration.getSeconds() - days * (long)24 * (long)60 * (long)60 - hours * (long)60 * (long)60 - minutes * (long)60;
        String durationInMilliseconds = "" + duration.toMillis() + "ms";
        String string = seconds > 0L ? "" + ' ' + seconds + "s " : "0s ";
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String durationForSlowTests = (days > 0L ? "" + days + "d " : "") + (hours > 0L ? "" + ' ' + hours + "h " : "") + (minutes > 0L ? "" + ' ' + minutes + "m " : "") + ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return duration.toMillis() < 1000L ? durationInMilliseconds : durationForSlowTests;
    }
}

