/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.reports.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.serenitybdd.reports.model.CoverageByTag;
import net.serenitybdd.reports.model.ResultsCountKt;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\tH\u0002J,\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0002J\u001e\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J*\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u001f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0002R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006#"}, d2={"Lnet/serenitybdd/reports/model/CoverageByTagType;", "", "tagType", "", "tagTitle", "testOutcomes", "Lnet/thucydides/core/reports/TestOutcomes;", "tagsToDisplay", "", "Lnet/thucydides/core/model/TestTag;", "(Ljava/lang/String;Ljava/lang/String;Lnet/thucydides/core/reports/TestOutcomes;Ljava/util/Collection;)V", "tagCoverage", "Lnet/serenitybdd/reports/model/CoverageByTag;", "getTagCoverage", "()Ljava/util/Collection;", "getTagTitle", "()Ljava/lang/String;", "getTagType", "getTestOutcomes", "()Lnet/thucydides/core/reports/TestOutcomes;", "coverageFor", "testTag", "coverageForEachTagOfType", "coverageNotIncludedIn", "", "newCoverage", "completeCoverage", "", "noCoverageFor", "tag", "coverageFromTestOutcomes", "", "shortened", "name", "uncoveredTags", "serenity-stats"})
public final class CoverageByTagType {
    @NotNull
    private final Collection<CoverageByTag> tagCoverage;
    @NotNull
    private final String tagType;
    @NotNull
    private final String tagTitle;
    @NotNull
    private final TestOutcomes testOutcomes;

    @NotNull
    public final Collection<CoverageByTag> getTagCoverage() {
        return this.tagCoverage;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<CoverageByTag> coverageForEachTagOfType(String tagType, TestOutcomes testOutcomes, Collection<? extends TestTag> tagsToDisplay) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv2;
        List list = testOutcomes.getTagsOfType(tagType);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"testOutcomes.getTagsOfType(tagType)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator testTag;
            TestTag testTag2 = (TestTag)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v1 = testTag;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"testTag");
            CoverageByTag coverageByTag = this.coverageFor((TestTag)v1);
            collection.add(coverageByTag);
        }
        List coverageFromTestOutcomes = (List)destination$iv$iv;
        List<CoverageByTag> zeroCoverageForUncoveredTags = this.uncoveredTags(tagsToDisplay, coverageFromTestOutcomes);
        boolean $this$mapTo$iv$iv2 = false;
        List completeCoverage = new ArrayList();
        completeCoverage.addAll(coverageFromTestOutcomes);
        Iterable $this$filter$iv = zeroCoverageForUncoveredTags;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CoverageByTag zeroCoverage = (CoverageByTag)element$iv$iv;
            boolean bl = false;
            if (!this.coverageNotIncludedIn(zeroCoverage, completeCoverage)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CoverageByTag newCoverage = (CoverageByTag)element$iv;
            boolean bl = false;
            completeCoverage.add(newCoverage);
        }
        return completeCoverage;
    }

    private final boolean coverageNotIncludedIn(CoverageByTag newCoverage, List<CoverageByTag> completeCoverage) {
        int n;
        Iterable $this$count$iv = completeCoverage;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CoverageByTag coverage = (CoverageByTag)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)coverage.getTagName(), (Object)newCoverage.getTagName())) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n == 0;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CoverageByTag> uncoveredTags(Collection<? extends TestTag> tagsToDisplay, List<CoverageByTag> coverageFromTestOutcomes) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = tagsToDisplay;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TestTag tag = (TestTag)element$iv$iv;
            boolean bl = false;
            if (!this.noCoverageFor(tag, coverageFromTestOutcomes)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List uncoveredTags = (List)destination$iv$iv;
        Iterable $this$map$iv = uncoveredTags;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tag;
            TestTag bl = (TestTag)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            CoverageByTag coverageByTag = this.coverageFor((TestTag)tag);
            collection.add(coverageByTag);
        }
        List zeroCoverageForUncoveredTags = (List)destination$iv$iv2;
        return zeroCoverageForUncoveredTags;
    }

    private final boolean noCoverageFor(TestTag tag, List<CoverageByTag> coverageFromTestOutcomes) {
        int n;
        Iterable $this$count$iv = coverageFromTestOutcomes;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                CoverageByTag coverage = (CoverageByTag)element$iv;
                boolean bl = false;
                if (!StringUtils.equalsIgnoreCase((CharSequence)coverage.getTagName(), (CharSequence)tag.getName())) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n == 0;
    }

    private final CoverageByTag coverageFor(TestTag testTag) {
        TestOutcomes testOutcomesForTag;
        TestOutcomes testOutcomes = testOutcomesForTag = this.testOutcomes.withTag(testTag);
        Intrinsics.checkNotNullExpressionValue((Object)testOutcomes, (String)"testOutcomesForTag");
        String successRate = testOutcomes.getFormattedPercentage().withResult(TestResult.SUCCESS, 0);
        String string = testTag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"testTag.name");
        String string2 = NameConverter.humanize((String)this.shortened(string));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"humanize(shortened(testTag.name))");
        int n = testOutcomesForTag.getTestCount();
        String string3 = successRate;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"successRate");
        TestResult testResult = testOutcomesForTag.getResult();
        Intrinsics.checkNotNullExpressionValue((Object)testResult, (String)"testOutcomesForTag.result");
        String string4 = new ReportNameProvider().forTag(testTag);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"ReportNameProvider().forTag(testTag)");
        return new CoverageByTag(string2, n, string3, testResult, string4, ResultsCountKt.countByResultLabelFrom(testOutcomesForTag), ResultsCountKt.percentageByResultFrom(testOutcomesForTag));
    }

    private final String shortened(String name) {
        return StringsKt.substringAfterLast$default((String)name, (String)"/", null, (int)2, null);
    }

    @NotNull
    public final String getTagType() {
        return this.tagType;
    }

    @NotNull
    public final String getTagTitle() {
        return this.tagTitle;
    }

    @NotNull
    public final TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public CoverageByTagType(@NotNull String tagType, @NotNull String tagTitle, @NotNull TestOutcomes testOutcomes, @NotNull Collection<? extends TestTag> tagsToDisplay) {
        Intrinsics.checkNotNullParameter((Object)tagType, (String)"tagType");
        Intrinsics.checkNotNullParameter((Object)tagTitle, (String)"tagTitle");
        Intrinsics.checkNotNullParameter((Object)testOutcomes, (String)"testOutcomes");
        Intrinsics.checkNotNullParameter(tagsToDisplay, (String)"tagsToDisplay");
        this.tagType = tagType;
        this.tagTitle = tagTitle;
        this.testOutcomes = testOutcomes;
        this.tagCoverage = this.coverageForEachTagOfType(this.tagType, this.testOutcomes, tagsToDisplay);
    }
}

