/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.junit.spring.integration;

import java.lang.reflect.Method;
import net.serenitybdd.junit.spring.integration.SpringIntegrationRuleBase;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.junit4.statements.RunAfterTestMethodCallbacks;
import org.springframework.test.context.junit4.statements.RunBeforeTestMethodCallbacks;

public class SpringIntegrationMethodRule
extends SpringIntegrationRuleBase
implements MethodRule {
    private static final Logger LOG = LoggerFactory.getLogger(SpringIntegrationMethodRule.class);

    public Statement apply(Statement base, FrameworkMethod frameworkMethod, Object target) {
        Method testMethod = frameworkMethod.getMethod();
        Class<?> testClass = testMethod.getDeclaringClass();
        LOG.debug("Applying method rule to method {} of class {}", (Object)testMethod.getName(), (Object)testClass.getName());
        return super.apply(base, testClass, target, (next, testContextManager) -> new RunBeforeTestMethodCallbacks(next, target, testMethod, testContextManager), (next, testContextManager) -> new RunAfterTestMethodCallbacks(next, target, testMethod, testContextManager));
    }
}

