/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Complaint;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.RecordsInputs;
import net.thucydides.core.steps.StepEventBus;

public abstract class BaseConsequence<T>
implements Consequence<T> {
    private Class<? extends Error> complaintType;
    private String complaintDetails;
    protected Optional<String> explanation = Optional.empty();
    protected Optional<String> subjectText = Optional.empty();
    private List<Performable> setupActions = new ArrayList<Performable>();

    protected Error errorFrom(Throwable actualError) {
        if (actualError instanceof AssertionError) {
            return null;
        }
        if (actualError instanceof Error) {
            return (Error)actualError;
        }
        return null;
    }

    protected void throwComplaintTypeErrorIfSpecified(Throwable actualError) {
        if (this.complaintType != null) {
            throw Complaint.from(this.complaintType, this.complaintDetails, actualError);
        }
    }

    protected boolean thisStepShouldBeIgnored() {
        return StepEventBus.getParallelEventBus().currentTestIsSuspended() || StepEventBus.getParallelEventBus().aStepInTheCurrentTestHasFailed();
    }

    @Override
    public BaseConsequence<T> orComplainWith(Class<? extends Error> complaintType) {
        return this.orComplainWith((Class)complaintType, (String)null);
    }

    @Override
    public BaseConsequence<T> orComplainWith(Class<? extends Error> complaintType, String complaintDetails) {
        this.complaintType = complaintType;
        this.complaintDetails = complaintDetails;
        return this;
    }

    @Override
    public Consequence<T> whenAttemptingTo(Performable performable) {
        this.setupActions.add(performable);
        return this;
    }

    @Override
    public Consequence<T> because(String explanation) {
        this.explanation = Optional.ofNullable(explanation);
        return this;
    }

    protected String inputValues() {
        return this.setupActions.stream().filter(action -> action instanceof RecordsInputs).map(action -> (RecordsInputs)((Object)action)).map(RecordsInputs::getInputValues).collect(Collectors.joining(","));
    }

    protected String addRecordedInputValuesTo(String message) {
        if (this.inputValues().isEmpty()) {
            return message;
        }
        return message + " [" + this.inputValues() + "]";
    }

    @Override
    public Consequence<T> after(Performable ... actions) {
        this.setupActions.addAll(Arrays.asList(actions));
        return this;
    }

    protected void performSetupActionsAs(Actor actor) {
        actor.attemptsTo(Actor.ErrorHandlingMode.IGNORE_EXCEPTIONS, this.setupActions.toArray(new Performable[0]));
    }
}

