/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.function.Consumer;
import net.serenitybdd.annotations.Step;
import net.serenitybdd.markers.CanBeSilent;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Performable;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.model.steps.ExecutedStepDescription;
import net.thucydides.model.steps.StepFailure;

public class AnonymousPerformableFunction
implements Performable,
CanBeSilent {
    private final String title;
    private final Consumer<Actor> actions;
    private boolean isSilent = false;

    public AnonymousPerformableFunction(String title, Consumer<Actor> actions) {
        this.title = title;
        this.actions = actions;
    }

    @Override
    @Step(value="!#title")
    public <T extends Actor> void performAs(T actor) {
        try {
            this.actions.accept(actor);
        }
        catch (Throwable e) {
            StepEventBus.getParallelEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)e.getMessage()), e));
            throw e;
        }
    }

    public boolean isSilent() {
        return this.isSilent;
    }

    public AnonymousPerformableFunction withNoReporting() {
        this.isSilent = true;
        return this;
    }
}

