/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.annotations;

import java.lang.reflect.Field;
import java.util.Set;
import net.serenitybdd.annotations.Fields;
import net.serenitybdd.screenplay.Uninstrumented;
import org.apache.commons.lang3.StringUtils;

public class AnnotatedTitle {
    private final String text;

    public static AnnotatedTitle injectFieldsInto(String text) {
        return new AnnotatedTitle(text);
    }

    private AnnotatedTitle(String text) {
        this.text = text;
    }

    public String using(Object question) {
        Set fields = Fields.of(Uninstrumented.versionOf(question.getClass())).allFields();
        String updatedText = this.text;
        for (Field field : fields) {
            String fieldName = this.fieldVariableFor(field.getName());
            Object value = this.getValueFrom(question, field);
            if (!updatedText.contains(fieldName) || value == null) continue;
            updatedText = StringUtils.replace((String)updatedText, (String)fieldName, (String)value.toString());
        }
        return updatedText;
    }

    private Object getValueFrom(Object question, Field field) {
        try {
            field.setAccessible(true);
            return field.get(question);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new AssertionError((Object)("Question label cound not be instantiated for " + this.text));
        }
    }

    private String fieldVariableFor(String field) {
        return "#" + field;
    }
}

