/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.EventBusInterface;
import net.serenitybdd.screenplay.FailedConsequence;

class ErrorTally {
    private final EventBusInterface eventBusInterface;
    private final List<FailedConsequence> errors;

    ErrorTally(EventBusInterface eventBusInterface) {
        this.eventBusInterface = eventBusInterface;
        this.errors = new ArrayList<FailedConsequence>();
    }

    void recordError(Consequence<?> consequence, Throwable cause) {
        this.errors.add(new FailedConsequence(consequence, cause));
        this.eventBusInterface.reportStepFailureFor(consequence, cause);
    }

    void reportAnyErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        if (Serenity.shouldThrowErrorsImmediately()) {
            this.throwSummaryExceptionFrom(this.errorCausesIn(this.errors));
        }
    }

    private void throwSummaryExceptionFrom(List<Throwable> errorCauses) {
        String overallErrorMessage = String.join((CharSequence)System.lineSeparator(), this.errorMessagesIn(errorCauses));
        throw new AssertionError((Object)overallErrorMessage);
    }

    private List<Throwable> errorCausesIn(List<FailedConsequence> failedConsequences) {
        return failedConsequences.stream().map(FailedConsequence::getCause).collect(Collectors.toList());
    }

    private List<String> errorMessagesIn(List<Throwable> errorCauses) {
        return errorCauses.stream().map(Throwable::getMessage).collect(Collectors.toList());
    }
}

