/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.Optional;
import java.util.function.Predicate;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.eventbus.Broadcaster;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.BaseConsequence;
import net.serenitybdd.screenplay.Complaint;
import net.serenitybdd.screenplay.Performable;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.QuestionDiagnostics;
import net.serenitybdd.screenplay.QuestionSubject;
import net.serenitybdd.screenplay.conditions.SilentPerformable;
import net.serenitybdd.screenplay.events.ActorAsksQuestion;
import net.serenitybdd.screenplay.formatting.StripRedundantTerms;
import net.thucydides.core.steps.StepEventBus;
import org.junit.Assert;

public class PredicateConsequence<T>
extends BaseConsequence<T> {
    protected final Question<T> question;
    protected final Predicate<T> expected;
    protected final String subject;
    private static final SilentPerformable DO_NOTHING = new SilentPerformable();

    public PredicateConsequence(Question<T> actual, Predicate<T> expected) {
        this(null, actual, expected);
    }

    public PredicateConsequence(String subjectText, Question<T> actual, Predicate<T> expected) {
        this.question = actual;
        this.expected = expected;
        this.subject = QuestionSubject.fromClass(actual.getClass()).andQuestion(actual).subject();
        this.subjectText = Optional.ofNullable(subjectText);
    }

    @Override
    public void evaluateFor(Actor actor) {
        if (this.thisStepShouldBeIgnored() && !StepEventBus.getEventBus().softAssertsActive()) {
            return;
        }
        Broadcaster.getEventBus().post((Object)new ActorAsksQuestion(this.question, actor.getName()));
        Serenity.injectScenarioStepsInto(this.question);
        try {
            ((Performable)this.optionalPrecondition.orElse(DO_NOTHING)).performAs(actor);
            Assert.assertTrue((String)"predicate failed", (boolean)this.expected.test(this.question.answeredBy(actor)));
        }
        catch (Throwable actualError) {
            this.throwComplaintTypeErrorIfSpecified(this.errorFrom(actualError));
            this.throwDiagosticErrorIfProvided(this.errorFrom(actualError));
            throw actualError;
        }
    }

    private void throwDiagosticErrorIfProvided(Error actualError) {
        if (this.question instanceof QuestionDiagnostics) {
            throw Complaint.from(((QuestionDiagnostics)((Object)this.question)).onError(), actualError);
        }
    }

    public String toString() {
        String template = this.explanation.orElse("Then %s should be %s");
        String expectedExpression = StripRedundantTerms.from(this.expected.toString());
        return this.addRecordedInputValuesTo(String.format(template, this.subjectText.orElse(this.subject), expectedExpression));
    }
}

