/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.ui;

import net.serenitybdd.screenplay.targets.SearchableTarget;
import net.serenitybdd.screenplay.targets.Target;
import net.serenitybdd.screenplay.ui.CSSAttributeValue;
import net.serenitybdd.screenplay.ui.TargetFactory;
import org.openqa.selenium.By;

public class Image {
    public static SearchableTarget withAltText(String altText) {
        String altTextAttribute = CSSAttributeValue.withEscapedQuotes(altText);
        return Target.the("'" + altTextAttribute + "' image").located(By.cssSelector((String)("img[alt='" + altTextAttribute + "']")));
    }

    public static SearchableTarget withSrc(String srcValue) {
        String srcAttribute = CSSAttributeValue.withEscapedQuotes(srcValue);
        return Target.the("'" + srcValue + "' image").located(By.cssSelector((String)("img[src='" + srcAttribute + "']")));
    }

    public static SearchableTarget withSrcEndingWith(String srcValue) {
        String srcAttribute = CSSAttributeValue.withEscapedQuotes(srcValue);
        return Target.the("'" + srcValue + "' image").located(By.cssSelector((String)("img[src$='" + srcAttribute + "']")));
    }

    public static SearchableTarget withSrcStartingWith(String srcValue) {
        String srcAttribute = CSSAttributeValue.withEscapedQuotes(srcValue);
        return Target.the("'" + srcValue + "' image").located(By.cssSelector((String)("img[src^='" + srcAttribute + "']")));
    }

    public static SearchableTarget locatedBy(String selector) {
        return TargetFactory.forElementOfType("image").locatedByXPathOrCss(selector);
    }

    public static SearchableTarget located(By selector) {
        return TargetFactory.forElementOfType("image").locatedBy(selector);
    }
}

