/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.EnumValues;
import net.serenitybdd.screenplay.questions.converters.converters.BigDecimalConverter;
import net.serenitybdd.screenplay.questions.converters.converters.BooleanConverter;
import net.serenitybdd.screenplay.questions.converters.converters.Converter;
import net.serenitybdd.screenplay.questions.converters.converters.DateTimeConverter;
import net.serenitybdd.screenplay.questions.converters.converters.DoubleConverter;
import net.serenitybdd.screenplay.questions.converters.converters.FloatConverter;
import net.serenitybdd.screenplay.questions.converters.converters.IntegerConverter;
import net.serenitybdd.screenplay.questions.converters.converters.LongConverter;
import net.serenitybdd.screenplay.questions.converters.converters.StringConverter;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class UIState<T> {
    protected final Actor actor;
    protected Map<Class<?>, Converter<?>> DEFAULT_CONVERTERS = new HashMap();

    protected UIState(Actor actor) {
        this.DEFAULT_CONVERTERS.put(String.class, (Converter<?>)new StringConverter());
        this.DEFAULT_CONVERTERS.put(Boolean.class, (Converter<?>)new BooleanConverter());
        this.DEFAULT_CONVERTERS.put(DateTime.class, (Converter<?>)new DateTimeConverter());
        this.DEFAULT_CONVERTERS.put(Float.class, (Converter<?>)new FloatConverter());
        this.DEFAULT_CONVERTERS.put(Double.class, (Converter<?>)new DoubleConverter());
        this.DEFAULT_CONVERTERS.put(Integer.class, (Converter<?>)new IntegerConverter());
        this.DEFAULT_CONVERTERS.put(Long.class, (Converter<?>)new LongConverter());
        this.DEFAULT_CONVERTERS.put(BigDecimal.class, (Converter<?>)new BigDecimalConverter());
        this.actor = actor;
    }

    public abstract T resolve();

    public T value() {
        return this.resolve();
    }

    public <TARGET> TARGET as(Class<TARGET> type) {
        return (TARGET)this.converterFor(type).convert(this.resolve());
    }

    public String asString() {
        return this.as(String.class);
    }

    public Integer asInteger() {
        return this.as(Integer.class);
    }

    public Double asDouble() {
        return this.as(Double.class);
    }

    public Float asFloat() {
        return this.as(Float.class);
    }

    public Long asLong() {
        return this.as(Long.class);
    }

    public Boolean asBoolean() {
        return this.as(Boolean.class);
    }

    public DateTime asDate() {
        return this.as(DateTime.class);
    }

    public LocalDate asLocalDate() {
        return this.as(LocalDate.class);
    }

    public BigDecimal asBigDecimal() {
        return this.as(BigDecimal.class);
    }

    public LocalDate asLocalDate(String format) {
        return LocalDate.parse(this.resolve().toString(), java.time.format.DateTimeFormatter.ofPattern(format));
    }

    public DateTime asDate(String format) {
        return DateTime.parse((String)this.resolve().toString(), (DateTimeFormatter)DateTimeFormat.forPattern((String)format));
    }

    public <C> C asEnum(Class<C> enumType) {
        String value = this.resolve().toString();
        return (C)EnumValues.forType(enumType).getValueOf(value);
    }

    protected <C> List<C> convertToEnums(Class<C> enumType, List<?> values) {
        return EnumValues.forType(enumType).getValuesOf(values);
    }

    protected Converter<?> converterFor(Class<?> type) {
        Preconditions.checkState((boolean)this.DEFAULT_CONVERTERS.containsKey(type), (Object)("No converter found for " + String.valueOf(type)));
        return this.DEFAULT_CONVERTERS.get(type);
    }
}

