/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.questions.targets;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.annotations.Subject;
import net.serenitybdd.screenplay.questions.Attribute;
import net.serenitybdd.screenplay.targets.Target;

@Subject(value="#target")
public class TargetTextValues
implements Question<Collection<String>> {
    private final Target target;
    private final Function<String, String> renderElement;
    private static Function<String, String> NO_CHANGE = value -> value;
    private static Function<String, String> TRIM_WHITESPACE = String::trim;

    TargetTextValues(Target target) {
        this(target, NO_CHANGE);
    }

    private TargetTextValues(Target target, Function<String, String> renderElement) {
        this.target = target;
        this.renderElement = renderElement;
    }

    public TargetTextValues withNoSurroundingWhiteSpace() {
        return new TargetTextValues(this.target, TRIM_WHITESPACE);
    }

    public Collection<String> answeredBy(Actor actor) {
        Collection textValues = (Collection)Attribute.ofEach(this.target).named("innerText").answeredBy(actor);
        return textValues.stream().map(this.renderElement).collect(Collectors.toList());
    }
}

