/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.decorators.request;

import com.google.common.base.Preconditions;
import io.restassured.http.ContentType;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.internal.MapCreator;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.RequestSpecification;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.rest.HeaderNames;
import net.serenitybdd.rest.decorators.request.RequestSpecificationMultiPartConfigurations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RequestSpecificationHeaderConfigurations
extends RequestSpecificationMultiPartConfigurations
implements FilterableRequestSpecification {
    private static final Logger log = LoggerFactory.getLogger(RequestSpecificationHeaderConfigurations.class);

    public RequestSpecificationHeaderConfigurations(RequestSpecificationImpl core) {
        super(core);
    }

    public Headers getHeaders() {
        return this.core.getHeaders();
    }

    public RequestSpecification headers(Map<String, ?> headers) {
        this.core.headers(headers);
        return this;
    }

    public RequestSpecification headers(String firstHeaderName, Object firstHeaderValue, Object ... headerNameValuePairs) {
        return this.headers(MapCreator.createMapFromParams((MapCreator.CollisionStrategy)MapCreator.CollisionStrategy.OVERWRITE, (String)firstHeaderName, (Object)firstHeaderValue, (Object[])headerNameValuePairs));
    }

    public RequestSpecification headers(Headers headers) {
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        HashMap<String, String> converted = new HashMap<String, String>();
        if (headers.exist()) {
            for (Header header : headers.asList()) {
                converted.put(header.getName(), header.getValue());
            }
        }
        return this.headers(converted);
    }

    public RequestSpecification header(String headerName, Object headerValue, Object ... additionalHeaderValues) {
        Preconditions.checkNotNull((Object)headerName, (Object)"Header name");
        Preconditions.checkNotNull((Object)headerValue, (Object)"Header value");
        HashMap<String, Object> prepared = new HashMap<String, Object>();
        prepared.put(headerName, headerValue);
        for (Object value : additionalHeaderValues) {
            prepared.put(headerName, value);
        }
        return this.headers(prepared);
    }

    public RequestSpecification header(Header header) {
        HashMap<String, String> prepared = new HashMap<String, String>();
        prepared.put(header.getName(), header.getValue());
        return this.headers(prepared);
    }

    public RequestSpecification accept(ContentType contentType) {
        Preconditions.checkNotNull((Object)contentType, (Object)"Accept header");
        return this.accept(contentType.getAcceptHeader());
    }

    public RequestSpecification accept(String mediaTypes) {
        Preconditions.checkNotNull((Object)mediaTypes, (Object)"Accept header media range");
        return this.header(HeaderNames.ACCEPT.asString(), mediaTypes, new Object[0]);
    }
}

