/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.utils;

import io.restassured.filter.log.LogDetail;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.internal.ResponseSpecificationImpl;
import io.restassured.internal.filter.SendRequestFilter;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import io.restassured.specification.RequestSenderOptions;
import io.restassured.specification.RequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.LinkedList;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.serenitybdd.rest.SerenityRest;
import net.serenitybdd.rest.decorators.ResponseSpecificationDecorated;
import net.serenitybdd.rest.decorators.request.RequestSpecificationDecorated;
import net.serenitybdd.rest.filters.FieldsRecordingFilter;
import net.serenitybdd.rest.filters.UpdatingContextFilter;
import net.serenitybdd.rest.utils.RequestSpecificationDecoratedFactory;
import net.serenitybdd.rest.utils.ResponseSpecificationDecoratedFactory;
import net.serenitybdd.rest.utils.RestExecutionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSpecificationFactory {
    private static final Logger log = LoggerFactory.getLogger(RestSpecificationFactory.class);
    private static RequestSpecificationDecoratedFactory requestSpecificationDecoratedFactory;
    private static ResponseSpecificationDecoratedFactory responseSpecificationDecoratedFactory;

    public static RequestSpecificationDecorated getInstrumentedRequestSpecification(RequestSpecificationImpl delegate) {
        RequestSpecificationDecorated instrumentedResponse = requestSpecificationDecoratedFactory.create(delegate);
        LinkedList<Object> filters = new LinkedList<Object>();
        for (LogDetail logDetail : Arrays.asList(LogDetail.HEADERS, LogDetail.COOKIES, LogDetail.BODY, LogDetail.PARAMS, LogDetail.METHOD, LogDetail.URI)) {
            filters.add(new FieldsRecordingFilter(true, logDetail));
        }
        if (RestExecutionHelper.restCallsAreDisabled()) {
            filters.add(new UpdatingContextFilter(SendRequestFilter.class));
        }
        instrumentedResponse.filters(filters);
        return instrumentedResponse;
    }

    public static ResponseSpecificationDecorated getInstrumentedResponseSpecification(ResponseSpecificationImpl delegate) {
        ResponseSpecificationDecorated responseSpecificationDecorated = responseSpecificationDecoratedFactory.create(delegate);
        return responseSpecificationDecorated;
    }

    static {
        ByteBuddy byteBuddy = new ByteBuddy();
        Class requestSpecificationDecoratedClass = byteBuddy.subclass(RequestSpecificationDecorated.class).method((ElementMatcher)ElementMatchers.isDeclaredBy(RequestSpecification.class).or((ElementMatcher)ElementMatchers.isDeclaredBy(RequestSenderOptions.class)).or((ElementMatcher)ElementMatchers.isDeclaredBy(FilterableRequestSpecification.class))).intercept((Implementation)MethodDelegation.toField((String)"core")).make().load(SerenityRest.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
        Class responseSpecificationDecoratedClass = byteBuddy.subclass(ResponseSpecificationDecorated.class).method((ElementMatcher)ElementMatchers.isDeclaredBy(ResponseSpecification.class).or((ElementMatcher)ElementMatchers.isDeclaredBy(RequestSenderOptions.class)).or((ElementMatcher)ElementMatchers.isDeclaredBy(FilterableResponseSpecification.class))).intercept((Implementation)MethodDelegation.toField((String)"core")).make().load(SerenityRest.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded();
        try {
            Constructor requestSpecificationDecoratedConstructor = requestSpecificationDecoratedClass.getConstructor(RequestSpecificationImpl.class);
            Constructor responseSpecificationDecoratedConstructor = responseSpecificationDecoratedClass.getConstructor(ResponseSpecificationImpl.class);
            requestSpecificationDecoratedFactory = (RequestSpecificationDecoratedFactory)byteBuddy.subclass(RequestSpecificationDecoratedFactory.class).method((ElementMatcher)ElementMatchers.isDeclaredBy(RequestSpecificationDecoratedFactory.class)).intercept((Implementation)MethodCall.construct(requestSpecificationDecoratedConstructor).withArgument(new int[]{0})).make().load(requestSpecificationDecoratedClass.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().newInstance();
            responseSpecificationDecoratedFactory = (ResponseSpecificationDecoratedFactory)byteBuddy.subclass(ResponseSpecificationDecoratedFactory.class).method((ElementMatcher)ElementMatchers.isDeclaredBy(ResponseSpecificationDecoratedFactory.class)).intercept((Implementation)MethodCall.construct(responseSpecificationDecoratedConstructor).withArgument(new int[]{0})).make().load(responseSpecificationDecoratedClass.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.INJECTION).getLoaded().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Cannot create responseSpecificationDecoratedFactory ", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.error("Constructor not found", (Throwable)e);
        }
    }
}

