/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.ArrayList;
import java.util.Arrays;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.requirements.reports.RequirementsOutcomes;

public class RequirementCounts {
    private final RequirementsOutcomes outcomes;

    public RequirementCounts(RequirementsOutcomes outcomes) {
        this.outcomes = outcomes;
    }

    public static RequirementCounts forOutcomesIn(RequirementsOutcomes outcomes) {
        return new RequirementCounts(outcomes);
    }

    public String byType() {
        ArrayList<Integer> results = new ArrayList<Integer>();
        results.add(this.outcomes.getCompletedRequirementsCount());
        results.add(this.outcomes.getPendingRequirementsCount());
        results.add(this.outcomes.getIgnoredRequirementsCount());
        results.add(this.outcomes.getSkippedRequirementsCount());
        results.add(this.outcomes.getFailingRequirementsCount());
        results.add(this.outcomes.getErrorRequirementsCount());
        results.add(this.outcomes.getCompromisedRequirementsCount());
        return Arrays.toString(results.toArray());
    }

    public String percentageLabelsByType() {
        ArrayList<String> resultLabels = new ArrayList<String>();
        resultLabels.add(this.ifNotEmpty(this.outcomes.getFormattedPercentage().withResult(TestResult.SUCCESS)));
        resultLabels.add(this.ifNotEmpty(this.outcomes.getFormattedPercentage().withResult(TestResult.PENDING)));
        resultLabels.add(this.ifNotEmpty(this.outcomes.getFormattedPercentage().withResult(TestResult.IGNORED)));
        resultLabels.add(this.ifNotEmpty(this.outcomes.getFormattedPercentage().withResult(TestResult.SKIPPED)));
        resultLabels.add(this.ifNotEmpty(this.outcomes.getFormattedPercentage().withResult(TestResult.FAILURE)));
        resultLabels.add(this.ifNotEmpty(this.outcomes.getFormattedPercentage().withResult(TestResult.ERROR)));
        resultLabels.add(this.ifNotEmpty(this.outcomes.getFormattedPercentage().withResult(TestResult.COMPROMISED)));
        return Arrays.toString(resultLabels.toArray());
    }

    private String ifNotEmpty(String result) {
        return result.equals("0.0%") ? " " : "'" + result + "'";
    }
}

