/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.annotations.TestAnnotations;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.serenitybdd.model.exceptions.SerenityManagedException;
import net.serenitybdd.model.exceptions.TheErrorType;
import net.serenitybdd.model.model.FailureDetails;
import net.serenitybdd.model.strings.Joiner;
import net.serenitybdd.model.time.SystemClock;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.CastMember;
import net.thucydides.model.domain.DataTable;
import net.thucydides.model.domain.DataTableRow;
import net.thucydides.model.domain.ExternalLink;
import net.thucydides.model.domain.FeatureTagAsDefined;
import net.thucydides.model.domain.HeuristicTestResult;
import net.thucydides.model.domain.ManualTestEvidence;
import net.thucydides.model.domain.MultipleAssertionErrors;
import net.thucydides.model.domain.PackageBasedLeafRequirements;
import net.thucydides.model.domain.ReportData;
import net.thucydides.model.domain.ReportNamer;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.domain.Rule;
import net.thucydides.model.domain.Story;
import net.thucydides.model.domain.TestCaseOrder;
import net.thucydides.model.domain.TestDuration;
import net.thucydides.model.domain.TestOutcomeAnnotationReader;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestResultComparison;
import net.thucydides.model.domain.TestResultList;
import net.thucydides.model.domain.TestStep;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.domain.TestTags;
import net.thucydides.model.domain.TestType;
import net.thucydides.model.domain.TitleBuilder;
import net.thucydides.model.domain.failures.FailureAnalysis;
import net.thucydides.model.domain.features.ApplicationFeature;
import net.thucydides.model.domain.flags.Flag;
import net.thucydides.model.domain.flags.FlagProvider;
import net.thucydides.model.domain.formatters.ReportFormatter;
import net.thucydides.model.domain.results.MergeStepResultStrategy;
import net.thucydides.model.domain.results.StepResultMergeStragegy;
import net.thucydides.model.domain.screenshots.Screenshot;
import net.thucydides.model.domain.stacktrace.FailureCause;
import net.thucydides.model.domain.stacktrace.RootCauseAnalyzer;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.issues.IssueKeyFormat;
import net.thucydides.model.issues.IssueTracking;
import net.thucydides.model.reports.json.JSONConverter;
import net.thucydides.model.reports.remoteTesting.LinkGenerator;
import net.thucydides.model.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.model.statistics.service.TagProvider;
import net.thucydides.model.statistics.service.TagProviderService;
import net.thucydides.model.steps.StepFailure;
import net.thucydides.model.steps.StepFailureException;
import net.thucydides.model.steps.TestFailureCause;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.util.NameConverter;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestOutcome {
    private static final String ISSUES = "issues";
    private static final String NEW_LINE = System.getProperty("line.separator");
    private String name;
    private String id;
    private String scenarioId;
    private transient Class<?> testCase;
    private String testCaseName;
    private String methodName;
    private List<TestStep> testSteps = Collections.synchronizedList(new ArrayList());
    private Story userStory;
    private Optional<TestTag> featureTag = Optional.empty();
    private String title;
    private String description;
    private String backgroundTitle;
    private String backgroundDescription;
    private List<String> coreIssues;
    private final List<String> additionalIssues;
    private List<String> coreVersions;
    private List<String> additionalVersions;
    private Set<TestTag> tags;
    private transient Set<TestTag> allTags;
    private ZonedDateTime startTime;
    private ZonedDateTime endTime;
    private long duration;
    private ZonedDateTime testRunTimestamp;
    private String project;
    private Rule rule;
    private FailureCause testFailureCause;
    private TestFailureCause flakyTestFailureCause;
    private String testFailureClassname;
    private String testFailureMessage;
    private String testFailureSummary;
    private String projectKey;
    private TestResult annotatedResult = null;
    private String sessionId;
    private String driver;
    private String lastTested;
    private boolean isManualTestingUpToDate;
    private List<String> manualTestEvidence;
    private transient Stack<TestStep> groupStack = new Stack();
    private transient IssueTracking issueTracking;
    private transient EnvironmentVariables environmentVariables;
    private final transient LinkGenerator linkGenerator;
    private transient FlagProvider flagProvider;
    private transient TagProviderService tagProviderService;
    private Optional<String> qualifier;
    private String context;
    private DataTable dataTable;
    private boolean manual;
    private Set<? extends Flag> flags;
    private String testSource;
    private final List<CastMember> actors;
    private ExternalLink externalLink;
    private Integer order;
    TestResult result;
    List<String> issues;
    List<String> versions;
    private transient List<TestStep> flattenedSteps = null;
    private transient List<TestStep> leafSteps = null;
    private String scenarioOutline;
    private String testOutlineName;
    private String testData;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestOutcome.class);
    private Double durationInSeconds;
    private static final List<String> NO_HEADERS = new ArrayList<String>();

    private TestOutcome() {
        this.groupStack = new Stack();
        this.additionalIssues = new ArrayList<String>();
        this.additionalVersions = new ArrayList<String>();
        this.actors = new CopyOnWriteArrayList<CastMember>();
        this.issueTracking = ModelInfrastructure.getIssueTracking();
        this.linkGenerator = ModelInfrastructure.getLinkGenerator();
        this.flagProvider = ModelInfrastructure.getFlagProvider();
        this.qualifier = Optional.empty();
        this.context = null;
        this.groupStack = new Stack();
    }

    public TestOutcome(String name) {
        this(name, null);
    }

    public TestOutcome(String name, Class<?> testCase) {
        this(name, testCase, ConfiguredEnvironment.getEnvironmentVariables());
    }

    private static String identifierFrom(String testName, Class<?> testCase, Story userStory) {
        String identifer = null;
        if (testCase != null) {
            identifer = testCase.getName().replaceAll("\\$", ".");
        }
        if (userStory != null) {
            identifer = userStory.getId();
        }
        return (String)(identifer != null ? identifer + ":" : "") + testName;
    }

    public TestOutcome(String name, Class<?> testCase, EnvironmentVariables environmentVariables) {
        this.startTime = ZonedDateTime.now();
        this.name = name;
        this.scenarioId = this.id = TestOutcome.identifierFrom(name, testCase, this.userStory);
        this.testCase = testCase;
        this.testCaseName = this.nameOf(testCase);
        this.methodName = name;
        this.additionalIssues = new ArrayList<String>();
        this.additionalVersions = new ArrayList<String>();
        this.actors = new ArrayList<CastMember>();
        this.issueTracking = ModelInfrastructure.getIssueTracking();
        this.linkGenerator = ModelInfrastructure.getLinkGenerator();
        this.flagProvider = ModelInfrastructure.getFlagProvider();
        this.qualifier = Optional.empty();
        this.environmentVariables = environmentVariables;
        this.context = null;
        if (this.userStory == null && testCase != null) {
            this.setUserStory(this.leafRequirementDefinedIn().testCase(testCase));
        }
    }

    public TestOutcome(String name, Class<?> testCase, String context, EnvironmentVariables environmentVariables) {
        this.startTime = ZonedDateTime.now();
        this.name = name;
        this.scenarioId = this.id = TestOutcome.identifierFrom(name, testCase, this.userStory);
        this.testCase = testCase;
        this.methodName = name;
        this.testCaseName = this.nameOf(testCase);
        this.additionalIssues = new ArrayList<String>();
        this.additionalVersions = new ArrayList<String>();
        this.actors = new ArrayList<CastMember>();
        this.issueTracking = ModelInfrastructure.getIssueTracking();
        this.linkGenerator = ModelInfrastructure.getLinkGenerator();
        this.flagProvider = ModelInfrastructure.getFlagProvider();
        this.qualifier = Optional.empty();
        this.environmentVariables = environmentVariables;
        this.context = context;
        if (testCase != null) {
            this.setUserStory(this.leafRequirementDefinedIn().testCase(testCase));
        }
    }

    private String contextFrom(EnvironmentVariables environmentVariables) {
        return environmentVariables == null ? null : ThucydidesSystemProperty.CONTEXT.from(environmentVariables);
    }

    public static TestOutcomeWithEnvironmentBuilder inEnvironment(EnvironmentVariables environmentVariables) {
        return new TestOutcomeWithEnvironmentBuilder(environmentVariables);
    }

    private PackageBasedLeafRequirements leafRequirementDefinedIn() {
        return new PackageBasedLeafRequirements(this.getEnvironmentVariables());
    }

    public void calculateDynamicFieldValues() {
        this.getTitle();
        this.result = this.getResult();
        this.issues = this.getIssues();
        this.versions = this.getVersions();
        this.tags = this.getTags();
    }

    private String nameOf(Class<?> testCase) {
        if (testCase != null) {
            return testCase.getCanonicalName();
        }
        return null;
    }

    private TagProviderService getTagProviderService() {
        if (this.tagProviderService == null) {
            this.tagProviderService = ModelInfrastructure.getTagProviderService();
        }
        return this.tagProviderService;
    }

    public TestOutcome usingIssueTracking(IssueTracking issueTracking) {
        this.issueTracking = issueTracking;
        return this;
    }

    public TestOutcome setToManual() {
        this.manual = true;
        this.addTag(TestTag.withName("manual").andType("tag"));
        return this;
    }

    public TestOutcome withTestSource(String testSource) {
        this.testSource = testSource;
        return this;
    }

    protected TestOutcome withFlagProvider(FlagProvider flagProvider) {
        this.flagProvider = flagProvider;
        this.flags = null;
        return this;
    }

    public void setEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.context = this.contextFrom(environmentVariables);
    }

    public EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
            if (this.context == null) {
                this.context = this.contextFrom(this.environmentVariables);
            }
        }
        return this.environmentVariables;
    }

    protected TestOutcome(String name, Class<?> testCase, Story userStory) {
        this(name, testCase, userStory, ConfiguredEnvironment.getEnvironmentVariables());
    }

    protected TestOutcome(String name, Class<?> testCase, Story userStory, EnvironmentVariables environmentVariables) {
        this.startTime = ZonedDateTime.now();
        this.name = name;
        this.scenarioId = this.id = TestOutcome.identifierFrom(name, testCase, userStory);
        this.testCase = testCase;
        this.methodName = name;
        this.testCaseName = this.nameOf(testCase);
        this.additionalIssues = new ArrayList<String>();
        this.additionalVersions = new ArrayList<String>();
        this.actors = new ArrayList<CastMember>();
        if (userStory != null) {
            this.setUserStory(userStory);
        } else if (testCase != null && this.storyDefinedIn(testCase).isPresent()) {
            this.setUserStory(this.storyDefinedIn(testCase).get());
        }
        this.issueTracking = ModelInfrastructure.getIssueTracking();
        this.linkGenerator = ModelInfrastructure.getLinkGenerator();
        this.flagProvider = ModelInfrastructure.getFlagProvider();
        this.environmentVariables = environmentVariables;
        this.context = this.contextFrom(environmentVariables);
        this.order = TestCaseOrder.definedIn(testCase, name);
        this.projectKey = ThucydidesSystemProperty.SERENITY_PROJECT_KEY.from(environmentVariables, "");
    }

    protected TestOutcome(ZonedDateTime startTime, String name, Class<?> testCase, Story userStory, EnvironmentVariables environmentVariables) {
        this(name, testCase, userStory, environmentVariables);
        this.startTime = startTime;
    }

    private Optional<Story> storyDefinedIn(Class<?> testCase) {
        if (testCase == null) {
            return Optional.empty();
        }
        return Optional.of(this.leafRequirementDefinedIn().testCase(testCase));
    }

    public TestOutcome copy() {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.id, this.scenarioId, this.methodName, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, this.actors, this.tags, this.featureTag.orElse(null), this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual, this.isManualTestingUpToDate, this.lastTested, this.manualTestEvidence, this.projectKey, this.environmentVariables, this.externalLink, this.context, this.testSource, this.testOutlineName);
    }

    protected TestOutcome(ZonedDateTime startTime, long duration, String title, String description, String name, String id, String scenarioId, String methodName, Class<?> testCase, List<TestStep> testSteps, List<String> issues, List<String> additionalIssues, List<CastMember> actors, Set<TestTag> tags, TestTag featureTag, Story userStory, FailureCause testFailureCause, String testFailureClassname, String testFailureMessage, String testFailureSummary, TestResult annotatedResult, DataTable dataTable, Optional<String> qualifier, String driver, boolean manualTest, boolean isManualTestingUpToDate, String lastTested, List<String> testEvidence, String projectKey, EnvironmentVariables environmentVariables, ExternalLink externalLink, String context, String testSource, String testOutlineName) {
        this.startTime = startTime;
        this.duration = duration;
        this.title = title;
        this.description = description;
        this.name = name;
        this.id = id;
        this.scenarioId = scenarioId;
        this.testCase = testCase;
        this.testCaseName = this.nameOf(testCase);
        this.methodName = methodName;
        this.setTestSteps(testSteps);
        this.coreIssues = this.removeDuplicates(issues);
        this.additionalVersions = this.removeDuplicates(this.additionalVersions);
        this.additionalIssues = additionalIssues;
        this.actors = actors;
        this.tags = tags;
        this.featureTag = Optional.ofNullable(featureTag);
        this.allTags = this.addFeatureTagTo(this.tags);
        this.setUserStory(userStory);
        this.testFailureCause = testFailureCause;
        this.testFailureClassname = testFailureClassname;
        this.testFailureMessage = testFailureMessage;
        this.testFailureSummary = testFailureSummary;
        this.qualifier = qualifier;
        this.annotatedResult = annotatedResult;
        this.dataTable = dataTable;
        this.issueTracking = ModelInfrastructure.getIssueTracking();
        this.linkGenerator = ModelInfrastructure.getLinkGenerator();
        this.flagProvider = ModelInfrastructure.getFlagProvider();
        this.driver = driver;
        this.manual = manualTest;
        this.manualTestEvidence = testEvidence;
        this.isManualTestingUpToDate = isManualTestingUpToDate;
        this.lastTested = lastTested;
        this.projectKey = projectKey;
        this.environmentVariables = environmentVariables;
        this.externalLink = externalLink;
        this.context = context;
        this.testSource = testSource;
        this.testOutlineName = testOutlineName;
    }

    List<String> calculateNestPath(Class<?> testCase) {
        String testCaseName;
        String className;
        List<String> nestPath = new ArrayList<String>();
        if (testCase != null && (className = (testCaseName = testCase.getName()).substring(testCaseName.lastIndexOf(".") + 1)).contains("$")) {
            nestPath = Arrays.asList(className.split("\\$"));
        }
        return nestPath;
    }

    private List<String> removeDuplicates(List<String> issues) {
        ArrayList<String> issuesWithNoDuplicates = new ArrayList<String>();
        if (issues != null) {
            for (String issue : issues) {
                if (issuesWithNoDuplicates.contains(issue)) continue;
                issuesWithNoDuplicates.add(issue);
            }
        }
        return issuesWithNoDuplicates;
    }

    public static TestOutcome forTest(String methodName, Class<?> testCase) {
        return new TestOutcome(methodName, testCase);
    }

    public TestOutcome withQualifier(String qualifier) {
        if (qualifier != null) {
            return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.id, this.scenarioId, this.methodName, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, this.actors, this.tags, this.featureTag.orElse(null), this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, Optional.ofNullable(qualifier), this.driver, this.manual, this.isManualTestingUpToDate, this.lastTested, this.manualTestEvidence, this.projectKey, this.environmentVariables, this.externalLink, this.context, this.testSource, this.testOutlineName);
        }
        return this;
    }

    public TestOutcome withIssues(List<String> issues) {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.id, this.scenarioId, this.methodName, this.testCase, this.testSteps, issues == null ? issues : new ArrayList<String>(issues), this.additionalIssues, this.actors, this.tags, this.featureTag.orElse(null), this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual, this.isManualTestingUpToDate, this.lastTested, this.manualTestEvidence, this.projectKey, this.environmentVariables, this.externalLink, this.context, this.testSource, this.testOutlineName);
    }

    public TestOutcome withTags(Set<TestTag> tags) {
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.id, this.scenarioId, this.methodName, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, this.actors, tags, this.featureTag.orElse(null), this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual, this.isManualTestingUpToDate, this.lastTested, this.manualTestEvidence, this.projectKey, this.environmentVariables, this.externalLink, this.context, this.testSource, this.testOutlineName);
    }

    public TestOutcome withStartTime(ZonedDateTime startTime) {
        return new TestOutcome(startTime, this.duration, this.title, this.description, this.name, this.id, this.scenarioId, this.methodName, this.testCase, this.testSteps, this.coreIssues, this.additionalIssues, this.actors, this.tags, this.featureTag.orElse(null), this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, this.dataTable, this.qualifier, this.driver, this.manual, this.isManualTestingUpToDate, this.lastTested, this.manualTestEvidence, this.projectKey, this.environmentVariables, this.externalLink, this.context, this.testSource, this.testOutlineName);
    }

    public String getName() {
        return this.name;
    }

    public static TestOutcome forTestInStory(String testName, Story story) {
        return new TestOutcome(testName, null, story);
    }

    public static TestOutcome forTestInStory(String testName, Class<?> testCase, Story story) {
        return new TestOutcome(testName, testCase, story);
    }

    public String toString() {
        return this.getTitle() + ":" + this.testSteps.stream().map(TestStep::toString).collect(Collectors.joining(", "));
    }

    public String getTitle() {
        if (this.title == null) {
            this.title = this.obtainQualifiedTitleFromAnnotationOrMethodName();
        }
        return this.title;
    }

    public String getTitle(boolean qualified) {
        return qualified ? this.getTitle() : this.getFormatter().stripQualifications(this.getTitle());
    }

    public TitleBuilder getUnqualified() {
        return new TitleBuilder(this, this.issueTracking, this.getEnvironmentVariables(), false);
    }

    public TitleBuilder getQualified() {
        return new TitleBuilder(this, this.issueTracking, this.getEnvironmentVariables(), true);
    }

    public void setAllStepsTo(TestResult result) {
        for (TestStep step : this.testSteps) {
            step.setResult(result);
        }
    }

    public void addDataFrom(DataTable newDataTable) {
        if (this.dataTable == null) {
            this.dataTable = DataTable.withHeaders(newDataTable.getHeaders()).build();
        }
        this.dataTable.addRows(newDataTable.getRows());
    }

    public void clearForcedResult() {
        this.annotatedResult = null;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getBrowser() {
        return this.driver.contains(":") ? this.driver.substring(0, this.driver.indexOf(":")) : this.driver;
    }

    public void resetFailingStepsCausedBy(Class<? extends Throwable> expected) {
        for (TestStep step : this.testSteps) {
            this.resetFailingStepsIn(step).causedBy(expected);
        }
        this.clearTestFailure();
    }

    private void clearTestFailure() {
        this.testFailureCause = null;
        this.testFailureClassname = null;
        this.testFailureMessage = null;
        this.annotatedResult = null;
    }

    private StepResetBuilder resetFailingStepsIn(TestStep step) {
        return new StepResetBuilder(step);
    }

    public StepReplacer replace(List<TestStep> stepsToMerge) {
        return new StepReplacer(stepsToMerge);
    }

    public void mergeMostRecentSteps(int maxStepsToMerge) {
        Preconditions.checkArgument((maxStepsToMerge > 0 ? 1 : 0) != 0);
        List<TestStep> stepsToMerge = this.getLast(maxStepsToMerge).steps();
        TestStep mergedStep = this.merge(stepsToMerge);
        this.replace(stepsToMerge).with(mergedStep);
    }

    private GetLastStepBuilder getLast(int maxCount) {
        return new GetLastStepBuilder(maxCount);
    }

    public void updateOverallResults() {
        this.updateOverallResultsFor(this.testSteps);
    }

    private void updateOverallResultsFor(List<TestStep> testSteps) {
        for (TestStep testStep : testSteps) {
            this.updateOverallResultsFor(testStep.getChildren());
            this.updateOverallResultsFor(testStep);
        }
    }

    private void updateOverallResultsFor(TestStep testStep) {
        testStep.updateOverallResult();
    }

    public Optional<TestStep> getFailingStep() {
        List<TestStep> flattenedSteps = this.getFlattenedTestSteps();
        for (int step = flattenedSteps.size() - 1; step >= 0; --step) {
            if (!flattenedSteps.get(step).isError().booleanValue() && !flattenedSteps.get(step).isFailure().booleanValue()) continue;
            return Optional.of(flattenedSteps.get(step));
        }
        return Optional.empty();
    }

    public String getId() {
        this.updateIdIfNotDefinedForLegacyPersistedFormats();
        return this.id;
    }

    public String getScenarioId() {
        return this.scenarioId;
    }

    public String getParentId() {
        if (this.id != null && this.id.contains(";")) {
            return (String)Splitter.on((String)";").splitToList((CharSequence)this.id).get(0);
        }
        return null;
    }

    private void updateIdIfNotDefinedForLegacyPersistedFormats() {
        if (this.id == null) {
            this.id = TestOutcome.identifierFrom(this.testCaseName, this.testCase, this.userStory);
        }
    }

    public TestOutcome withId(String id) {
        this.id = id;
        return this;
    }

    public TestOutcome withScenarioId(String scenarioId) {
        this.scenarioId = scenarioId;
        return this;
    }

    public void updateTopLevelStepResultsTo(TestResult result) {
        for (TestStep step : this.testSteps) {
            step.setResult(result);
        }
        if (this.dataTable != null) {
            this.dataTable.updateRowResultsTo(result);
        }
    }

    public String getTestFailureSummary() {
        return this.testFailureSummary;
    }

    public TestFailureCause getFlakyTestFailureCause() {
        return this.flakyTestFailureCause;
    }

    public void setFlakyTestFailureCause(TestFailureCause flakyTestFailureCause) {
        this.flakyTestFailureCause = flakyTestFailureCause;
    }

    public boolean hasTagWithName(String tagName) {
        for (TestTag tag : Optional.ofNullable(this.getAllTags()).orElse(Collections.emptySet())) {
            if (!tag.getName().equalsIgnoreCase(tagName)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTagWithType(String tagType) {
        return Optional.ofNullable(this.getAllTags()).orElse(Collections.emptySet()).stream().anyMatch(tag -> tag.getType().equalsIgnoreCase(tagType));
    }

    public boolean hasTagWithTypes(List<String> tagTypes) {
        return Optional.ofNullable(this.getAllTags()).orElse(Collections.emptySet()).stream().anyMatch(tag -> tagTypes.contains(tag.getType()));
    }

    public int getDataTableRowCount() {
        if (this.dataTable == null) {
            return 0;
        }
        return this.dataTable.getSize();
    }

    public int getTestStepCount() {
        return this.getTestSteps().size();
    }

    public void castActor(String name) {
        if (this.actors.stream().noneMatch(actor -> actor.getName().equalsIgnoreCase(name))) {
            this.actors.add(new CastMember(name));
        }
    }

    public void assignFact(String name, String fact) {
        if (this.actors.stream().noneMatch(actor -> actor.getName().equalsIgnoreCase(name))) {
            this.actors.add(new CastMember(name));
        }
        this.actors.stream().filter(actor -> actor.getName().equalsIgnoreCase(name)).forEach(crewMember -> crewMember.addFact(fact));
    }

    public void assignAbility(String name, String ability) {
        if (this.actors.stream().noneMatch(actor -> actor.getName().equalsIgnoreCase(name))) {
            this.actors.add(new CastMember(name));
        }
        this.actors.stream().filter(actor -> actor.getName().equalsIgnoreCase(name)).forEach(crewMember -> crewMember.addAbility(ability));
    }

    public void assignDescriptionToActor(String name, String description) {
        if (this.actors.stream().noneMatch(actor -> actor.getName().equalsIgnoreCase(name))) {
            this.actors.add(new CastMember(name));
        }
        this.actors.stream().filter(actor -> actor.getName().equalsIgnoreCase(name)).forEach(crewMember -> crewMember.withDescription(description));
    }

    public void setManualTestEvidence(List<String> manualTestEvidence) {
        this.manualTestEvidence = manualTestEvidence;
    }

    public List<String> getManualTestEvidence() {
        return this.manualTestEvidence;
    }

    public List<ManualTestEvidence> getRenderedManualTestEvidence() {
        return this.manualTestEvidence.stream().map(ManualTestEvidence::from).collect(Collectors.toList());
    }

    public void setLink(ExternalLink externalLink) {
        if (this.isDataDriven()) {
            this.getLatestTopLevelTestStep().ifPresent(latestStep -> latestStep.setExternalLink(externalLink));
        } else {
            this.externalLink = externalLink;
        }
    }

    public boolean hasNoSteps() {
        return this.testSteps == null || this.testSteps.isEmpty();
    }

    public TestOutcome withSteps(List<TestStep> childSteps) {
        this.updateTestSteps(childSteps);
        return this;
    }

    public boolean isUnsuccessful() {
        return this.getResult() == TestResult.COMPROMISED || this.getResult() == TestResult.ERROR || this.getResult() == TestResult.FAILURE;
    }

    public boolean isAJUnit5Test() {
        return this.testSource == null || this.testSource.equalsIgnoreCase("JUnit5");
    }

    public void updateDataTableResult(int row, TestResult result) {
        if (this.dataTable != null && this.dataTable.getSize() > row) {
            this.dataTable.updateRowResult(row, result);
        }
    }

    public TestOutcome withTestMethodName(String methodName) {
        this.methodName = methodName;
        return this;
    }

    public TestResult getStepResult(int stepNumber) {
        if (stepNumber >= this.getTestSteps().size()) {
            return TestResult.UNDEFINED;
        }
        List<TestResult> results = this.getTestSteps().get(stepNumber).getFlattenedSteps().stream().map(TestStep::getResult).collect(Collectors.toList());
        return TestResultList.overallResultFrom(results);
    }

    public String getTestOutlineName() {
        return this.testOutlineName;
    }

    public void setTestOutlineName(String testOutlineName) {
        this.testOutlineName = testOutlineName;
    }

    private TestStep merge(List<TestStep> stepsToMerge) {
        TestStep mergedStep = stepsToMerge.get(0);
        for (TestStep nextStep : stepsToMerge.subList(1, stepsToMerge.size())) {
            mergedStep = this.mergeStep(mergedStep).into(nextStep);
        }
        return mergedStep;
    }

    private StepMergeBuilder mergeStep(TestStep step) {
        return new StepMergeBuilder(step);
    }

    private boolean wasUnsuccessful(TestStep previousStep) {
        return previousStep.getResult() == TestResult.ERROR || previousStep.getResult() == TestResult.FAILURE || previousStep.getResult() == TestResult.COMPROMISED;
    }

    public boolean isTitleWithIssues() {
        return !this.getTitle().equalsIgnoreCase(this.getUnqualified().getTitleWithLinks());
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBackgroundDescription(String description) {
        this.backgroundDescription = description.trim();
    }

    public void setBackgroundTitle(String title) {
        this.backgroundTitle = title.trim();
    }

    public String getDescription() {
        return this.description;
    }

    public String getBackgroundDescription() {
        return this.backgroundDescription;
    }

    public String getBackgroundTitle() {
        return this.backgroundTitle;
    }

    public Optional<String> getDescriptionText() {
        if (this.getDescription() != null) {
            return Optional.of(this.description);
        }
        if (this.title != null) {
            return this.getDescriptionFrom(this.title);
        }
        return Optional.empty();
    }

    private Optional<String> getDescriptionFrom(String storedTitle) {
        ArrayList<String> multilineTitle = new ArrayList<String>(Splitter.on((Pattern)Pattern.compile("\r?\n")).splitToList((CharSequence)storedTitle));
        if (multilineTitle.size() > 1) {
            multilineTitle.remove(0);
            return Optional.of(Joiner.on(NEW_LINE).join((List<String>)multilineTitle));
        }
        return Optional.empty();
    }

    public String toJson() {
        String string;
        JSONConverter jsonConverter = ModelInfrastructure.getJsonConverter();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            jsonConverter.toJson(this, (OutputStream)outputStream);
            string = outputStream.toString(Charset.defaultCharset());
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.error("serialization error for testOutcome with name \"" + this.getName() + "\"", (Throwable)e);
                return "";
            }
        }
        outputStream.close();
        return string;
    }

    public String getTitleWithLinks() {
        return this.getFormatter().addLinks(this.getTitle());
    }

    private ReportFormatter getFormatter() {
        return new ReportFormatter(this.issueTracking);
    }

    private String obtainQualifiedTitleFromAnnotationOrMethodName() {
        String title = "";
        title = this.qualifier != null && this.qualifier.isPresent() ? this.qualified(this.getBaseTitleFromAnnotationOrMethodName()) : this.getBaseTitleFromAnnotationOrMethodName();
        return title;
    }

    private String getBaseTitleFromAnnotationOrMethodName() {
        Optional<String> annotatedTitle = TestAnnotations.forClass(this.testCase).getAnnotatedTitleForMethod(this.name);
        return annotatedTitle.orElse(NameConverter.humanize(NameConverter.withNoArguments(this.name)));
    }

    private String qualified(String rootTitle) {
        return rootTitle + " [" + this.qualifier.get() + "]";
    }

    public String getStoryTitle() {
        return this.userStory != null ? this.getTitleFrom(this.userStory) : "";
    }

    public String getPath() {
        if (this.userStory != null) {
            return this.userStory.getPath();
        }
        return null;
    }

    public String getPathId() {
        if (this.userStory != null) {
            return this.userStory.getId();
        }
        return this.getPath();
    }

    private String getTitleFrom(Story userStory) {
        return userStory.getName() == null ? "" : userStory.getName();
    }

    public String getReportName(ReportType type) {
        return ReportNamer.forReportType(type).getNormalizedReportNameFor(this);
    }

    public String getSimpleReportName(ReportType type) {
        ReportNamer reportNamer = ReportNamer.forReportType(type);
        return reportNamer.getSimpleTestNameFor(this);
    }

    public String getHtmlReport() {
        return this.getReportName(ReportType.HTML);
    }

    public String getReportName() {
        return this.getReportName(ReportType.ROOT);
    }

    public String getScreenshotReportName() {
        return this.getReportName(ReportType.ROOT) + "_screenshots";
    }

    public List<TestStep> getTestSteps() {
        return this.annotatedStepsFrom(this.testSteps);
    }

    public Optional<TestStep> getLatestTopLevelTestStep() {
        int latestStep = this.testSteps.size() - 1;
        return latestStep >= 0 ? Optional.of(this.annotatedStepsFrom(this.testSteps).get(latestStep)) : Optional.empty();
    }

    private List<TestStep> annotatedStepsFrom(List<TestStep> testSteps) {
        if (this.isManual()) {
            return testSteps.stream().map(step -> step.withResult(this.getResult()).asManual()).collect(Collectors.toList());
        }
        return testSteps;
    }

    public boolean hasScreenshots() {
        for (TestStep step : this.getFlattenedTestSteps()) {
            if (!step.hasScreenshots()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRestQueries() {
        for (TestStep step : this.getFlattenedTestSteps()) {
            if (!step.hasRestQuery()) continue;
            return true;
        }
        return false;
    }

    public List<ScreenshotAndHtmlSource> getScreenshotAndHtmlSources() {
        List<TestStep> testStepsWithScreenshots = this.getFlattenedTestSteps();
        return testStepsWithScreenshots.stream().flatMap(testStep -> testStep.getScreenshots().stream()).collect(Collectors.toList());
    }

    public List<Screenshot> getScreenshots() {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        List<TestStep> testStepsWithScreenshots = this.getFlattenedTestSteps();
        for (TestStep currentStep : testStepsWithScreenshots) {
            screenshots.addAll(currentStep.getRenderedScreenshots());
        }
        screenshots.sort(Comparator.comparing(Screenshot::getTimestamp));
        return screenshots;
    }

    public List<Screenshot> getStepScreenshots() {
        ArrayList<Screenshot> screenshots = new ArrayList<Screenshot>();
        this.testSteps.forEach(step -> screenshots.addAll(step.getRenderedScreenshots()));
        return screenshots;
    }

    public boolean hasNonStepFailure() {
        boolean stepsContainFailure = false;
        for (TestStep step : this.getFlattenedTestSteps()) {
            if (step.getResult() != TestResult.FAILURE && step.getResult() != TestResult.ERROR && step.getResult() != TestResult.COMPROMISED) continue;
            stepsContainFailure = true;
        }
        return !stepsContainFailure && (this.getResult() == TestResult.ERROR || this.getResult() == TestResult.FAILURE || this.getResult() == TestResult.COMPROMISED);
    }

    public List<TestStep> getFlattenedTestSteps() {
        if (this.flattenedSteps == null) {
            this.flattenedSteps = this.getLatestFlattenedTestSteps();
        }
        return this.flattenedSteps;
    }

    public List<TestStep> getLatestFlattenedTestSteps() {
        List<TestStep> testSteps = this.getTestSteps();
        return testSteps.stream().flatMap(step -> Stream.concat(Stream.of(step), step.isAGroup() ? step.getFlattenedSteps().stream() : Stream.empty())).collect(Collectors.toList());
    }

    public List<TestStep> getLeafTestSteps() {
        if (this.leafSteps == null) {
            ArrayList<TestStep> leafTestSteps = new ArrayList<TestStep>();
            for (TestStep step : this.getTestSteps()) {
                if (step.isAGroup()) {
                    leafTestSteps.addAll(step.getLeafTestSteps());
                    continue;
                }
                leafTestSteps.add(step);
            }
            this.leafSteps = leafTestSteps;
        }
        return this.leafSteps;
    }

    public TestResult getResult() {
        if (this.result != null) {
            return this.result;
        }
        if (this.isManual() && this.annotatedResult != null) {
            return this.annotatedResult;
        }
        if (TestResult.IGNORED == this.annotatedResult || TestResult.SKIPPED == this.annotatedResult || TestResult.PENDING == this.annotatedResult) {
            return this.annotatedResult;
        }
        TestResult testResultFromFailureClassname = this.testResultFromFailureClassname();
        ArrayList<TestResult> overallResults = new ArrayList<TestResult>(this.getCurrentTestResults());
        overallResults.add(testResultFromFailureClassname);
        TestResult testResultFromSteps = TestResultList.overallResultFrom(overallResults);
        return this.annotatedResult != null ? TestResultList.overallResultFrom(Arrays.asList(testResultFromSteps, this.annotatedResult)) : testResultFromSteps;
    }

    private TestResult testResultFromFailureClassname() {
        if (StringUtils.isNotEmpty((CharSequence)this.testFailureClassname)) {
            try {
                return new FailureAnalysis().resultFor(Class.forName(this.testFailureClassname));
            }
            catch (ReflectiveOperationException e) {
                return HeuristicTestResult.from(this.testFailureClassname);
            }
        }
        return TestResult.UNDEFINED;
    }

    public TestOutcome recordSteps(List<TestStep> steps) {
        for (TestStep step : steps) {
            this.recordStep(step);
        }
        return this;
    }

    public TestOutcome recordChildSteps(List<TestStep> steps) {
        if (this.currentStep().isPresent()) {
            steps.forEach(step -> this.currentStep().get().addChildStep((TestStep)step));
        } else {
            steps.forEach(step -> this.recordStep((TestStep)step));
        }
        return this;
    }

    public TestOutcome recordStep(TestStep step) {
        Preconditions.checkNotNull((Object)step.getDescription(), (Object)"The test step description was not defined.");
        if (this.inGroup()) {
            this.getCurrentStepGroup().addChildStep(step);
            this.renumberTestSteps();
        } else {
            this.addStep(step);
        }
        return this;
    }

    private void addStep(TestStep step) {
        ArrayList<TestStep> updatedSteps = new ArrayList<TestStep>(this.testSteps);
        updatedSteps.add(step);
        this.renumberTestSteps(updatedSteps);
        this.updateTestSteps(updatedSteps);
    }

    private void setTestSteps(List<TestStep> steps) {
        this.testSteps = steps;
        this.flattenedSteps = null;
    }

    private void renumberTestSteps(List<TestStep> testSteps) {
        int count = 1;
        for (TestStep step : testSteps) {
            count = step.renumberFrom(count);
        }
    }

    private void renumberTestSteps() {
        int count = 1;
        for (TestStep step : this.testSteps) {
            count = step.renumberFrom(count);
        }
    }

    private TestStep getCurrentStepGroup() {
        return this.groupStack.peek();
    }

    public boolean inGroup() {
        return !this.groupStack.empty();
    }

    public boolean isTopLevelGroup() {
        if (this.isDataDriven()) {
            return this.groupStack.size() == 1;
        }
        return this.groupStack.isEmpty();
    }

    public ApplicationFeature getFeature() {
        if (this.getUserStory() != null && this.getUserStory().getFeature() != null) {
            return this.getUserStory().getFeature();
        }
        return null;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private synchronized List<TestResult> getCurrentTestResults() {
        return this.testSteps.stream().map(TestStep::getResult).collect(Collectors.toList());
    }

    @Deprecated
    public void startGroup(String groupName) {
        this.recordStep(new TestStep(groupName));
        this.startGroup();
    }

    public Optional<String> getQualifier() {
        return this.qualifier;
    }

    public void startGroup() {
        this.currentStep().ifPresent(step -> this.groupStack.push((TestStep)step));
    }

    public void endGroup() {
        if (!this.groupStack.isEmpty()) {
            this.groupStack.pop();
        }
    }

    public Optional<TestStep> currentStep() {
        if (this.testSteps.isEmpty()) {
            return Optional.empty();
        }
        if (!this.inGroup()) {
            return Optional.ofNullable(this.lastStepIn(this.testSteps));
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return Optional.ofNullable(this.lastStepIn(currentStepGroup.getChildren()));
    }

    public TestStep lastStep() {
        Preconditions.checkState((!this.testSteps.isEmpty() ? 1 : 0) != 0);
        if (!this.inGroup()) {
            return this.lastStepIn(this.testSteps);
        }
        TestStep currentStepGroup = this.groupStack.peek();
        return this.lastStepIn(currentStepGroup.getChildren());
    }

    private TestStep lastStepIn(List<TestStep> testSteps) {
        if (testSteps.isEmpty()) {
            return null;
        }
        return testSteps.get(testSteps.size() - 1);
    }

    public TestStep currentGroup() {
        Preconditions.checkState((boolean)this.inGroup());
        return this.groupStack.peek();
    }

    public void setUserStory(Story story) {
        this.userStory = story;
    }

    public void determineTestFailureCause(Throwable cause) {
        List<FailureCause> stepFailureCauses = this.getLatestFlattenedTestSteps().stream().map(TestStep::getException).filter(Objects::nonNull).collect(Collectors.toList());
        if (cause != null && !this.causeIsContainedIn(cause, stepFailureCauses)) {
            RootCauseAnalyzer rootCauseAnalyser = new RootCauseAnalyzer(SerenityManagedException.detachedCopyOf(cause));
            FailureCause rootCause = rootCauseAnalyser.getRootCause();
            stepFailureCauses.add(rootCause);
            if (stepFailureCauses.size() == 1) {
                this.testFailureClassname = rootCauseAnalyser.getRootCause().getErrorType();
                this.testFailureMessage = rootCauseAnalyser.getMessage();
                this.testFailureCause = rootCause;
                this.testFailureSummary = this.failureSummaryFrom(rootCause);
                this.setAnnotatedResult(new FailureAnalysis().resultFor(rootCause.exceptionClass()));
            } else {
                List<String> errorMessages = stepFailureCauses.stream().map(FailureCause::getMessage).collect(Collectors.toList());
                MultipleAssertionErrors aggregatedErrors = new MultipleAssertionErrors(errorMessages);
                RootCauseAnalyzer aggregateRootCauseAnalyser = new RootCauseAnalyzer((Throwable)((Object)aggregatedErrors));
                FailureCause aggregateRootCause = aggregateRootCauseAnalyser.getRootCause();
                this.testFailureClassname = aggregateRootCauseAnalyser.getRootCause().getErrorType();
                this.testFailureMessage = aggregateRootCauseAnalyser.getMessage();
                this.testFailureCause = aggregateRootCause;
                this.testFailureSummary = ((Throwable)((Object)aggregatedErrors)).getMessage();
                this.setAnnotatedResult(new FailureAnalysis().resultFor(aggregateRootCause.exceptionClass()));
            }
        }
        if (stepFailureCauses.isEmpty()) {
            this.noTestFailureIsDefined();
        }
    }

    private boolean causeIsContainedIn(Throwable cause, List<FailureCause> stepFailureCauses) {
        return stepFailureCauses.stream().map(FailureCause::getOriginalCause).anyMatch(failureCause -> failureCause == cause);
    }

    private String failureSummaryFrom(FailureCause rootCause) {
        return String.format("%s;%s;%s;%s", new Object[]{this.getResult(), rootCause.getErrorType(), rootCause.getMessage(), this.stackTraceSourceFrom(rootCause)});
    }

    private String stackTraceSourceFrom(FailureCause rootCause) {
        if (rootCause.getStackTrace().length == 0) {
            return "";
        }
        return rootCause.getStackTrace()[0].getFileName();
    }

    private void noTestFailureIsDefined() {
        this.testFailureCause = null;
        this.testFailureClassname = "";
        this.testFailureMessage = "";
        this.testFailureSummary = "";
    }

    public void appendTestFailure(TestFailureCause failureCause) {
        if (!failureCause.isDefined()) {
            this.noTestFailureIsDefined();
            return;
        }
        if (this.noStepHasFailedSoFar()) {
            this.testFailureClassname = failureCause.getRootCause().getErrorType();
            this.testFailureMessage = failureCause.getTestFailureMessage();
            this.testFailureCause = failureCause.getRootCause();
            this.testFailureSummary = this.failureSummaryFrom(failureCause.getRootCause());
            this.setAnnotatedResult(failureCause.getAnnotatedResult());
        } else if (this.isMoreSevereThanPreviousErrors(failureCause)) {
            this.testFailureClassname = AssertionError.class.getName();
            this.testFailureMessage = this.testFailureMessage + System.lineSeparator() + failureCause.getTestFailureMessage();
            this.testFailureSummary = this.failureSummaryFrom(failureCause.getRootCause());
            this.setAnnotatedResult(TestResultComparison.overallResultFor(this.getAnnotatedResult(), failureCause.getAnnotatedResult()));
        }
    }

    private boolean isMoreSevereThanPreviousErrors(TestFailureCause failureCause) {
        TestResult latestFailure = new FailureAnalysis().resultFor(this.getTestFailureCause().exceptionClass());
        return latestFailure.isMoreSevereThan(this.getResult());
    }

    public Optional<TestStep> testStepWithDescription(String expectedDescription) {
        for (TestStep step : Lists.reverse(this.getFlattenedTestSteps())) {
            if (!step.getDescription().equalsIgnoreCase(expectedDescription)) continue;
            return Optional.of(step);
        }
        return Optional.empty();
    }

    private boolean noStepHasFailedSoFar() {
        return this.testFailureCause == null;
    }

    public FailureCause getTestFailureCause() {
        return this.testFailureCause;
    }

    public String getTestFailureErrorType() {
        if (this.getTestFailureCause() == null) {
            return "";
        }
        return this.getTestFailureCause().getErrorType();
    }

    public FailureCause getNestedTestFailureCause() {
        return this.getLatestFlattenedTestSteps().stream().filter(step -> step.getException() != null).map(TestStep::getException).findFirst().orElse(this.getTestFailureCause());
    }

    public Optional<TestStep> firstStepWithErrorMessage() {
        return this.getLatestFlattenedTestSteps().stream().filter(step -> StringUtils.isNotBlank((CharSequence)step.getErrorMessage())).distinct().findFirst();
    }

    public int getFirstFailingStepIndex() {
        List<TestStep> steps = this.getTestSteps();
        if (this.isDataDriven()) {
            for (TestStep exampleRow : steps) {
                if (!this.stepOrDescendantFailed(exampleRow)) continue;
                List<TestStep> gherkinSteps = exampleRow.getChildren();
                for (int i = 0; i < gherkinSteps.size(); ++i) {
                    if (!this.stepOrDescendantFailed(gherkinSteps.get(i))) continue;
                    return i;
                }
                return 0;
            }
            return -1;
        }
        for (int i = 0; i < steps.size(); ++i) {
            if (!this.stepOrDescendantFailed(steps.get(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean stepOrDescendantFailed(TestStep step) {
        if (step.getResult() != null && step.getResult().isUnsuccessful()) {
            return true;
        }
        for (TestStep child : step.getChildren()) {
            if (!this.stepOrDescendantFailed(child)) continue;
            return true;
        }
        return false;
    }

    public List<String> stepErrorMessages() {
        return this.getLatestFlattenedTestSteps().stream().map(TestStep::getErrorMessage).filter(StringUtils::isNotBlank).collect(Collectors.toList());
    }

    public Optional<String> testFailureMessage() {
        return Optional.ofNullable(this.testFailureMessage);
    }

    public String getErrorMessage() {
        List<String> stepErrorMessages = this.stepErrorMessages();
        if (stepErrorMessages.isEmpty()) {
            return this.testFailureMessage().orElse("");
        }
        if (stepErrorMessages.size() == 1) {
            return stepErrorMessages.get(0);
        }
        return stepErrorMessages.stream().collect(Collectors.joining(System.lineSeparator()));
    }

    public String getConciseErrorMessage() {
        if (this.firstStepWithErrorMessage().isPresent()) {
            return this.firstStepWithErrorMessage().get().getConciseErrorMessage();
        }
        return this.testFailureMessage().orElse("");
    }

    public void setTestFailureMessage(String testFailureMessage) {
        this.testFailureMessage = testFailureMessage;
    }

    public String getTestFailureMessage() {
        return this.testFailureMessage;
    }

    public String getTestFailureClassname() {
        return this.testFailureClassname;
    }

    public void setAnnotatedResult(TestResult annotatedResult) {
        if (this.annotatedResult != TestResult.PENDING) {
            this.annotatedResult = this.annotatedResult == null ? annotatedResult : TestResultComparison.overallResultFor(this.annotatedResult, annotatedResult);
        }
    }

    public void overrideAnnotatedResult(TestResult annotatedResult) {
        this.annotatedResult = annotatedResult;
        this.result = annotatedResult;
    }

    public void setResult(TestResult annotatedResult) {
        this.annotatedResult = annotatedResult;
    }

    public void overrideResult(TestResult result) {
        this.result = result;
        this.annotatedResult = result;
    }

    public TestOutcome withResult(TestResult annotatedResult) {
        this.setResult(annotatedResult);
        return this;
    }

    public TestResult getAnnotatedResult() {
        return this.annotatedResult;
    }

    public List<String> getAdditionalVersions() {
        return this.additionalVersions;
    }

    public List<String> getAdditionalIssues() {
        return this.additionalIssues;
    }

    private List<String> issues() {
        if (!this.thereAre(this.coreIssues)) {
            this.coreIssues = this.removeDuplicates(this.readIssues());
        }
        return this.coreIssues;
    }

    public List<String> getIssues() {
        return Stream.concat(this.issues != null ? this.issues.stream() : this.issues().stream(), this.thereAre(this.additionalIssues) ? this.additionalIssues.stream() : Stream.empty()).filter(Objects::nonNull).distinct().sorted().collect(Collectors.toList());
    }

    private List<String> versions() {
        if (!this.thereAre(this.coreVersions)) {
            this.coreVersions = this.removeDuplicates(this.readVersions());
        }
        return this.coreVersions;
    }

    private List<String> readVersions() {
        return TestOutcomeAnnotationReader.readVersionsIn(this);
    }

    public List<String> getVersions() {
        ArrayList<String> allVersions = new ArrayList<String>(this.versions());
        if (this.thereAre(this.additionalVersions)) {
            allVersions.addAll(this.additionalVersions);
        }
        this.addVersionsDefinedInTagsTo(allVersions);
        return allVersions;
    }

    private void addVersionsDefinedInTagsTo(List<String> allVersions) {
        for (TestTag tag : this.getTags()) {
            if (!tag.getType().equalsIgnoreCase("version") || allVersions.contains(tag.getName())) continue;
            allVersions.add(tag.getName());
        }
    }

    public Class<?> getTestCase() {
        if (this.testCase == null) {
            this.testCase = this.findTestCaseFromName(this.testCaseName);
        }
        return this.testCase;
    }

    private Class<?> findTestCaseFromName(String testCaseName) {
        try {
            return testCaseName != null ? Class.forName(testCaseName) : null;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getTestCaseName() {
        return this.testCaseName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    private boolean thereAre(Collection<String> anyIssues) {
        return anyIssues != null && !anyIssues.isEmpty();
    }

    public TestOutcome addVersion(String version) {
        if (!this.getVersions().contains(version)) {
            this.additionalVersions.add(version);
        }
        return this;
    }

    public TestOutcome addVersions(List<String> versions) {
        for (String version : versions) {
            this.addVersion(version);
        }
        return this;
    }

    public TestOutcome forProject(String project) {
        this.project = project;
        return this;
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public String getProject() {
        return this.project;
    }

    public TestOutcome inTestRunTimestamped(ZonedDateTime testRunTimestamp) {
        this.setTestRunTimestamp(testRunTimestamp);
        return this;
    }

    public void setTestRunTimestamp(ZonedDateTime testRunTimestamp) {
        this.testRunTimestamp = testRunTimestamp;
    }

    public void addIssues(List<String> issues) {
        HashSet<String> aggreatateIssues = new HashSet<String>(this.additionalIssues);
        aggreatateIssues.addAll(issues);
        this.additionalIssues.clear();
        this.additionalIssues.addAll(aggreatateIssues);
    }

    private List<String> readIssues() {
        return TestOutcomeAnnotationReader.readIssuesIn(this);
    }

    public String getFormattedIssues() {
        HashSet<String> issues = new HashSet<String>(this.getIssues());
        if (!issues.isEmpty()) {
            List orderedIssues = issues.stream().sorted().collect(Collectors.toList());
            String formattedIssues = orderedIssues.stream().collect(Collectors.joining(", "));
            return "(" + this.getFormatter().addLinks(formattedIssues) + ")";
        }
        return "";
    }

    public void isRelatedToIssue(String issue) {
        if (!this.issues().contains(issue)) {
            this.issues().add(issue);
        }
    }

    public void addFailingStepAsSibling(List<TestStep> testStepList, Throwable testFailureCause) {
        if (testStepList.isEmpty()) {
            this.addStep(this.failingStep(testFailureCause));
        } else {
            TestStep lastStep = this.lastStepIn(testStepList);
            if (lastStep.hasChildren()) {
                this.addFailingStepAsSibling(lastStep.children(), testFailureCause);
            } else {
                testStepList.add(this.failingStep(testFailureCause));
            }
        }
    }

    private TestStep failingStep(Throwable testFailureCause) {
        TestStep failingStep = new TestStep("Failure");
        failingStep.failedWith(testFailureCause);
        return failingStep;
    }

    public void lastStepFailedWith(StepFailure failure) {
        this.lastStepFailedWith(failure.getException());
    }

    public void lastStepFailedWith(Throwable testFailureCause) {
        this.determineTestFailureCause(testFailureCause);
        List<TestStep> leafSteps = this.getLatestFlattenedTestSteps();
        if (!leafSteps.isEmpty()) {
            TestStep lastTestStep = leafSteps.get(leafSteps.size() - 1);
            lastTestStep.failedWith(new StepFailureException(testFailureCause.getMessage(), testFailureCause));
        }
    }

    public void testFailedWith(Throwable cause) {
        this.determineTestFailureCause(cause);
    }

    public Set<TestTag> getTags() {
        if (this.tags == null) {
            this.tags = this.getTagsUsingTagProviders(this.getTagProviderService().getTagProviders(this.getTestSource()));
        }
        return this.tags;
    }

    public Set<TestTag> getAllTags() {
        return this.getTags();
    }

    private Set<TestTag> addFeatureTagTo(Set<TestTag> tags) {
        HashSet<TestTag> allTags = tags == null ? new HashSet<TestTag>() : new HashSet<TestTag>(tags);
        this.getFeatureTag().ifPresent(allTags::add);
        return allTags;
    }

    public void addUserStoryFeatureTo(Set<TestTag> augmentedTags) {
        if (this.userStory != null && this.userStory.getFeature() != null) {
            augmentedTags.add(TestTag.withName(this.userStory.getFeature().getName()).andType("feature"));
        }
    }

    private Set<TestTag> getTagsUsingTagProviders(List<TagProvider> tagProviders) {
        Set<TestTag> tags = new HashSet<TestTag>();
        for (TagProvider tagProvider : tagProviders) {
            try {
                tags.addAll(tagProvider.getTagsFor(this));
            }
            catch (Throwable theTagProviderFailedButThereIsntMuchWeCanDoAboutIt) {
                LOGGER.error("Tag provider " + String.valueOf(tagProvider) + " failure", theTagProviderFailedButThereIsntMuchWeCanDoAboutIt);
            }
        }
        tags = this.removeRedundantTagsFrom(tags);
        return new HashSet<TestTag>(tags);
    }

    private Set<TestTag> removeRedundantTagsFrom(Set<TestTag> tags) {
        HashSet<TestTag> optimizedTags = new HashSet<TestTag>();
        for (TestTag tag : tags) {
            if (this.aMoreSpecificTagExistsThan(tag).in(tags)) continue;
            optimizedTags.add(tag);
        }
        return optimizedTags;
    }

    private SpecificTagFinder aMoreSpecificTagExistsThan(TestTag tag) {
        return new SpecificTagFinder(tag);
    }

    public void setTags(Set<TestTag> tags) {
        this.tags = new HashSet<TestTag>(tags);
    }

    public void addTags(List<TestTag> tags) {
        HashSet<TestTag> updatedTags = new HashSet<TestTag>(this.getTags());
        updatedTags.addAll(tags);
        this.tags = updatedTags;
    }

    public void addTag(TestTag tag) {
        HashSet<TestTag> updatedTags = this.tags == null ? new HashSet<TestTag>() : new HashSet<TestTag>(this.tags);
        updatedTags.add(tag);
        this.tags = updatedTags;
    }

    public List<String> getIssueKeys() {
        return this.getIssues().stream().map(issue -> IssueKeyFormat.forEnvironment(this.getEnvironmentVariables()).andKey((String)issue)).distinct().sorted().collect(Collectors.toList());
    }

    public String getQualifiedMethodName() {
        if (this.qualifier != null && this.qualifier.isPresent()) {
            String qualifierWithoutSpaces = this.qualifier.get().replaceAll(" ", "_");
            return this.getName() + "_" + qualifierWithoutSpaces;
        }
        return this.getName();
    }

    public String getQualifiedId() {
        return Joiner.on("_").skipNulls().join(this.getId(), this.getQualifierText(), this.context);
    }

    private String getQualifierText() {
        if (this.qualifier != null && this.qualifier.isPresent()) {
            return this.qualifier.get().replaceAll(" ", "_");
        }
        return null;
    }

    public String getNonNullContext() {
        return this.getContext() == null ? "" : this.getContext();
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        if (this.context == null) {
            this.context = context;
            this.addContextTagsFor(context);
        }
    }

    private void addContextTagsFor(String context) {
        if (context == null) {
            return;
        }
        List<String> contexts = Arrays.stream(context.split(",")).map(String::trim).map(StringUtils::capitalize).collect(Collectors.toList());
        contexts.forEach(contextElement -> this.addTag(TestTag.withName(contextElement).andType("context")));
        if (contexts.size() > 1) {
            String allContexts = contexts.stream().collect(Collectors.joining(", "));
            this.addTag(TestTag.withName(allContexts).andType("context"));
        }
    }

    public String getCompleteName() {
        if (StringUtils.isNotEmpty((CharSequence)this.getStoryTitle())) {
            return this.getStoryTitle() + ":" + this.getName();
        }
        return String.valueOf(this.getTestCase()) + ":" + this.getName();
    }

    public void useExamplesFrom(DataTable table) {
        this.dataTable = table;
    }

    public void addNewExamplesFrom(DataTable table) {
        List<DataTableRow> updatedRows = table.getRows();
        if (table.getSize() > this.dataTable.getSize()) {
            for (int rowNumber = this.dataTable.getSize(); rowNumber < updatedRows.size(); ++rowNumber) {
                this.dataTable.appendRow(updatedRows.get(rowNumber));
            }
        }
    }

    public void moveToNextRow() {
        if (this.dataTable != null && !this.dataTable.atLastRow()) {
            this.dataTable.nextRow();
        }
    }

    public void updateCurrentRowResult(TestResult result) {
        this.dataTable.currentRow().hasResult(result);
    }

    public boolean dataIsPredefined() {
        return this.dataTable.hasPredefinedRows();
    }

    public void addRow(Map<String, ?> data) {
        this.dataTable.addRow(data);
    }

    public void addRow(DataTableRow dataTableRow) {
        this.dataTable.addRow(dataTableRow);
    }

    public int getTestCount() {
        return this.isDataDriven() ? this.getTestStepCount() : 1;
    }

    public int getImplementedTestCount() {
        return this.getStepCount() > 0 ? this.getTestCount() : 0;
    }

    public int countResults(TestResult expectedResult) {
        return this.countResults(expectedResult, TestType.ANY);
    }

    public int countResults(TestResult expectedResult, TestType expectedType) {
        if (this.isManual() && (expectedType == TestType.ANY || expectedType == TestType.MANUAL)) {
            return this.getResult() == expectedResult ? this.testCaseCount() : 0;
        }
        if (this.annotatedResult != null && !this.annotatedResult.executedResultsCount()) {
            return this.annotatedResultCount(expectedResult, expectedType);
        }
        if (this.isDataDriven()) {
            return this.countDataRowsWithResult(expectedResult, expectedType);
        }
        return this.getResult() == expectedResult && this.typeCompatibleWith(expectedType) ? 1 : 0;
    }

    private int testCaseCount() {
        if (this.isDataDriven()) {
            return this.testSteps.size();
        }
        return 1;
    }

    private int annotatedResultCount(TestResult expectedResult, TestType expectedType) {
        if (this.annotatedResult == expectedResult && this.typeCompatibleWith(expectedType)) {
            return this.isDataDriven() ? this.dataTable.getSize() : 1;
        }
        return 0;
    }

    public boolean typeCompatibleWith(TestType testType) {
        switch (testType) {
            case MANUAL: {
                return this.isManual();
            }
            case AUTOMATED: {
                return !this.isManual();
            }
        }
        return true;
    }

    private int countDataRowsWithResult(TestResult expectedResult, TestType expectedType) {
        int matchingRowCount = 0;
        if (!this.typeCompatibleWith(expectedType)) {
            return 0;
        }
        if (this.resultsAreUndefinedIn(this.getDataTable()) || this.isAJUnit5Test()) {
            for (TestStep step : this.getTestSteps()) {
                matchingRowCount += step.getResult() == expectedResult ? 1 : 0;
            }
        } else {
            for (DataTableRow row : this.getDataTable().getRows()) {
                matchingRowCount += row.getResult() == expectedResult ? 1 : 0;
            }
        }
        return matchingRowCount;
    }

    private boolean resultsAreUndefinedIn(DataTable dataTable) {
        return dataTable.getRows().stream().allMatch(row -> row.getResult() == TestResult.UNDEFINED);
    }

    public int countNestedStepsWithResult(TestResult expectedResult, TestType testType) {
        if (this.isDataDriven()) {
            return this.countDataRowStepsWithResult(expectedResult, testType);
        }
        return this.getResult() == expectedResult && this.typeCompatibleWith(testType) ? this.getNestedStepCount() : 0;
    }

    private int countDataRowStepsWithResult(TestResult expectedResult, TestType testType) {
        int rowsWithResult = this.countDataRowsWithResult(expectedResult, testType);
        int totalRows = this.getDataTable().getSize();
        int totalSteps = this.getNestedStepCount();
        return totalSteps * rowsWithResult / totalRows;
    }

    public Optional<String> getTagValue(String tagType) {
        if (tagType.equalsIgnoreCase(ISSUES) && !this.getIssueKeys().isEmpty()) {
            return Optional.of(Joiner.on(",").join(this.getIssueKeys()));
        }
        for (TestTag tag : this.getTags()) {
            if (!tag.getType().equalsIgnoreCase(tagType)) continue;
            return Optional.of(tag.getName());
        }
        return Optional.empty();
    }

    public boolean hasIssue(String issue) {
        return this.getIssues().contains(issue);
    }

    public boolean hasTag(TestTag tag) {
        return this.getAllTags().contains(tag);
    }

    public boolean hasAMoreGeneralFormOfTag(TestTag specificTag) {
        return TestTags.of(this.getAllTags()).containsTagMatching(specificTag);
    }

    public boolean hasAMoreSpecificFormOfTag(TestTag generalTag) {
        return this.getAllTags().stream().anyMatch(tag -> tag.isAsOrMoreSpecificThan(generalTag));
    }

    public void setStartTime(ZonedDateTime startTime) {
        this.startTime = startTime;
    }

    public void clearStartTime() {
        this.startTime = null;
    }

    public boolean isManual() {
        return this.manual;
    }

    public String getLastTested() {
        return this.lastTested;
    }

    public void setLastTested(String lastTested) {
        this.lastTested = lastTested;
    }

    public boolean isManualTestingUpToDate() {
        return this.isManualTestingUpToDate;
    }

    public void setManualTestingUpToDate(Boolean upToDate) {
        this.isManualTestingUpToDate = upToDate;
    }

    public Set<? extends Flag> getFlags() {
        if (this.flags == null) {
            this.flags = this.flagProvider.getFlagsFor(this);
            this.addFlagTagsFor(this.flags);
        }
        return this.flags;
    }

    private void addFlagTagsFor(Set<? extends Flag> flags) {
        for (Flag flag : flags) {
            this.addTag(TestTag.withName(flag.getMessage()).andType("flag"));
        }
    }

    public boolean isStartTimeNotDefined() {
        return this.startTime == null;
    }

    private SystemClock getSystemClock() {
        return ModelInfrastructure.getClock();
    }

    private ZonedDateTime now() {
        return this.getSystemClock().getCurrentTime();
    }

    public OptionalElements has() {
        return new OptionalElements(this);
    }

    public Integer getStepCount() {
        return this.testSteps.size();
    }

    public Integer getRunningStepCount() {
        return this.runningStepCountOf(this.testSteps);
    }

    private Integer runningStepCountOf(List<TestStep> steps) {
        if (this.tailOf(steps).isPresent() && this.tailOf(steps).get().hasChildren()) {
            return this.runningStepCountOf(this.tailOf(steps).get().getChildren());
        }
        return steps.size();
    }

    private Optional<TestStep> tailOf(List<TestStep> testSteps) {
        return testSteps.isEmpty() ? Optional.empty() : Optional.of(testSteps.get(testSteps.size() - 1));
    }

    public Integer getNestedStepCount() {
        return this.getFlattenedTestSteps().size();
    }

    public Long getSuccessCount() {
        return this.count(TestStep.SUCCESSFUL_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getFailureCount() {
        return this.count(TestStep.FAILING_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getErrorCount() {
        return this.count(TestStep.ERROR_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getCompromisedCount() {
        return this.count(TestStep.COMPROMISED_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getIgnoredCount() {
        return this.count(TestStep.IGNORED_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getSkippedOrIgnoredCount() {
        return this.getIgnoredCount() + this.getSkippedCount();
    }

    public Long getSkippedCount() {
        return this.count(TestStep.SKIPPED_TESTSTEPS).in(this.getLeafTestSteps());
    }

    public Long getPendingCount() {
        return this.getLeafTestSteps().stream().filter(TestStep::isPending).count();
    }

    public Boolean isSuccess() {
        return this.getResult() == TestResult.SUCCESS;
    }

    public Boolean isFailure() {
        return this.getResult() == TestResult.FAILURE;
    }

    public Boolean isCompromised() {
        return this.getResult() == TestResult.COMPROMISED;
    }

    public Boolean isError() {
        return this.getResult() == TestResult.ERROR;
    }

    public Boolean isPending() {
        return this.getResult() == TestResult.PENDING;
    }

    public Boolean isSkipped() {
        return this.getResult() == TestResult.SKIPPED || this.getResult() == TestResult.IGNORED || this.getResult() == TestResult.ABORTED;
    }

    public Story getUserStory() {
        return this.userStory;
    }

    public void recordDuration(ZonedDateTime finishTime) {
        this.endTime = finishTime;
        if (this.duration == 0L) {
            long duration = ChronoUnit.MILLIS.between(this.startTime, finishTime);
            this.setDuration(duration);
        }
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public Long getDuration() {
        if (this.isDataDriven()) {
            return this.getDataDrivenDuration();
        }
        if (this.startTime != null && this.endTime != null) {
            return ChronoUnit.MILLIS.between(this.startTime, this.endTime);
        }
        return this.duration;
    }

    private long getDataDrivenDuration() {
        Optional<ZonedDateTime> earliestStartTime = this.getTestSteps().stream().map(TestStep::getStartTime).min(Comparator.naturalOrder());
        Optional<ZonedDateTime> latestEndTime = this.getDataDrivenEndTime();
        if (earliestStartTime.isPresent() && latestEndTime.isPresent()) {
            return ChronoUnit.MILLIS.between(earliestStartTime.get(), latestEndTime.get());
        }
        return 0L;
    }

    private Optional<ZonedDateTime> getDataDrivenEndTime() {
        return this.getTestSteps().stream().map(TestStep::getEndTime).max(Comparator.naturalOrder());
    }

    public ZonedDateTime getEndTime() {
        if (this.isDataDriven()) {
            return this.getDataDrivenEndTime().orElse(null);
        }
        return this.endTime;
    }

    public double getDurationInSeconds() {
        if (this.durationInSeconds == null) {
            this.durationInSeconds = TestDuration.of(this.getDuration()).inSeconds();
        }
        return this.durationInSeconds;
    }

    public String getVideoLink() {
        return this.linkGenerator.linkFor(this);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    private StepCountBuilder count(Predicate<TestStep> filter) {
        return new StepCountBuilder(filter);
    }

    public Integer countTestSteps() {
        return this.countLeafStepsIn(this.testSteps);
    }

    private Integer countLeafStepsIn(List<TestStep> testSteps) {
        int leafCount = 0;
        for (TestStep step : testSteps) {
            if (step.isAGroup()) {
                leafCount += this.countLeafStepsIn(step.getChildren()).intValue();
                continue;
            }
            ++leafCount;
        }
        return leafCount;
    }

    StepFilter successfulSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isSuccessful();
            }
        };
    }

    StepFilter failingSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isFailure();
            }
        };
    }

    StepFilter errorSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isError();
            }
        };
    }

    StepFilter compromisedSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isCompromised();
            }
        };
    }

    StepFilter ignoredSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isIgnored();
            }
        };
    }

    StepFilter skippedSteps() {
        return new StepFilter(){

            @Override
            boolean apply(TestStep step) {
                return step.isSkipped();
            }
        };
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public String getStartedAt() {
        return Optional.ofNullable(this.startTime).orElse(this.now()).format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    public String getTimestamp() {
        return Optional.ofNullable(this.startTime).orElse(this.now()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getTimestamp(DateTimeFormatter formater) {
        return Optional.ofNullable(this.startTime).orElse(this.now()).format(formater);
    }

    public boolean isDataDriven() {
        return this.dataTable != null;
    }

    private List<TestStep> getStepChildren() {
        List<TestStep> firstLevel = this.firstNonPreconditionStepChildren();
        if (firstLevel.size() > 0 && firstLevel.get(0).getDescription().matches("^\\[\\d+\\]\\s\\{.+")) {
            firstLevel = firstLevel.get(0).getChildren();
        }
        return firstLevel;
    }

    public List<String> getExampleFields() {
        return this.isDataDriven() ? this.getDataTable().getHeaders() : NO_HEADERS;
    }

    private List<TestStep> firstNonPreconditionStepChildren() {
        for (TestStep step : this.getTestSteps()) {
            if (step.isAPrecondition() || !step.hasChildren()) continue;
            return step.getChildren();
        }
        return new ArrayList<TestStep>();
    }

    public void useScenarioOutline(String scenarioOutline) {
        this.scenarioOutline = scenarioOutline;
    }

    public String getDataDrivenSampleScenario() {
        if (this.scenarioOutline == null) {
            this.scenarioOutline = this.buildScenarioOutline();
        }
        return this.scenarioOutline;
    }

    private String buildScenarioOutline() {
        if (!this.isDataDriven() || this.getTestSteps().isEmpty() || !this.atLeastOneStepHasChildren()) {
            return "";
        }
        if (this.dataTable.scenarioOutline().isPresent()) {
            return this.dataTable.scenarioOutline().get();
        }
        StringBuilder sampleScenario = new StringBuilder();
        for (TestStep step : this.getStepChildren()) {
            sampleScenario.append(this.withPlaceholderSubstitutes(step.getDescription())).append("\n");
        }
        return sampleScenario.length() > 1 ? sampleScenario.substring(0, sampleScenario.length() - 1) : "";
    }

    private String withPlaceholderSubstitutes(String stepName) {
        if (this.dataTable == null || this.dataTable.getRows().isEmpty()) {
            return stepName;
        }
        return this.dataTable.restoreVariablesIn(stepName);
    }

    private boolean atLeastOneStepHasChildren() {
        return this.getTestSteps().stream().anyMatch(TestStep::hasChildren);
    }

    public DataTable getDataTable() {
        return this.dataTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestOutcome that = (TestOutcome)o;
        if (this.manual != that.manual) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.qualifier != null ? !this.qualifier.equals(that.qualifier) : that.qualifier != null) {
            return false;
        }
        if (this.context != null ? !this.context.equals(that.context) : that.context != null) {
            return false;
        }
        if (this.testCaseName != null ? !this.testCaseName.equals(that.testCaseName) : that.testCaseName != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return this.userStory != null ? this.userStory.equals(that.userStory) : that.userStory == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
        result = 31 * result + (this.testCaseName != null ? this.testCaseName.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.userStory != null ? this.userStory.hashCode() : 0);
        result = 31 * result + (this.manual ? 1 : 0);
        return result;
    }

    public Optional<TestTag> getFeatureTag() {
        if (!this.featureTag.isPresent()) {
            this.featureTag = FeatureTagAsDefined.in(this.userStory, this.getPath());
        }
        return this.featureTag;
    }

    private void removeSteps(List<TestStep> stepsToReplace) {
        ArrayList<TestStep> updatedSteps = new ArrayList<TestStep>(this.testSteps);
        updatedSteps.removeAll(stepsToReplace);
        this.renumberTestSteps(updatedSteps);
        this.updateTestSteps(updatedSteps);
    }

    public FailureDetails getFailureDetails() {
        return new FailureDetails(this);
    }

    public String getTestSource() {
        return this.testSource;
    }

    public void setTestSource(String testSource) {
        this.testSource = testSource;
    }

    public List<CastMember> getActors() {
        return this.actors;
    }

    public boolean hasEvidence() {
        return this.testSteps.stream().anyMatch(step -> step.getReportData().stream().anyMatch(ReportData::isEvidence));
    }

    public List<ReportData> getEvidence() {
        return this.getFlattenedTestSteps().stream().filter(step -> !step.getReportEvidence().isEmpty()).map(TestStep::getReportEvidence).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public TestOutcome withDataRowsfilteredbyTag(TestTag tag) {
        return this.withDataRowsfilteredbyTagsFrom(Collections.singleton(tag));
    }

    public TestOutcome withDataRowsfilteredbyTagsFrom(Collection<TestTag> filterTags) {
        if (!this.isDataDriven()) {
            return this;
        }
        if (!TestTags.of(this.dataTable.getTags()).containsTagMatchingOneOf(filterTags)) {
            return this;
        }
        if (this.testSteps.size() != this.dataTable.getSize()) {
            return this;
        }
        DataTable filteredDataTable = this.dataTable.containingOnlyRowsWithTagsFrom(filterTags);
        List<TestStep> filteredSteps = this.testSteps;
        Collection<TestTag> originalDataTableTags = this.dataTable.getTags();
        Collection<TestTag> filteredDataTableTags = filteredDataTable.getTags();
        HashSet<TestTag> redundantTags = new HashSet<TestTag>(originalDataTableTags);
        redundantTags.removeAll(filteredDataTableTags);
        HashSet<TestTag> outcomeTagsWithoutRedundentTags = new HashSet<TestTag>(this.tags);
        outcomeTagsWithoutRedundentTags.removeAll(redundantTags);
        return new TestOutcome(this.startTime, this.duration, this.title, this.description, this.name, this.id, this.scenarioId, this.methodName, this.testCase, filteredSteps, this.issues, this.additionalIssues, this.actors, outcomeTagsWithoutRedundentTags, this.featureTag.orElse(null), this.userStory, this.testFailureCause, this.testFailureClassname, this.testFailureMessage, this.testFailureSummary, this.annotatedResult, filteredDataTable, this.qualifier, this.driver, this.manual, this.isManualTestingUpToDate, this.lastTested, this.manualTestEvidence, this.projectKey, this.environmentVariables, this.externalLink, this.context, this.testSource, this.testOutlineName);
    }

    public ExternalLink getExternalLink() {
        return this.externalLink;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Integer getOrder() {
        if (this.order == null) {
            return 0;
        }
        return this.order;
    }

    public TestOutcome fromStep(int index) {
        return this.fromStep(this.testSteps.get(index));
    }

    public TestOutcome fromStep(TestStep testStep) {
        List<TestStep> specifiedSteps = Arrays.asList(testStep);
        TestOutcome specifiedOutcome = this.copy().withSteps(specifiedSteps);
        Optional<TestFailureCause> failureCause = TestFailureCause.from(specifiedOutcome.getFlattenedTestSteps());
        if (failureCause.isPresent()) {
            specifiedOutcome.appendTestFailure(failureCause.get());
        } else {
            specifiedOutcome.noTestFailureIsDefined();
        }
        return specifiedOutcome;
    }

    public TestOutcome withExamplesMatching(Predicate<TestStep> condition) {
        if (this.isDataDriven() && this.someStepsDoNotMatch(condition)) {
            return this.copy().removeTopLevelStepsNotMatching(condition);
        }
        return this;
    }

    public TestOutcome withExamplesHavingResult(TestResult result) {
        if (!this.isDataDriven() || this.containsOnlyExamplesWithResult(result) || this.containsNoExamplesWithResult(result)) {
            return this;
        }
        return this.copy().removeTopLevelStepsNotHavingResult(result);
    }

    private boolean containsNoExamplesWithResult(TestResult result) {
        Set<TestResult> distinctResults = this.getDistinctResults();
        for (TestResult actualResult : result.expanded()) {
            if (!distinctResults.contains((Object)actualResult)) continue;
            return false;
        }
        return true;
    }

    private boolean containsOnlyExamplesWithResult(TestResult result) {
        Set<TestResult> distinctResults = this.getDistinctResults();
        return distinctResults.size() == 1 && result.expanded().contains((Object)distinctResults.iterator().next());
    }

    public List<TestOutcome> asTestCases() {
        if (this.isDataDriven()) {
            ArrayList<TestOutcome> testCases = new ArrayList<TestOutcome>();
            int rowNumber = 1;
            for (TestStep step : this.testSteps) {
                testCases.add(this.testCaseInStep(step, rowNumber++));
            }
            return testCases;
        }
        return Arrays.asList(this);
    }

    private TestOutcome testCaseInStep(TestStep childStep, int rowNumber) {
        TestOutcome testCaseOutcome = this.copy().withSteps(Arrays.asList(childStep));
        testCaseOutcome.setTitle(TestOutcome.stepTitleIn(childStep.getDescription()) + " [" + rowNumber + "]");
        testCaseOutcome.setTestData(TestOutcome.testDataIn(childStep.getDescription()));
        return testCaseOutcome;
    }

    private void setTestData(String testData) {
        this.testData = testData;
    }

    public String getTestData() {
        return this.testData;
    }

    private static String stepTitleIn(String description) {
        return description.contains("{") ? description.substring(0, description.indexOf("{")) : description;
    }

    private static String testDataIn(String description) {
        return description.contains("{") ? TestOutcome.trimmedDescription(description.substring(description.indexOf("{"))) : "";
    }

    private static String trimmedDescription(String description) {
        int parametersStart = description.indexOf("{") + 1;
        int parametersEnd = description.lastIndexOf("}");
        return description.substring(parametersStart, parametersEnd);
    }

    public TestOutcome removeTopLevelStepsNotMatching(Predicate<TestStep> condition) {
        ArrayList<TestStep> updatedSteps = new ArrayList<TestStep>();
        for (TestStep step : this.testSteps) {
            if (!condition.test(step)) continue;
            updatedSteps.add(step);
        }
        this.updateTestSteps(updatedSteps);
        return this;
    }

    public TestOutcome removeTopLevelStepsNotHavingResult(TestResult result) {
        ArrayList<TestStep> updatedSteps = new ArrayList<TestStep>();
        for (TestStep step : this.testSteps) {
            if (!result.expanded().contains((Object)step.getResult())) continue;
            updatedSteps.add(step);
        }
        this.updateTestSteps(updatedSteps);
        return this;
    }

    private void updateTestSteps(List<TestStep> updatedSteps) {
        this.testSteps = updatedSteps;
        this.flattenedSteps = null;
        this.leafSteps = null;
    }

    private boolean someStepsDoNotMatch(Predicate<TestStep> condition) {
        return this.testSteps.stream().anyMatch(condition);
    }

    public boolean containsAtLeastOneOutcomeWithResult(TestResult expectedResult) {
        if (this.isDataDriven()) {
            for (TestStep step : this.testSteps) {
                if (!expectedResult.expanded().contains((Object)step.getResult())) continue;
                return true;
            }
            return false;
        }
        return expectedResult.expanded().contains((Object)this.getResult());
    }

    public Stream<TestResult> getAllResultsStream() {
        if (this.isDataDriven()) {
            return this.getTestSteps().stream().map(TestStep::getResult);
        }
        return Stream.of(this.getResult());
    }

    public List<TestResult> getAllResults() {
        if (this.isManual() && this.isDataDriven()) {
            return this.testSteps.stream().map(step -> this.getResult()).collect(Collectors.toList());
        }
        if (!this.isManual() && this.isDataDriven()) {
            return this.testSteps.stream().map(TestStep::getOverallResult).collect(Collectors.toList());
        }
        return Collections.singletonList(this.getResult());
    }

    public long getResultCount() {
        long count = 0L;
        count = this.isDataDriven() ? (count += (long)this.testSteps.size()) : ++count;
        return count;
    }

    public Set<TestResult> getDistinctResults() {
        HashSet<TestResult> results = new HashSet<TestResult>();
        if (this.isDataDriven()) {
            for (TestStep step : this.getTestSteps()) {
                results.add(step.getResult());
            }
        } else {
            results.add(this.getResult());
        }
        return results;
    }

    public boolean hasResult(TestResult result) {
        return this.getAllResults().contains((Object)result);
    }

    private static class TestOutcomeWithEnvironmentBuilder {
        private final EnvironmentVariables environmentVariables;

        public TestOutcomeWithEnvironmentBuilder(EnvironmentVariables environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        public Object forTest(String methodName, Class<?> testCase) {
            return new TestOutcome(methodName, testCase, this.environmentVariables);
        }

        public Object forTest(String methodName, Class<?> testCase, Story story) {
            return new TestOutcome(methodName, testCase, story, this.environmentVariables);
        }
    }

    private class StepResetBuilder {
        TestStep step;

        public StepResetBuilder(TestStep step) {
            this.step = step;
        }

        public void causedBy(Class<? extends Throwable> expected) {
            if (this.step.getException() != null && this.step.getException().getErrorType() != null && TheErrorType.causedBy(this.step.getException().getErrorType()).isAKindOf(expected)) {
                this.step.clearException();
                this.step.setResult(TestResult.SUCCESS);
            }
            for (TestStep childStep : this.step.getChildren()) {
                TestOutcome.this.resetFailingStepsIn(childStep).causedBy(expected);
            }
        }
    }

    public class StepReplacer {
        List<TestStep> stepsToReplace;

        public StepReplacer(List<TestStep> stepsToReplace) {
            this.stepsToReplace = stepsToReplace;
        }

        public void with(TestStep mergedStep) {
            TestOutcome.this.removeSteps(this.stepsToReplace);
            TestOutcome.this.addStep(mergedStep);
            TestOutcome.this.renumberTestSteps();
        }
    }

    private class GetLastStepBuilder {
        int maxCount;

        public GetLastStepBuilder(int maxCount) {
            this.maxCount = maxCount;
        }

        public List<TestStep> steps() {
            List testStepPartitions = Lists.partition((List)Lists.reverse(TestOutcome.this.getTestSteps()), (int)this.maxCount);
            return Lists.reverse((List)((List)testStepPartitions.get(0)));
        }
    }

    class StepMergeBuilder {
        private final TestStep previousStep;

        private StepMergeBuilder(TestStep step) {
            this.previousStep = step;
        }

        public TestStep into(TestStep nextStep) {
            TestStep mergedStep = nextStep.addChildStep(this.previousStep);
            if (nextStep.getResult() == TestResult.SKIPPED && TestOutcome.this.wasUnsuccessful(this.previousStep)) {
                nextStep.setResult(TestResult.UNDEFINED);
            }
            mergedStep.setResult(this.merge(nextStep.getResult()).with(this.previousStep.getResult()));
            return mergedStep;
        }

        private StepResultMergeStragegy merge(TestResult nextStepResult) {
            return MergeStepResultStrategy.whenNextStepResultIs(nextStepResult);
        }
    }

    private static class SpecificTagFinder {
        private final TestTag tag;

        public SpecificTagFinder(TestTag tag) {
            this.tag = tag;
        }

        public boolean in(Set<TestTag> tags) {
            for (TestTag otherTag : tags) {
                if (otherTag == this.tag || !otherTag.isAsOrMoreSpecificThan(this.tag)) continue;
                return true;
            }
            return false;
        }
    }

    public static class OptionalElements {
        private final TestOutcome testOutcome;

        public OptionalElements(TestOutcome testOutcome) {
            this.testOutcome = testOutcome;
        }

        public boolean testRunTimestamp() {
            return this.testOutcome.testRunTimestamp != null;
        }
    }

    public static class StepCountBuilder {
        private final Predicate<TestStep> stepFilter;

        private StepCountBuilder(Predicate<TestStep> filter) {
            this.stepFilter = filter;
        }

        long in(List<TestStep> steps) {
            return steps.stream().filter(this.stepFilter).count();
        }
    }

    abstract class StepFilter {
        StepFilter() {
        }

        abstract boolean apply(TestStep var1);
    }
}

