/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.steps;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.model.reflection.MethodFinder;
import net.thucydides.model.steps.AnnotatedStepDescription;
import net.thucydides.model.steps.ScreenplayInspector;
import net.thucydides.model.steps.StepArgumentWriter;
import net.thucydides.model.util.NameConverter;

public class ExecutedStepDescription
implements Cloneable {
    private final Class<? extends Object> stepsClass;
    private final String name;
    private final List<Object> argumentsList;
    private final List<String> convertedArgumentsList;
    private final Map<String, Object> displayedFields;
    private boolean isAGroup;
    private static final Map<String, Object> NO_FIELDS = new HashMap<String, Object>();
    private static final List<Object> NO_ARGUMENTS = new ArrayList<Object>();
    private boolean isAQuestion;

    protected ExecutedStepDescription(Class<? extends Object> stepsClass, String name, List<Object> argumentsList, Map<String, Object> displayedFields, boolean isAGroup) {
        this.stepsClass = stepsClass;
        this.name = name;
        this.argumentsList = argumentsList;
        this.convertedArgumentsList = ExecutedStepDescription.convertArguments(this.argumentsList.toArray());
        this.displayedFields = displayedFields;
        this.isAGroup = isAGroup;
        this.isAQuestion = false;
    }

    public ExecutedStepDescription(Class<? extends Object> stepsClass, String name, boolean isAGroup) {
        this(stepsClass, name, NO_ARGUMENTS, NO_FIELDS, isAGroup);
    }

    public ExecutedStepDescription(Class<? extends Object> stepsClass, String name) {
        this(stepsClass, name, NO_ARGUMENTS, NO_FIELDS, false);
    }

    public ExecutedStepDescription(String name) {
        this(null, name, NO_ARGUMENTS, NO_FIELDS, false);
    }

    public ExecutedStepDescription clone() {
        return new ExecutedStepDescription(this.stepsClass, this.name, this.argumentsList, this.displayedFields, this.isAGroup);
    }

    public Class<? extends Object> getStepClass() {
        return this.stepsClass;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getArguments() {
        return this.convertedArgumentsList;
    }

    public List<Object> getRawArguments() {
        return this.argumentsList;
    }

    public ExecutedStepDescription withName(String newName) {
        return new ExecutedStepDescription(this.stepsClass, newName, this.isAGroup);
    }

    public ExecutedStepDescription withDisplayedFields(Map<String, Object> displayedFields) {
        return new ExecutedStepDescription(this.stepsClass, this.name, this.argumentsList, displayedFields, this.isAGroup);
    }

    public static ExecutedStepDescription of(Class<? extends Object> stepsClass, String name) {
        return new ExecutedStepDescription(stepsClass, name, NO_ARGUMENTS, NO_FIELDS, false);
    }

    public static ExecutedStepDescription of(Class<? extends Object> stepsClass, String name, Object[] arguments) {
        return new ExecutedStepDescription(stepsClass, name, Arrays.asList(arguments), NO_FIELDS, false);
    }

    private static List<String> convertArguments(Object[] arguments) {
        return Arrays.stream(arguments).map(StepArgumentWriter::readableFormOf).collect(Collectors.toList());
    }

    public static ExecutedStepDescription withTitle(String name) {
        return new ExecutedStepDescription(name);
    }

    public boolean isAGroup() {
        return this.isAGroup;
    }

    public void setAGroup(boolean aGroup) {
        this.isAGroup = aGroup;
    }

    public Method getStepMethod() {
        if (this.getStepClass() != null) {
            if (ScreenplayInspector.isAScreenplayClass(this.getStepClass())) {
                return ScreenplayInspector.performAsMethodIn(this.getStepClass());
            }
            return this.methodCalled(NameConverter.withNoArguments(this.getName()), this.getStepClass());
        }
        return null;
    }

    public boolean isAQuestion() {
        return this.isAQuestion;
    }

    private Method methodCalled(String methodName, Class<?> testClass) {
        Method method = MethodFinder.inClass(testClass).getMethodNamed(methodName);
        if (method == null) {
            throw new IllegalArgumentException("No test method called " + methodName + " was found in " + String.valueOf(testClass));
        }
        return method;
    }

    public String getTitle() {
        try {
            return NameConverter.humanize(AnnotatedStepDescription.from(this).getName());
        }
        catch (IllegalArgumentException noMatchingMethod) {
            return NameConverter.humanize(this.name);
        }
    }

    public Map<String, Object> getDisplayedFields() {
        return new HashMap<String, Object>(this.displayedFields);
    }

    public ExecutedStepDescription asAQuestion() {
        this.isAQuestion = true;
        return this;
    }
}

