/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.reports.cucumber;

import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Tag;
import java.io.File;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestResultList;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.html.CucumberTagConverter;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.model.requirements.reports.ExampleOutcome;
import net.thucydides.model.requirements.reports.ExampleOutcomes;
import net.thucydides.model.requirements.reports.ReportBadges;
import net.thucydides.model.requirements.reports.RequirementsOutcomes;
import net.thucydides.model.requirements.reports.ScenarioOutcome;
import net.thucydides.model.requirements.reports.ScenarioSummaryOutcome;
import net.thucydides.model.requirements.reports.cucumber.FeatureCache;
import net.thucydides.model.requirements.reports.cucumber.RenderCucumber;
import net.thucydides.model.tags.TagScanner;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class FeatureFileScenarioOutcomes {
    private final Requirement requirement;
    private final EnvironmentVariables environmentVariables;
    private final TagScanner tagScanner;

    public FeatureFileScenarioOutcomes(Requirement requirement, EnvironmentVariables environmentVariables) {
        this.requirement = requirement;
        this.environmentVariables = environmentVariables;
        this.tagScanner = new TagScanner(environmentVariables);
    }

    public FeatureFileScenarioOutcomes(Requirement requirement) {
        this(requirement, SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public static FeatureFileScenarioOutcomes from(Requirement requirement) {
        return new FeatureFileScenarioOutcomes(requirement);
    }

    private String normalizedFormOf(String path) {
        return path.replace("\\", "/");
    }

    public List<ScenarioOutcome> forOutcomesIn(RequirementsOutcomes requirementsOutcomes) {
        Optional<AnnotatedFeature> feature = FeatureCache.getCache().loadFeature(this.pathFromResourceOnClasspath(this.requirement.getPath()));
        if (!feature.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<ScenarioOutcome> scenarioOutcomes = new ArrayList<ScenarioOutcome>();
        Feature currentFeature = feature.get().getFeature();
        for (FeatureChild currentChild : currentFeature.getChildren()) {
            if (currentChild.getRule() != null && currentChild.getRule().isPresent()) {
                Rule currentRule = (Rule)currentChild.getRule().get();
                currentRule.getChildren().stream().filter(ruleChild -> ruleChild.getScenario() != null && ruleChild.getScenario().isPresent()).forEach(ruleChild -> scenarioOutcomes.add(this.scenarioOutcomeFrom(currentFeature, (Scenario)ruleChild.getScenario().get(), requirementsOutcomes.getTestOutcomes(), net.thucydides.model.domain.Rule.from(currentRule))));
                continue;
            }
            if (currentChild.getScenario() != null && currentChild.getScenario().isPresent()) {
                scenarioOutcomes.add(this.scenarioOutcomeFrom(currentFeature, (Scenario)currentChild.getScenario().get(), requirementsOutcomes.getTestOutcomes()));
            }
            if (currentChild.getBackground() == null || !currentChild.getBackground().isPresent()) continue;
            scenarioOutcomes.add(this.scenarioBackgroundFrom(currentFeature, (Background)currentChild.getBackground().get(), requirementsOutcomes.getTestOutcomes()));
        }
        return scenarioOutcomes;
    }

    private ScenarioOutcome scenarioOutcomeFrom(Feature feature, Scenario scenario, TestOutcomes testOutcomes) {
        return this.scenarioOutcomeFrom(feature, scenario, testOutcomes, null);
    }

    private ScenarioOutcome scenarioBackgroundFrom(Feature feature, Background scenario, TestOutcomes testOutcomes) {
        List<TestOutcome> outcomes = testOutcomes.testOutcomesWithName(scenario.getName());
        String scenarioTitle = scenario.getName();
        TestResult result = outcomes.isEmpty() ? TestResult.UNDEFINED : TestResultList.overallResultFrom(outcomes.stream().map(TestOutcome::getResult).collect(Collectors.toList()));
        List<String> reportBadges = ReportBadges.from(outcomes, scenario.getName());
        String featureReport = new ReportNameProvider().forRequirement(feature.getName(), "feature");
        Optional<String> scenarioReport = outcomes.isEmpty() ? Optional.empty() : Optional.of(outcomes.get(0).getHtmlReport());
        List<String> renderedSteps = scenario.getSteps().stream().map(RenderCucumber::step).collect(Collectors.toList());
        return new ScenarioSummaryOutcome(scenarioTitle, scenario.getKeyword(), result, reportBadges, scenarioReport.orElse(""), scenario.getDescription(), renderedSteps, new ArrayList<String>(), new ArrayList<ExampleOutcome>(), 0, false, feature.getName(), featureReport, new HashSet<TestTag>(), new HashMap<String, Collection<TestTag>>(), null, this.startTimeOfFirstTestIn(outcomes), this.totalDurationOf(outcomes), Collections.emptyList(), this.firstContextIn(testOutcomes), this.firstFailingStepIndexIn(outcomes));
    }

    private ZonedDateTime startTimeOfFirstTestIn(List<TestOutcome> outcomes) {
        return outcomes.stream().map(TestOutcome::getStartTime).sorted().findFirst().orElse(null);
    }

    private Long totalDurationOf(List<TestOutcome> outcomes) {
        return outcomes.stream().mapToLong(TestOutcome::getDuration).sum();
    }

    private int firstFailingStepIndexIn(List<TestOutcome> outcomes) {
        return this.firstFailingStepIndexIn(outcomes, 0);
    }

    private int firstFailingStepIndexIn(List<TestOutcome> outcomes, int backgroundStepCount) {
        return outcomes.stream().map(TestOutcome::getFirstFailingStepIndex).filter(index -> index >= 0).map(index -> index - backgroundStepCount).filter(index -> index >= 0).findFirst().orElse(-1);
    }

    private int countBackgroundStepsIn(Feature feature) {
        return feature.getChildren().stream().filter(child -> child.getBackground() != null && child.getBackground().isPresent()).findFirst().map(child -> ((Background)child.getBackground().get()).getSteps().size()).orElse(0);
    }

    private ScenarioOutcome scenarioOutcomeFrom(Feature feature, Scenario scenario, TestOutcomes testOutcomes, net.thucydides.model.domain.Rule rule) {
        List<TestOutcome> outcomes = testOutcomes.testOutcomesWithName(scenario.getName());
        String scenarioTitle = scenario.getName();
        TestResult result = outcomes.isEmpty() ? TestResult.UNDEFINED : TestResultList.overallResultFrom(outcomes.stream().map(TestOutcome::getResult).collect(Collectors.toList()));
        List<String> reportBadges = ReportBadges.from(outcomes, scenario.getName());
        String featureReport = new ReportNameProvider().forRequirement(feature.getName(), "feature");
        Optional<String> scenarioReport = outcomes.isEmpty() ? Optional.empty() : Optional.of(outcomes.get(0).getHtmlReport());
        List<String> renderedSteps = scenario.getSteps().stream().map(RenderCucumber::step).collect(Collectors.toList());
        ArrayList<Examples> filteredExamples = new ArrayList<Examples>();
        HashMap<String, Collection<TestTag>> exampleTags = new HashMap<String, Collection<TestTag>>();
        if (this.scenarioContainsExamples(scenario)) {
            List examples2 = scenario.getExamples();
            examples2.stream().filter(example -> example.getTags().isEmpty() || this.tagScanner.shouldRunForTags(CucumberTagConverter.fromGherkinTags(example.getTags()))).forEach(filteredExamples::add);
            Set<TestTag> scenarioOutlineTags = this.scenarioOutlineTagsIn(scenario);
            examples2.forEach(example -> {
                Collection<TestTag> testTags = CucumberTagConverter.toSerenityTags(example.getTags());
                testTags.addAll(scenarioOutlineTags);
                exampleTags.put(example.getName() + ":" + String.valueOf(example.getLocation()), testTags);
            });
        }
        ArrayList<String> renderedExamples = this.scenarioContainsExamples(scenario) ? RenderCucumber.examples(filteredExamples, feature.getName()) : new ArrayList();
        ArrayList<ExampleOutcome> exampleOutcomes = new ArrayList<ExampleOutcome>();
        for (TestOutcome outcome2 : outcomes) {
            exampleOutcomes.addAll(ExampleOutcomes.from(outcome2));
        }
        int exampleCount = this.scenarioContainsExamples(scenario) ? filteredExamples.stream().mapToInt(examples -> examples.getTableBody().size()).sum() : 0;
        Boolean isManual = outcomes.size() == 1 ? outcomes.get(0).isManual() : this.hasManualTag(feature.getTags()).booleanValue();
        Set<TestTag> outcomeTags = outcomes.stream().flatMap(outcome -> outcome.getTags().stream()).collect(Collectors.toSet());
        Set<TestTag> scenarioTags = this.scenarioTagsDefinedIn(scenario);
        outcomeTags.addAll(scenarioTags);
        int backgroundStepCount = this.countBackgroundStepsIn(feature);
        return new ScenarioSummaryOutcome(scenarioTitle, scenario.getKeyword(), result, reportBadges, scenarioReport.orElse(""), scenario.getDescription(), renderedSteps, renderedExamples, exampleOutcomes, exampleCount, isManual, feature.getName(), featureReport, outcomeTags, exampleTags, rule, this.startTimeOfFirstTestIn(outcomes), this.totalDurationOf(outcomes), scenarioTags, this.firstContextIn(testOutcomes), this.firstFailingStepIndexIn(outcomes, backgroundStepCount));
    }

    private Set<TestTag> scenarioTagsDefinedIn(Scenario scenario) {
        if (this.scenarioContainsExamples(scenario)) {
            return this.scenarioOutlineTagsIncludingExamplesIn(scenario);
        }
        return this.scenarioTagsIn(scenario);
    }

    private String firstContextIn(TestOutcomes testOutcomes) {
        return testOutcomes.getOutcomes().stream().filter(testOutcome -> StringUtils.isNotEmpty((CharSequence)testOutcome.getContext())).map(testOutcome -> testOutcome.getContext()).findFirst().orElse("");
    }

    private boolean scenarioContainsExamples(Scenario scenario) {
        return !scenario.getExamples().isEmpty();
    }

    private Set<TestTag> scenarioOutlineTagsIn(Scenario scenarioOutline) {
        return scenarioOutline.getTags().stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
    }

    private Set<TestTag> scenarioOutlineTagsIncludingExamplesIn(Scenario scenarioOutline) {
        Set<TestTag> testTags = this.scenarioOutlineTagsIn(scenarioOutline);
        Set exampleTags = scenarioOutline.getExamples().stream().flatMap(examples -> examples.getTags().stream()).map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
        testTags.addAll(exampleTags);
        return testTags;
    }

    private Set<TestTag> scenarioTagsIn(Scenario scenario) {
        return scenario.getTags().stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
    }

    private Boolean hasManualTag(List<Tag> tags) {
        return tags.stream().anyMatch(tag -> tag.getName().toLowerCase().startsWith("@manual"));
    }

    private File pathFromResourceOnClasspath(String path) {
        String featureFile = path + ".feature";
        URL featureFileURL = this.getClass().getClassLoader().getResource(this.featuresDirectory() + "/" + featureFile);
        String featureFilePath = featureFileURL != null ? featureFileURL.getFile() : new File("src/test/resources/" + this.featuresDirectory() + "/" + featureFile).getAbsolutePath();
        return featureFilePath == null ? null : new File(featureFilePath);
    }

    private String featuresDirectory() {
        return ThucydidesSystemProperty.SERENITY_FEATURES_DIRECTORY.from(this.environmentVariables, "features");
    }
}

