/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.thucydides.model.requirements.model.Requirement;

public class RequirementsList {
    private final List<Requirement> requirements;

    protected RequirementsList(List<Requirement> requirements) {
        this.requirements = requirements;
    }

    public static RequirementsList of(List<Requirement> requirements) {
        return new RequirementsList(requirements);
    }

    protected int maxDepth() {
        if (this.requirements.isEmpty()) {
            return 0;
        }
        int maxDepth = 1;
        for (Requirement requirement : this.requirements) {
            maxDepth = Math.max(1 + RequirementsList.of(requirement.getChildren()).maxDepth(), maxDepth);
        }
        return maxDepth;
    }

    public List<Requirement> asFlattenedList() {
        ArrayList<Requirement> flattenedRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : this.requirements) {
            flattenedRequirements.add(requirement);
            if (!requirement.hasChildren()) continue;
            flattenedRequirements.addAll(RequirementsList.of(requirement.getChildren()).asFlattenedList());
        }
        return flattenedRequirements;
    }

    public Optional<Requirement> findByUniqueName(String name) {
        Requirement matchingRequirement = null;
        for (Requirement requirement : this.asFlattenedList()) {
            if (!requirement.getName().equalsIgnoreCase(name)) continue;
            if (matchingRequirement != null) {
                return Optional.empty();
            }
            matchingRequirement = requirement;
        }
        return Optional.ofNullable(matchingRequirement);
    }
}

