/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.model.cucumber;

import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Tag;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thucydides.model.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.model.requirements.model.cucumber.CucumberParser;
import net.thucydides.model.requirements.model.cucumber.FeatureFileAnaysisErrors;
import net.thucydides.model.requirements.model.cucumber.InvalidFeatureFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureFileChecker {
    CucumberParser cucumberParser = new CucumberParser();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureFileChecker.class);

    public void check(Stream<File> files, boolean allowDuplicateFeatureNames) {
        ArrayList<String> featureFileNames = new ArrayList<String>();
        ConcurrentHashMap pathNamesToFeatureFiles = new ConcurrentHashMap();
        TreeMap featureFileToResult = new TreeMap();
        List errorMessages = files.filter(File::isFile).map(featureFile -> {
            try {
                Optional<AnnotatedFeature> loadedFeature = this.cucumberParser.loadFeature((File)featureFile);
                loadedFeature.ifPresent(annotatedFeature -> {
                    FeatureFileChecker.recordFeaturePath(pathNamesToFeatureFiles, featureFile, annotatedFeature);
                    featureFileNames.add(annotatedFeature.getFeature().getName());
                    this.checkTagsIn(annotatedFeature.getFeature());
                });
                return Optional.empty();
            }
            catch (Throwable invalidFeatureFile) {
                return Optional.of("* Error found in feature file: " + this.shortenedFeatureFilePath(featureFile.getAbsolutePath()) + System.lineSeparator() + " -> " + invalidFeatureFile.getMessage());
            }
        }).filter(Optional::isPresent).map(Optional::get).map(Object::toString).distinct().collect(Collectors.toList());
        if (!allowDuplicateFeatureNames) {
            errorMessages.addAll(this.checkForDuplicateFeatureNames(featureFileNames));
        }
        if (!errorMessages.isEmpty()) {
            throw new InvalidFeatureFileException("INVALID FEATURE FILES FOUND:" + System.lineSeparator() + errorMessages.stream().collect(Collectors.joining(System.lineSeparator())));
        }
    }

    private String shortenedFeatureFilePath(String absolutePath) {
        return absolutePath.contains("/features/") ? absolutePath.substring(absolutePath.indexOf("/features/") + 10) : absolutePath;
    }

    private void checkTagsIn(Feature feature) {
        this.checkTags(feature.getTags());
        feature.getChildren().forEach(child -> {
            if (child.getScenario().isPresent()) {
                this.checkTagsInScenario((Scenario)child.getScenario().get());
            } else if (child.getRule().isPresent()) {
                this.checkTagsInRule((Rule)child.getRule().get());
            }
        });
    }

    private void checkTagsInScenario(Scenario scenario) {
        this.checkTags(scenario.getTags());
        if (!scenario.getExamples().isEmpty()) {
            List<Tag> exampleTags = scenario.getExamples().stream().flatMap(examples -> examples.getTags().stream()).collect(Collectors.toList());
            this.checkTags(exampleTags);
        }
    }

    private void checkTagsInRule(Rule rule) {
        this.checkTags(rule.getTags());
        rule.getChildren().forEach(child -> {
            if (child.getScenario().isPresent()) {
                this.checkTagsInScenario((Scenario)child.getScenario().get());
            }
        });
    }

    private void checkTags(List<Tag> tags) {
        for (Tag tag : tags) {
            if (tag.getName().trim().endsWith(":")) {
                throw new InvalidFeatureFileException("Invalid tag format at " + String.valueOf(tag.getLocation()) + " - tags in the format <name>:<value> (e.g. '@color:red') must have a value after the colon");
            }
            if (!tag.getName().trim().endsWith("=")) continue;
            throw new InvalidFeatureFileException("Invalid tag format at " + String.valueOf(tag.getLocation()) + " - tags in the format <name>=<value> (e.g. '@color=red') must have a value after the equals sign");
        }
    }

    private Collection<String> checkForDuplicateFeatureNames(List<String> featureFileNames) {
        return featureFileNames.stream().collect(Collectors.groupingBy(name -> name)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> "Duplicate feature name found: '" + (String)entry.getKey() + "'").collect(Collectors.toList());
    }

    private String duplicateFeaturePathsError(String key, List<File> value) {
        String featureFilesWithDuplicates = value.stream().map(file -> "      - " + file.getPath()).collect(Collectors.joining(System.lineSeparator()));
        return String.format("* " + FeatureFileAnaysisErrors.DUPLICATE_FEATURE_NAME, key, featureFilesWithDuplicates);
    }

    private static void recordFeaturePath(ConcurrentHashMap<String, List<File>> pathNamesToFeatureFiles, File featureFile, AnnotatedFeature loadedFeature) {
        String featureName = loadedFeature.getFeature().getName();
        String parentName = new File(featureFile.getParent()).getName();
        String localFeaturePath = parentName + "/" + featureName;
        if (pathNamesToFeatureFiles.containsKey(localFeaturePath)) {
            pathNamesToFeatureFiles.get(localFeaturePath).add(featureFile);
        } else {
            ArrayList<File> featureFiles = new ArrayList<File>();
            featureFiles.add(featureFile);
            pathNamesToFeatureFiles.put(localFeaturePath, featureFiles);
        }
    }
}

