/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.adapters.legacy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.annotations.TestAnnotations;
import net.serenitybdd.annotations.Title;
import net.serenitybdd.annotations.WithTag;
import net.serenitybdd.annotations.WithTagValuesOf;
import net.serenitybdd.annotations.WithTags;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.adapters.JUnitStrategy;
import net.thucydides.model.domain.TestTag;

class DefaultJUnitStrategy
implements JUnitStrategy {
    private final List<String> LEGAL_SERENITY_RUNNER_NAMES = NewList.of("SerenityRunner", "ThucydidesRunner", "SerenityParameterizedRunner", "ThucydidesParameterizedRunner");
    private static final List<String> TAGGABLE_RUNNER_CLASSES = Arrays.asList("SerenityRunner", "SerenityParameterizedRunner", "net.serenitybdd.junit5.JUnitAdapterUnitTest.InternalRunner", "net.serenitybdd.junit.runners.TestClassRunnerForInstanciatedTestCase", "net.serenitybdd.junit.runners.TestClassRunnerForParameters", "net.serenitybdd.junit.spring.integration.SpringIntegrationSerenityRunner");

    @Override
    public boolean isTestClass(Class<?> testClass) {
        return DefaultJUnitStrategy.containsAnnotationCalled(testClass.getAnnotations(), "RunWith") || this.hasMethodWithTestAnnotation(testClass);
    }

    private boolean hasMethodWithTestAnnotation(Class<?> testClass) {
        return Arrays.stream(testClass.getMethods()).anyMatch(this::isTestMethod) || Arrays.stream(testClass.getDeclaredMethods()).anyMatch(this::isTestMethod);
    }

    @Override
    public boolean isTestMethod(Method method) {
        return Arrays.stream(method.getAnnotations()).anyMatch(annotation -> annotation.annotationType().getSimpleName().equals("Test"));
    }

    @Override
    public boolean isTestSetupMethod(Method method) {
        return DefaultJUnitStrategy.containsAnnotationCalled(method.getAnnotations(), "Before") || DefaultJUnitStrategy.containsAnnotationCalled(method.getAnnotations(), "BeforeClass");
    }

    private Optional<String> runWithValue(Class<?> testClass) {
        Optional<Method> valueMethod;
        Optional<Annotation> runWith = Arrays.stream(testClass.getAnnotations()).filter(annotation -> annotation.annotationType().getSimpleName().equals("RunWith")).findAny();
        if (runWith.isPresent() && (valueMethod = Arrays.stream(runWith.get().getClass().getMethods()).filter(method -> method.getName().equals("value")).findFirst()).isPresent()) {
            try {
                return Optional.of(valueMethod.get().invoke((Object)runWith.get(), new Object[0]).toString());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return Optional.empty();
    }

    @Override
    public boolean isSerenityTestCase(Class<?> testClass) {
        Optional<String> runWith = this.runWithValue(testClass);
        if (runWith.isPresent()) {
            String[] classElts = runWith.get().split("\\.");
            String className = classElts[classElts.length - 1];
            return this.LEGAL_SERENITY_RUNNER_NAMES.contains(className);
        }
        return false;
    }

    @Override
    public boolean isAssumptionViolatedException(Throwable throwable) {
        return throwable.getClass().getSimpleName().contains("AssumptionViolatedException");
    }

    @Override
    public boolean isATaggableClass(Class<?> testClass) {
        Optional<String> runWithValue = this.runWithValue(testClass);
        if (runWithValue.isPresent()) {
            return TAGGABLE_RUNNER_CLASSES.stream().anyMatch(taggableClass -> ((String)runWithValue.get()).endsWith((String)taggableClass));
        }
        return false;
    }

    @Override
    public boolean isIgnored(Method method) {
        Annotation[] annotations = method.getAnnotations();
        return Arrays.stream(annotations).anyMatch(annotation -> annotation.annotationType().getSimpleName().equals("Ignore"));
    }

    @Override
    public Optional<String> getTitleAnnotation(Method testMethod) {
        Title titleAnnotation = testMethod.getAnnotation(Title.class);
        if (titleAnnotation != null) {
            return Optional.of(titleAnnotation.value());
        }
        return Optional.empty();
    }

    @Override
    public List<TestTag> getTagsFor(Method testMethod) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        TestAnnotations.addTagValues(tags, testMethod.getAnnotation(WithTagValuesOf.class));
        TestAnnotations.addTags(tags, testMethod.getAnnotation(WithTags.class));
        TestAnnotations.addTag(tags, testMethod.getAnnotation(WithTag.class));
        return tags;
    }

    private static boolean containsAnnotationCalled(Annotation[] annotations, String annotationName) {
        return Arrays.stream(annotations).anyMatch(annotation -> annotation.annotationType().getSimpleName().equals(annotationName));
    }
}

