/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import com.google.common.base.Splitter;
import com.google.gson.Gson;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import io.cucumber.tagexpressions.Expression;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestResultList;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.reports.html.ResultIconFormatter;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.model.TagParser;
import net.thucydides.model.requirements.reports.RequirementOutcome;
import net.thucydides.model.requirements.reports.RequirementsOutcomes;
import net.thucydides.model.requirements.tree.Node;
import net.thucydides.model.util.Inflector;
import net.thucydides.model.util.NameConverter;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;

public class JSONRequirementsTree {
    private final List<Node> nodes;
    private final List<String> tags;
    private final boolean displayAsParent;
    private final boolean hideEmptyRequirements;
    private final Gson gson = new Gson();
    private static Parser PARSER = Parser.builder().build();
    private static HtmlRenderer RENDERER = HtmlRenderer.builder().build();

    private JSONRequirementsTree(List<Node> nodes, boolean displayAsParent, List<String> tags) {
        this.hideEmptyRequirements = EnvironmentSpecificConfiguration.from(SystemEnvironmentVariables.currentEnvironmentVariables()).getBooleanProperty(ThucydidesSystemProperty.SERENITY_REPORT_HIDE_EMPTY_REQUIREMENTS, true);
        this.nodes = nodes;
        this.displayAsParent = displayAsParent;
        this.tags = tags;
    }

    public JSONRequirementsTree(List<Requirement> requirements, RequirementsOutcomes requirementsOutcomes, String tagsExpression) {
        this.hideEmptyRequirements = EnvironmentSpecificConfiguration.from(SystemEnvironmentVariables.currentEnvironmentVariables()).getBooleanProperty(ThucydidesSystemProperty.SERENITY_REPORT_HIDE_EMPTY_REQUIREMENTS, true);
        this.tags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)tagsExpression);
        this.nodes = requirements.stream().filter(requirement -> this.shouldShow((Requirement)requirement, requirementsOutcomes)).map(requirement -> this.toNode((Requirement)requirement, requirementsOutcomes)).sorted().collect(Collectors.toList());
        this.displayAsParent = false;
    }

    private boolean shouldShow(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        List tagsForThisRequirement;
        Expression expression;
        if (!this.tags.isEmpty() && !(expression = TagParser.parseFromTagFilters(this.tags)).evaluate(tagsForThisRequirement = requirement.getAggregateTags().stream().map(testTag -> this.rawTagStringOrName((TestTag)testTag)).map(tag -> this.addTagPrefixTo((String)tag)).collect(Collectors.toList()))) {
            return false;
        }
        if (!this.hideEmptyRequirements) {
            return true;
        }
        return requirementsOutcomes.requirementOutcomeFor(requirement).getTestCount() > 0L;
    }

    private String rawTagStringOrName(TestTag tag) {
        if (StringUtils.isNotEmpty((CharSequence)tag.getRawStringFromValueTag())) {
            return tag.getRawStringFromValueTag();
        }
        return tag.getName();
    }

    private String addTagPrefixTo(String tag) {
        return tag.startsWith("@") ? tag : "@" + tag;
    }

    public static JSONRequirementsTree forRequirements(List<Requirement> requirements, RequirementsOutcomes requirementsOutcomes, String tags) {
        return new JSONRequirementsTree(requirements, requirementsOutcomes, tags);
    }

    private Node toNode(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        List<Node> children = requirement.getChildren().stream().filter(childRequirement -> this.shouldShow((Requirement)childRequirement, requirementsOutcomes)).map(child -> this.toNode((Requirement)child, requirementsOutcomes)).distinct().sorted().collect(Collectors.toList());
        TestResult result = this.matchingOutcome(requirement, requirementsOutcomes).orElse(TestResult.UNDEFINED);
        String label = new ResultIconFormatter().forResult(result, "#");
        String childCount = children.isEmpty() ? this.countScenariosIn(requirement, requirementsOutcomes) : this.countChildRequirementsIn(requirement) + " " + this.countScenariosIn(requirement, requirementsOutcomes);
        String report = new ReportNameProvider().forRequirement(requirement);
        String requirementName = NameConverter.humanize(JSONRequirementsTree.getRequirementNameFrom(requirement));
        return new Node(requirementName, requirement.getType(), report, label, childCount, children);
    }

    @NotNull
    private static String getRequirementNameFrom(Requirement requirement) {
        Document document = PARSER.parse(requirement.getDisplayName());
        return Jsoup.parse((String)RENDERER.render((com.vladsch.flexmark.util.ast.Node)document)).text();
    }

    private String countChildRequirementsIn(Requirement requirement) {
        Inflector inflection = Inflector.getInstance();
        return "<span class='feature-count'>" + requirement.getChildren().size() + " " + inflection.of(requirement.getChildren().size()).times(requirement.getChildren().get(0).getType()).inPluralForm().toString() + "</span>";
    }

    private String countScenariosIn(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        Inflector inflection = Inflector.getInstance();
        long scenarioCount = this.scenariosUnder(requirement, requirementsOutcomes);
        if (scenarioCount == 0L) {
            return "";
        }
        String scenarioCountText = "<span class='feature-count'>" + scenarioCount + " " + inflection.of(scenarioCount).times("scenario").inPluralForm().toString() + "</span>";
        long testCaseCount = this.testCasesUnder(requirement, requirementsOutcomes);
        String testCaseCountText = "<span class='feature-count'>" + testCaseCount + " " + inflection.of(testCaseCount).times("test case").inPluralForm().toString() + "</span>";
        return scenarioCountText + ", " + testCaseCountText;
    }

    private long scenariosUnder(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        return requirementsOutcomes.getTestOutcomes().directlyUnder(requirement).getScenarioCount();
    }

    private long testCasesUnder(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        return requirementsOutcomes.getTestOutcomes().directlyUnder(requirement).getTestCaseCount();
    }

    private Optional<TestResult> matchingOutcome(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        if (requirementsOutcomes == null) {
            return Optional.empty();
        }
        Optional<RequirementOutcome> matchingOutcome = this.testOutcomeForRequirement(requirement, requirementsOutcomes);
        if (matchingOutcome.isPresent()) {
            if (matchingOutcome.get().getTestOutcomes().getTotal() == 0) {
                return Optional.of(TestResult.PENDING);
            }
            if (this.unimplementedFeaturesExistFor(matchingOutcome.get(), requirementsOutcomes)) {
                return Optional.of(TestResultList.overallResultFrom(Arrays.asList(TestResult.PENDING, matchingOutcome.get().getTestOutcomes().getResult())));
            }
            return Optional.of(matchingOutcome.get().getTestOutcomes().getResult());
        }
        return Optional.empty();
    }

    private Optional<RequirementOutcome> testOutcomeForRequirement(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        if (requirementsOutcomes.getParentRequirement().isPresent() && requirement.equals(requirementsOutcomes.getParentRequirement().get())) {
            return Optional.of(requirementsOutcomes.requirementOutcomeFor(requirement));
        }
        if (requirementsOutcomes.getRequirements().contains(requirement)) {
            return requirementsOutcomes.getOutcomeFor(requirement);
        }
        return requirementsOutcomes.getFlattenedRequirementOutcomes().stream().filter(outcome -> outcome.getRequirement().equals(requirement)).findFirst();
    }

    private boolean unimplementedFeaturesExistFor(RequirementOutcome matchingOutcome, RequirementsOutcomes requirementsOutcomes) {
        return matchingOutcome.getFlattenedRequirements(matchingOutcome.getRequirement()).stream().anyMatch(requirement -> this.noTestsExistFor((Requirement)requirement, requirementsOutcomes));
    }

    private boolean noTestsExistFor(Requirement requirement, RequirementsOutcomes requirementsOutcomes) {
        Optional<RequirementOutcome> requirementOutcome = this.testOutcomeForRequirement(requirement, requirementsOutcomes);
        return !requirementOutcome.isPresent() || requirementOutcome.get().getTestOutcomes().getTotal() == 0;
    }

    public String asString() {
        return this.gson.toJson(this.nodes);
    }

    public JSONRequirementsTree asAParentRequirement() {
        return new JSONRequirementsTree(this.nodes, true, this.tags);
    }

    public Boolean isALeafNode() {
        return !this.displayAsParent && this.nodes.size() == 1 && this.nodes.get(0).getNodes().isEmpty();
    }
}

