/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.csv;

import com.google.common.base.Splitter;
import com.opencsv.CSVWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.reports.TestOutcomes;
import net.thucydides.model.reports.ThucydidesReporter;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.util.Inflector;

public class CSVReporter
extends ThucydidesReporter {
    private static final String[] TITLE_LINE = new String[]{"Story", "Title", "Result", "Date", "Stability", "Duration (s)"};
    private static final String[] OF_STRINGS = new String[0];
    private final List<String> extraColumns;
    private final String encoding;

    public CSVReporter(File outputDirectory) {
        this(outputDirectory, SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public CSVReporter(File outputDirectory, EnvironmentVariables environmentVariables) {
        this.setOutputDirectory(outputDirectory);
        this.extraColumns = this.extraColumnsDefinedIn(environmentVariables);
        this.encoding = ThucydidesSystemProperty.SERENITY_REPORT_ENCODING.from(environmentVariables, StandardCharsets.UTF_8.name());
    }

    private List<String> extraColumnsDefinedIn(EnvironmentVariables environmentVariables) {
        String columns = ThucydidesSystemProperty.SERENITY_CSV_EXTRA_COLUMNS.from(environmentVariables, "");
        return Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)columns);
    }

    public File generateReportFor(TestOutcomes testOutcomes, String reportName) throws IOException {
        try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(this.getOutputFile(reportName)), this.encoding));){
            this.writeTitleRow(writer);
            this.writeEachRow(testOutcomes, writer);
        }
        return this.getOutputFile(reportName);
    }

    private void writeTitleRow(CSVWriter writer) {
        Inflector inflector = Inflector.getInstance();
        ArrayList<String> titles = new ArrayList<String>();
        titles.addAll(Arrays.asList(TITLE_LINE));
        for (String extraColumn : this.extraColumns) {
            titles.add(inflector.of(extraColumn).asATitle().toString());
        }
        writer.writeNext(titles.toArray(OF_STRINGS));
    }

    private void writeEachRow(TestOutcomes testOutcomes, CSVWriter writer) {
        for (TestOutcome testOutcome : testOutcomes.getTests()) {
            writer.writeNext(this.withRowDataFrom(testOutcome));
        }
    }

    private Double passRateFor(TestOutcome outcome) {
        return 0.0;
    }

    private String[] withRowDataFrom(TestOutcome outcome) {
        List<Serializable> defaultValues = NewList.of(new Serializable[]{this.blankIfNull(outcome.getStoryTitle()), this.blankIfNull(outcome.getTitle()), outcome.getResult(), this.blankIfNull(outcome.getTimestamp(DateTimeFormatter.ISO_ZONED_DATE_TIME)), this.passRateFor(outcome), Double.valueOf(outcome.getDurationInSeconds())});
        List<String> cellValues = defaultValues.stream().map(Object::toString).collect(Collectors.toList());
        cellValues.addAll(this.extraValuesFrom(outcome));
        return cellValues.toArray(OF_STRINGS);
    }

    private String blankIfNull(String value) {
        return Optional.ofNullable(value).orElse("");
    }

    private Collection<String> extraValuesFrom(TestOutcome outcome) {
        ArrayList<String> extraValues = new ArrayList<String>();
        for (String extraColumn : this.extraColumns) {
            extraValues.add(outcome.getTagValue(extraColumn).orElse(""));
        }
        return extraValues;
    }

    private File getOutputFile(String reportName) {
        return new File(this.getOutputDirectory(), reportName);
    }
}

