/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.steps;

import java.util.Arrays;
import net.serenitybdd.model.exceptions.SerenityManagedException;
import net.thucydides.model.steps.ExecutedStepDescription;

public class StepFailure {
    private final ExecutedStepDescription description;
    private final Throwable cause;
    private final Class<? extends Throwable> exceptionClass;
    private final String message;
    private final StackTraceElement[] stackTraceElements;

    public StepFailure(ExecutedStepDescription description, Throwable cause) {
        this.description = description;
        this.cause = cause;
        if (cause != null) {
            if (cause instanceof SerenityManagedException) {
                this.exceptionClass = ((SerenityManagedException)cause).getExceptionClass();
                this.message = cause.getMessage();
                this.stackTraceElements = cause.getStackTrace();
            } else {
                this.exceptionClass = cause.getClass();
                this.message = cause.getMessage();
                this.stackTraceElements = cause.getStackTrace();
            }
        } else {
            this.exceptionClass = null;
            this.message = null;
            this.stackTraceElements = null;
        }
    }

    public ExecutedStepDescription getDescription() {
        return this.description;
    }

    public Throwable getException() {
        return this.cause;
    }

    public String getMessage() {
        return this.message;
    }

    public Class<? extends Throwable> getExceptionClass() {
        return this.exceptionClass;
    }

    public StackTraceElement[] getStackTraceElements() {
        return Arrays.copyOf(this.stackTraceElements, this.stackTraceElements.length);
    }
}

