/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.model.cucumber;

import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.model.requirements.model.cucumber.ExampleRowResultIcon;
import net.thucydides.model.requirements.model.cucumber.RowResultIcon;
import org.apache.commons.lang3.StringUtils;

public class RenderedExampleTable {
    public static String nameFor(Examples exampleTable) {
        return RenderedExampleTable.emptyStringOrValueOf(exampleTable.getName());
    }

    public static String descriptionFor(Examples exampleTable) {
        return RenderedExampleTable.emptyStringOrValueOf(exampleTable.getDescription());
    }

    private static String emptyStringOrValueOf(String description) {
        if (StringUtils.isEmpty((CharSequence)description)) {
            return "";
        }
        return description + System.lineSeparator();
    }

    public static String renderedTable(Examples exampleTable, ExampleRowResultIcon exampleRowIcon) {
        Map<Integer, Integer> maxColumnWidths = RenderedExampleTable.maxColumnWidthForColumnsIn(exampleTable);
        ArrayList tableCells = new ArrayList();
        String headings = RenderedExampleTable.cellRow(((TableRow)exampleTable.getTableHeader().get()).getCells(), maxColumnWidths, exampleTable.getLocation().getLine(), exampleRowIcon.noIcon()) + RenderedExampleTable.headerSeparator(maxColumnWidths);
        String body = exampleTable.getTableBody().stream().map(row -> RenderedExampleTable.cellRow(row.getCells(), maxColumnWidths, row.getLocation().getLine(), exampleRowIcon)).collect(Collectors.joining());
        return headings + body;
    }

    private static String headerSeparator(Map<Integer, Integer> maxColumnWidths) {
        StringBuilder headerSeparator = new StringBuilder("|");
        for (int column = 0; column < maxColumnWidths.size(); ++column) {
            headerSeparator.append(StringUtils.repeat((String)"-", (int)(maxColumnWidths.get(column) + 2))).append("|");
        }
        return String.valueOf(headerSeparator) + "---|" + System.lineSeparator();
    }

    public static String cellRow(List<TableCell> cells, Map<Integer, Integer> maxColumnWidths, long lineNumber, RowResultIcon exampleRowResultIcons) {
        StringBuilder headerRow = new StringBuilder("|");
        for (int column = 0; column < cells.size(); ++column) {
            String columnHeading = cells.get(column).getValue();
            int columnWidth = maxColumnWidths.get(column) + 1;
            headerRow.append(StringUtils.rightPad((String)(" " + columnHeading), (int)columnWidth)).append(" |");
        }
        headerRow.append(exampleRowResultIcons.resultToken(lineNumber)).append("|");
        return String.valueOf(headerRow) + System.lineSeparator();
    }

    private static Map<Integer, Integer> maxColumnWidthForColumnsIn(Examples exampleTable) {
        HashMap<Integer, Integer> maxColumnWidth = new HashMap<Integer, Integer>();
        int columnCount = ((TableRow)exampleTable.getTableHeader().get()).getCells().size();
        for (int column = 0; column < columnCount; ++column) {
            maxColumnWidth.put(column, RenderedExampleTable.maxColumnWidthFor(exampleTable, column));
        }
        return maxColumnWidth;
    }

    private static Integer maxColumnWidthFor(Examples exampleTable, int column) {
        int headerWidth = ((TableCell)((TableRow)exampleTable.getTableHeader().get()).getCells().get(column)).getValue().length();
        int maxCellWidth = exampleTable.getTableBody().stream().mapToInt(row -> ((TableCell)row.getCells().get(column)).getValue().length()).max().orElse(0);
        return Math.max(headerWidth, maxCellWidth);
    }
}

