/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.json.gson;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

public class OptionalTypeAdapter<E>
extends TypeAdapter<Optional<E>> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class rawType = type.getRawType();
            if (rawType != Optional.class) {
                return null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type.getType();
            Type actualType = parameterizedType.getActualTypeArguments()[0];
            TypeAdapter adapter = gson.getAdapter(TypeToken.get((Type)actualType));
            return new OptionalTypeAdapter(adapter);
        }
    };
    private final TypeAdapter<E> adapter;

    public OptionalTypeAdapter(TypeAdapter<E> adapter) {
        this.adapter = adapter;
    }

    public void write(JsonWriter out, Optional<E> value) throws IOException {
        if (value != null && value.isPresent()) {
            this.adapter.write(out, value.get());
        } else {
            out.nullValue();
        }
    }

    public Optional<E> read(JsonReader in) throws IOException {
        in.setLenient(true);
        JsonToken peek = in.peek();
        if (peek != JsonToken.NULL) {
            return Optional.ofNullable(this.adapter.read(in));
        }
        return Optional.empty();
    }
}

