/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.matchers;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.thucydides.model.matchers.BeanCollectionMatcher;
import net.thucydides.model.matchers.BeanCountMatcher;
import net.thucydides.model.matchers.BeanFieldMatcher;
import net.thucydides.model.matchers.BeanMatcher;
import net.thucydides.model.matchers.BeanMatchers;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class BeanMatcherAsserts {
    private static final String NEW_LINE = System.getProperty("line.separator");

    public static <T> boolean matches(List<T> elements, BeanMatcher ... matchers) {
        List<T> filteredElements = BeanMatcherAsserts.filterElements(elements, matchers);
        return BeanMatcherAsserts.apply(filteredElements, BeanMatcherAsserts.collectionMatchersIn(matchers));
    }

    private static <T> boolean apply(List<T> elements, List<BeanCollectionMatcher> matchers) {
        List<BeanCollectionMatcher> collectionMatchers = BeanMatcherAsserts.addEmptyTestIfNoCountChecksArePresentTo(matchers);
        for (BeanCollectionMatcher matcher : collectionMatchers) {
            if (matcher.matches(elements)) continue;
            return false;
        }
        return true;
    }

    private static List<BeanCollectionMatcher> addEmptyTestIfNoCountChecksArePresentTo(List<BeanCollectionMatcher> matchers) {
        if (BeanMatcherAsserts.thereIsACardinalityConstraintSpecifiedInThe(matchers)) {
            return matchers;
        }
        return BeanMatcherAsserts.mustContainAtLeastOneItemMatching(matchers);
    }

    public static <E> List<E> union(List<? extends E> list1, List<? extends E> list2) {
        ArrayList<E> result = new ArrayList<E>(list1.size() + list2.size());
        result.addAll(list1);
        result.addAll(list2);
        return result;
    }

    private static List mustContainAtLeastOneItemMatching(List<BeanCollectionMatcher> matchers) {
        return BeanMatcherAsserts.union(matchers, Arrays.asList(BeanMatchers.the_count((Matcher<Integer>)Matchers.is((Matcher)Matchers.not((Object)0)))));
    }

    private static boolean thereIsACardinalityConstraintSpecifiedInThe(List<BeanCollectionMatcher> matchers) {
        for (BeanCollectionMatcher matcher : matchers) {
            if (!(matcher instanceof BeanCountMatcher)) continue;
            return true;
        }
        return false;
    }

    private static List<BeanCollectionMatcher> collectionMatchersIn(BeanMatcher[] matchers) {
        List compatibleMatchers = Arrays.stream(matchers).filter(matcher -> matcher instanceof BeanCollectionMatcher).collect(Collectors.toList());
        return compatibleMatchers.stream().map(matcher -> (BeanCollectionMatcher)matcher).collect(Collectors.toList());
    }

    public static <T> List<T> filterElements(List<T> elements, BeanMatcher ... matchers) {
        List<BeanFieldMatcher> propertyMatchers = BeanMatcherAsserts.propertyMatchersIn(matchers);
        return elements.stream().filter(element -> BeanMatcherAsserts.elementMatches(element, propertyMatchers)).collect(Collectors.toList());
    }

    private static <T> boolean elementMatches(T element, List<BeanFieldMatcher> propertyMatchers) {
        return propertyMatchers.stream().allMatch(propertyMatcher -> propertyMatcher.matches(element));
    }

    private static List<BeanFieldMatcher> propertyMatchersIn(BeanMatcher[] matchers) {
        List compatibleMatchers = Arrays.stream(matchers).filter(matcher -> matcher instanceof BeanFieldMatcher).collect(Collectors.toList());
        return compatibleMatchers.stream().map(matcher -> (BeanFieldMatcher)matcher).collect(Collectors.toList());
    }

    public static <T> void shouldMatch(List<T> items, BeanMatcher ... matchers) {
        if (!BeanMatcherAsserts.matches(items, matchers)) {
            throw new AssertionError((Object)("Failed to find matching elements for " + StringUtils.join((Object[])matchers) + NEW_LINE + "Elements where " + StringUtils.join((Object[])new List[]{items})));
        }
    }

    public static <T> void shouldMatch(T bean, BeanMatcher ... matchers) {
        if (!BeanMatcherAsserts.matches(bean, matchers)) {
            throw new AssertionError((Object)("Expected " + Arrays.toString(matchers) + " but was " + BeanMatcherAsserts.descriptionOf(bean)));
        }
    }

    public static <T> void shouldNotMatch(List<T> items, BeanMatcher ... matchers) {
        if (BeanMatcherAsserts.matches(items, matchers)) {
            throw new AssertionError((Object)("Found unneeded matching elements for " + StringUtils.join((Object[])matchers) + NEW_LINE + "Elements where " + StringUtils.join((Object[])new List[]{items})));
        }
    }

    private static String descriptionOf(Object bean) {
        if (BeanMatcherAsserts.isAMap(bean)) {
            return BeanMatcherAsserts.mapDescription((Map)bean);
        }
        return BeanMatcherAsserts.beanDescription(bean);
    }

    private static String beanDescription(Object bean) {
        ArrayList<String> propertyTerms = new ArrayList<String>();
        try {
            for (PropertyDescriptor descriptor : BeanMatcherAsserts.propertiesOf(bean)) {
                Method getter = descriptor.getReadMethod();
                if (getter == null) continue;
                propertyTerms.add(BeanMatcherAsserts.propertyValueOf(descriptor.getDisplayName(), Optional.ofNullable(getter.invoke(bean, new Object[0])).map(Object::toString).orElse("null")));
            }
            return StringUtils.join((Object[])new List[]{propertyTerms});
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not read bean properties", e);
        }
    }

    private static String mapDescription(Map<String, ? extends Object> map) {
        ArrayList<String> propertyTerms = new ArrayList<String>();
        for (String key : map.keySet()) {
            propertyTerms.add(BeanMatcherAsserts.propertyValueOf(key, map.get(key).toString()));
        }
        return StringUtils.join((Object[])new List[]{propertyTerms});
    }

    private static boolean isAMap(Object bean) {
        return Map.class.isAssignableFrom(bean.getClass());
    }

    public static <T> boolean matches(T bean, BeanMatcher ... matchers) {
        return BeanMatcherAsserts.matches(Arrays.asList(bean), matchers);
    }

    private static String propertyValueOf(String propertyName, String value) {
        return propertyName + " = '" + value + "'";
    }

    private static <T> PropertyDescriptor[] propertiesOf(T bean) throws IntrospectionException {
        return Introspector.getBeanInfo(bean.getClass(), Object.class).getPropertyDescriptors();
    }
}

