/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;
import net.thucydides.model.domain.Downloadables;

public class ReportData {
    private final String title;
    private final String contents;
    private final String path;
    private Boolean isEvidence;
    private String id;

    public ReportData(String title, String contents, String path) {
        this(title, contents, path, false);
    }

    public ReportData(String title, String contents, String path, Boolean isEvidence) {
        this.title = title;
        this.contents = contents;
        this.path = path;
        this.isEvidence = isEvidence;
        this.id = "report-data-" + String.valueOf(UUID.randomUUID());
    }

    public static ReportDataBuilder withTitle(String title) {
        return new ReportDataBuilder(title);
    }

    public String getTitle() {
        return this.title;
    }

    public String getContents() {
        return this.contents;
    }

    public String getPath() {
        return this.path;
    }

    public String getId() {
        return this.id;
    }

    public ReportData asEvidence(Boolean isEvidence) {
        return new ReportData(this.title, this.contents, this.path, isEvidence);
    }

    public Boolean isEvidence() {
        return this.isEvidence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportData that = (ReportData)o;
        if (this.title != null ? !this.title.equals(that.title) : that.title != null) {
            return false;
        }
        return this.contents != null ? this.contents.equals(that.contents) : that.contents == null;
    }

    public int hashCode() {
        int result = this.title != null ? this.title.hashCode() : 0;
        result = 31 * result + (this.contents != null ? this.contents.hashCode() : 0);
        return result;
    }

    public static class ReportDataBuilder {
        private final String title;
        private boolean asEvidence = false;

        public ReportDataBuilder(String title) {
            this.title = title;
        }

        public ReportDataBuilder asEvidence() {
            this.asEvidence = true;
            return this;
        }

        public ReportData andContents(String contents) {
            return new ReportData(this.title, contents, null);
        }

        public ReportData fromFile(Path source, Charset encoding) throws IOException {
            byte[] encoded = Files.readAllBytes(source);
            return new ReportData(this.title, new String(encoded, encoding), null, this.asEvidence);
        }

        public ReportData fromPath(Path path) throws IOException {
            String storedRelativePath = Downloadables.copyDownloadableFileFrom(path);
            return new ReportData(this.title, null, storedRelativePath);
        }
    }
}

