/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.batches;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.batches.BatchManager;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemVariableBasedBatchManager
implements BatchManager {
    private final AtomicInteger testCaseCount = new AtomicInteger(0);
    protected final int batchCount;
    protected final int batchNumber;
    private Set<String> registeredTestCases = new CopyOnWriteArraySet<String>();
    private final Logger logger = LoggerFactory.getLogger(SystemVariableBasedBatchManager.class);

    public SystemVariableBasedBatchManager(EnvironmentVariables environmentVariables) {
        this.batchCount = this.getBatchCountFrom(environmentVariables);
        this.batchNumber = ThucydidesSystemProperty.THUCYDIDES_BATCH_NUMBER.integerFrom(environmentVariables, 0);
    }

    private int getBatchCountFrom(EnvironmentVariables environmentVariables) {
        int batchCountValue = ThucydidesSystemProperty.THUCYDIDES_BATCH_SIZE.integerFrom(environmentVariables, 0);
        if (batchCountValue == 0) {
            batchCountValue = ThucydidesSystemProperty.THUCYDIDES_BATCH_COUNT.integerFrom(environmentVariables, 0);
        }
        return batchCountValue;
    }

    @Override
    public int getCurrentTestCaseNumber() {
        return this.testCaseCount.get();
    }

    @Override
    public void registerTestCase(Class<?> klass) {
        String testCaseName = klass.getName();
        this.registerTestCaseIfNew(testCaseName);
    }

    @Override
    public void registerTestCase(String testCaseName) {
        this.registerTestCaseIfNew(testCaseName);
    }

    private synchronized void registerTestCaseIfNew(String testCaseName) {
        if (!this.registeredTestCases.contains(testCaseName)) {
            this.registeredTestCases.add(testCaseName);
            this.testCaseCount.getAndIncrement();
        }
    }

    @Override
    public boolean shouldExecuteThisTest(int testCount) {
        if (this.batchCount > 0) {
            return this.testCaseCount.get() % this.batchCount == this.getActualBatchNumber();
        }
        return true;
    }

    protected int getActualBatchNumber() {
        return this.batchNumber % this.batchCount;
    }
}

