/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.model.cucumber;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;

public class FeatureFileFinder {
    private String directoryPath;

    public FeatureFileFinder(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public Stream<File> findFeatureFiles() throws IOException {
        try {
            return Files.walk(Paths.get(".", new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(dir -> !dir.getFileName().toString().equals("build")).filter(dir -> !dir.getFileName().toString().equals("target")).map(dir -> dir.resolve(this.directoryPath)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).flatMap(this::findFeatureFilesInDirectory).distinct();
        }
        catch (IllegalStateException e) {
            throw new IOException("Error parsing the cucumber feature file directories: " + e.getMessage(), e);
        }
    }

    private Stream<File> findFeatureFilesInDirectory(Path dir) {
        try {
            return Files.walk(dir, new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).filter(file -> file.getName().endsWith(".feature"));
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading files in directory: " + String.valueOf(dir), e);
        }
    }
}

