/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.matchers;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.model.matchers.BeanCollectionMatcher;
import net.thucydides.model.matchers.dates.BeanFields;
import org.hamcrest.Matcher;

public class MaxFieldValueMatcher
implements BeanCollectionMatcher {
    private final String fieldName;
    private final Matcher<? extends Comparable> valueMatcher;

    public MaxFieldValueMatcher(String fieldName, Matcher<? extends Comparable> valueMatcher) {
        this.fieldName = fieldName;
        this.valueMatcher = valueMatcher;
    }

    @Override
    public boolean matches(Object target) {
        return this.matches((Collection)target);
    }

    @Override
    public <T> boolean matches(Collection<T> elements) {
        Comparable maximumValue = null;
        try {
            List fieldValues = elements.stream().map(element -> (Comparable)BeanFields.fieldValueIn(element).forField(this.fieldName)).collect(Collectors.toList());
            maximumValue = (Comparable)Collections.max(fieldValues);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not find property value for " + this.fieldName);
        }
        return this.valueMatcher.matches((Object)maximumValue);
    }

    public String toString() {
        return "the maximum " + this.fieldName + " " + this.valueMatcher.toString();
    }
}

