/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.nio.file.Path;
import java.util.List;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.issues.IssueTracking;
import net.thucydides.model.issues.SystemPropertiesIssueTracking;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.AggregateRequirementsService;
import net.thucydides.model.requirements.BaseRequirementsService;
import net.thucydides.model.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.model.requirements.Requirements;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.TestOutcomeRequirementsTagProvider;
import net.thucydides.model.requirements.reports.FileSystemRequirmentsOutcomeFactory;
import net.thucydides.model.requirements.reports.RequirementsOutcomeFactory;
import net.thucydides.model.util.EnvironmentVariables;

public class AggregateRequirements
implements Requirements {
    private final BaseRequirementsService requirementsService;
    private final RequirementsOutcomeFactory requirementsOutcomeFactory;

    public AggregateRequirements(Path jsonOutcomes, String featureFilesDirectory) {
        this(jsonOutcomes, featureFilesDirectory, SystemEnvironmentVariables.createEnvironmentVariables());
    }

    public AggregateRequirements(Path jsonOutcomes, String featureFilesDirectory, EnvironmentVariables environmentVariables) {
        this.requirementsService = new AggregateRequirementsService(environmentVariables, new FileSystemRequirementsTagProvider(featureFilesDirectory, environmentVariables), new TestOutcomeRequirementsTagProvider(environmentVariables).fromSourceDirectory(jsonOutcomes));
        this.requirementsOutcomeFactory = new FileSystemRequirmentsOutcomeFactory(environmentVariables, (IssueTracking)new SystemPropertiesIssueTracking(environmentVariables), new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, (RequirementsService)this.requirementsService), this.requirementsService);
    }

    @Override
    public RequirementsOutcomeFactory getRequirementsOutcomeFactory() {
        return this.requirementsOutcomeFactory;
    }

    @Override
    public BaseRequirementsService getRequirementsService() {
        return this.requirementsService;
    }

    @Override
    public List<String> getTypes() {
        return this.requirementsService.getRequirementTypes();
    }
}

