/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.reports;

import net.thucydides.model.domain.NumericalFormatter;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.requirements.reports.RequirementsProportionCounter;

public class RequirementsPercentageFormatter {
    private final RequirementsProportionCounter counter;
    private final NumericalFormatter formatter;

    public RequirementsPercentageFormatter(RequirementsProportionCounter counter) {
        this.counter = counter;
        this.formatter = new NumericalFormatter();
    }

    public String withResult(String expectedResult) {
        double result = this.counter.withResult(expectedResult);
        return this.formatter.percentage(result, 1);
    }

    public String withResult(TestResult expectedResult) {
        double result = this.counter.withResult(expectedResult);
        return this.formatter.percentage(result, 1);
    }

    public String withIndeterminateResult() {
        double result = this.counter.withIndeterminateResult();
        return this.formatter.percentage(result, 1);
    }

    public String withSkippedOrIgnored() {
        double result = this.counter.withResult(TestResult.SKIPPED) + this.counter.withResult(TestResult.IGNORED);
        return this.formatter.percentage(result, 1);
    }

    public String withFailureOrError() {
        double result = this.counter.withResult(TestResult.ERROR) + this.counter.withResult(TestResult.FAILURE) + this.counter.withResult(TestResult.COMPROMISED);
        return this.formatter.percentage(result, 1);
    }
}

