/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.matchers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.model.domain.screenshots.Screenshot;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class ScreenshotHasFilenamesMatcher
extends TypeSafeMatcher<List<Screenshot>> {
    private final List<String> expectedFilenames;

    public ScreenshotHasFilenamesMatcher(String ... expectedFilenames) {
        this.expectedFilenames = Arrays.asList(expectedFilenames);
    }

    public boolean matchesSafely(List<Screenshot> screenshots) {
        List screenshotFilenames = screenshots.stream().map(Screenshot::getFilename).collect(Collectors.toList());
        for (String expectedFilename : this.expectedFilenames) {
            if (screenshotFilenames.contains(expectedFilename)) continue;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("screenshots called ").appendText(Arrays.toString(this.expectedFilenames.toArray()));
    }
}

