/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.model.buildinfo;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.JavaType;
import io.cucumber.core.internal.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.serenitybdd.model.di.ModelInfrastructure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildInfo {
    private static Map<String, BuildInfoSection> buildInfoSections = new ConcurrentHashMap<String, BuildInfoSection>();
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildInfo.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static BuildInfoSection section(String sectionName) {
        BuildInfo.load();
        return buildInfoSections.computeIfAbsent(sectionName, name -> new BuildInfoSection((String)name));
    }

    static void save() {
        File reportDir = ModelInfrastructure.getConfiguration().getOutputDirectory();
        if (!reportDir.exists()) {
            reportDir.mkdirs();
        }
        File file = new File(reportDir, "buildInfo.json");
        try {
            objectMapper.writeValue(file, buildInfoSections);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to save build info", (Throwable)e);
        }
    }

    public static void clear() {
        buildInfoSections.clear();
    }

    public static void load() {
        File reportDir = ModelInfrastructure.getConfiguration().getOutputDirectory();
        File file = new File(reportDir, "buildInfo.json");
        if (file.exists()) {
            try {
                Map loadedSections = (Map)objectMapper.readValue(file, (JavaType)objectMapper.getTypeFactory().constructMapType(Map.class, String.class, BuildInfoSection.class));
                buildInfoSections.putAll(loadedSections);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to load build info", (Throwable)e);
            }
        }
    }

    public static List<String> getSections() {
        return buildInfoSections.keySet().stream().sorted().collect(Collectors.toList());
    }

    public static Map<String, String> getSection(String sectionName) {
        return buildInfoSections.getOrDefault(sectionName, new BuildInfoSection(sectionName)).getValues();
    }

    public static class BuildInfoSection {
        private String sectionName;
        private Map<String, String> values = new HashMap<String, String>();

        public BuildInfoSection() {
        }

        public BuildInfoSection(String sectionName) {
            this.sectionName = sectionName;
        }

        @JsonProperty(value="sectionName")
        public String getSectionName() {
            return this.sectionName;
        }

        public void setSectionName(String sectionName) {
            this.sectionName = sectionName;
        }

        @JsonProperty(value="values")
        public Map<String, String> getValues() {
            return this.values;
        }

        public void setValues(Map<String, String> values) {
            this.values = values;
        }

        public void setProperty(String property, String value) {
            this.values.put(property, value);
            BuildInfo.save();
        }
    }
}

