/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.steps;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import net.thucydides.model.domain.DataTable;
import net.thucydides.model.domain.Story;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.model.steps.ExecutedStepDescription;
import net.thucydides.model.steps.StepFailure;

public interface StepListener {
    public void testSuiteStarted(Class<?> var1);

    public void testSuiteStarted(Story var1);

    default public void testSuiteStarted(Class<?> testClass, String testCaseName) {
        this.testSuiteStarted(Story.called(testCaseName));
    }

    public void testSuiteFinished();

    public void testStarted(String var1);

    default public void testStarted(String description, ZonedDateTime startTime) {
        this.testStarted(description);
    }

    public void testStarted(String var1, String var2);

    default public void testStarted(String testName, String testMethod, String id, String scenarioId) {
        this.testStarted(testName, id);
    }

    public void testStarted(String var1, String var2, ZonedDateTime var3);

    public void testFinished(TestOutcome var1);

    default public void testFinished(TestOutcome result, boolean isInDataDrivenTest) {
        this.testFinished(result);
    }

    public void testFinished(TestOutcome var1, boolean var2, ZonedDateTime var3);

    public void testRetried();

    public void stepStarted(ExecutedStepDescription var1);

    default public void stepStarted(ExecutedStepDescription description, ZonedDateTime startTime) {
        this.stepStarted(description);
    }

    public void skippedStepStarted(ExecutedStepDescription var1);

    public void stepFailed(StepFailure var1);

    public void stepFailed(StepFailure var1, List<ScreenshotAndHtmlSource> var2);

    public void lastStepFailed(StepFailure var1);

    public void stepIgnored();

    public void stepPending();

    public void stepPending(String var1);

    public void stepFinished();

    default public void stepFinished(List<ScreenshotAndHtmlSource> screenshotList) {
        this.stepFinished(screenshotList, ZonedDateTime.now());
    }

    public void stepFinished(List<ScreenshotAndHtmlSource> var1, ZonedDateTime var2);

    public void testFailed(TestOutcome var1, Throwable var2);

    public void testIgnored();

    public void testSkipped();

    default public void testAborted() {
    }

    public void testPending();

    public void testIsManual();

    public void notifyScreenChange();

    public void useExamplesFrom(DataTable var1);

    public void addNewExamplesFrom(DataTable var1);

    public void exampleStarted(Map<String, String> var1);

    default public void exampleStarted(Map<String, String> data, ZonedDateTime time) {
        this.exampleStarted(data, ZonedDateTime.now());
    }

    default public void exampleStarted(Map<String, String> data, String exampleName) {
        this.exampleStarted(data);
    }

    default public void exampleStarted(Map<String, String> data, String exampleName, ZonedDateTime time) {
        this.exampleStarted(data);
    }

    public void exampleFinished();

    public void assumptionViolated(String var1);

    public void testRunFinished();

    public void takeScreenshots(List<ScreenshotAndHtmlSource> var1);

    public void takeScreenshots(TestResult var1, List<ScreenshotAndHtmlSource> var2);
}

