/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.util.List;
import java.util.Optional;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.requirements.BaseRequirementsService;
import net.thucydides.model.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.model.requirements.ReleaseProvider;
import net.thucydides.model.requirements.RequirementAncestry;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.RequirementsTagProvider;
import net.thucydides.model.requirements.RequirementsTree;
import net.thucydides.model.requirements.model.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRequirementsService
extends BaseRequirementsService
implements RequirementsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTagProvider.class);
    private final RequirementsTagProvider fileSystemRequirementsTagProvider;

    public FileSystemRequirementsService(String rootPath) {
        super(SystemEnvironmentVariables.currentEnvironmentVariables());
        this.fileSystemRequirementsTagProvider = new FileSystemRequirementsTagProvider(this.environmentVariables, rootPath);
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            this.requirements = this.fileSystemRequirementsTagProvider.getRequirements();
            RequirementAncestry.addParentsTo(this.requirements);
            this.indexRequirements();
            LOGGER.trace("\nREQUIREMENTS HIERARCHY LOADED FROM THE FILE SYSTEM:\n" + String.valueOf(RequirementsTree.from(this.requirements)));
        }
        return this.requirements;
    }

    @Override
    public void addRequirementTagsTo(TestOutcome outcome) {
        this.fileSystemRequirementsTagProvider.addRequirementTagsTo(outcome);
    }

    public List<RequirementsTagProvider> getRequirementsTagProviders() {
        return NewList.of(this.fileSystemRequirementsTagProvider);
    }

    @Override
    public Optional<ReleaseProvider> getReleaseProvider() {
        return Optional.empty();
    }
}

